/*
 * Decompiled with CFR 0.152.
 */
package io.alapierre.ksef.batch;

import io.alapierre.ksef.batch.BatchProcessingException;
import io.alapierre.ksef.batch.InvoiceSource;
import io.alapierre.ksef.batch.model.InvoiceItem;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FileInvoiceSource
implements InvoiceSource,
AutoCloseable {
    private final Path directory;
    private FileInvoiceIterator currentIterator;

    public FileInvoiceSource(Path directory) {
        this.directory = directory;
    }

    @Override
    public Iterator<InvoiceItem> iterator() {
        try {
            if (this.currentIterator != null) {
                this.currentIterator.closeStream();
            }
            this.currentIterator = new FileInvoiceIterator(Files.newDirectoryStream(this.directory));
            return this.currentIterator;
        }
        catch (IOException e) {
            throw new BatchProcessingException("Cannot open directory: " + String.valueOf(this.directory), e);
        }
    }

    @Override
    public void close() {
        if (this.currentIterator != null) {
            this.currentIterator.closeStream();
        }
    }

    static class FileInvoiceIterator
    implements Iterator<InvoiceItem> {
        private final DirectoryStream<Path> stream;
        private final Iterator<Path> files;
        private Path nextFile;

        FileInvoiceIterator(DirectoryStream<Path> stream) {
            this.stream = stream;
            this.files = stream.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.nextFile != null) {
                return true;
            }
            while (this.files.hasNext()) {
                Path candidate = this.files.next();
                if (!Files.isRegularFile(candidate, new LinkOption[0])) continue;
                this.nextFile = candidate;
                return true;
            }
            this.closeStream();
            return false;
        }

        @Override
        public InvoiceItem next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Path file = this.nextFile;
            this.nextFile = null;
            try {
                byte[] content = Files.readAllBytes(file);
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                byte[] hash = digest.digest(content);
                return new InvoiceItem(file.getFileName().toString(), file.getFileName().toString(), content, Base64.getEncoder().encodeToString(hash));
            }
            catch (IOException | NoSuchAlgorithmException e) {
                throw new BatchProcessingException("Cannot read file or compute hash: " + String.valueOf(file), e);
            }
        }

        private void closeStream() {
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

