/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpftspwatsp;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraint;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlPSV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlProofOfExistence;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessArchivalDataTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessBasicTimestamp;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.sav.MessageImprintDigestAlgorithmValidation;
import eu.europa.esig.dss.validation.process.vpfswatsp.POE;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.PastSignatureValidation;
import eu.europa.esig.dss.validation.process.vpftsp.checks.BasicTimestampValidationCheck;
import eu.europa.esig.dss.validation.process.vpftspwatsp.checks.AcceptableBasicTimestampValidationCheck;
import eu.europa.esig.dss.validation.process.vpftspwatsp.checks.MessageImprintDigestAlgorithmValidationCheck;
import eu.europa.esig.dss.validation.process.vpftspwatsp.checks.PastTimestampValidationCheck;
import eu.europa.esig.dss.validation.process.vpftspwatsp.checks.TimestampMessageImprintCheck;
import java.util.Date;
import java.util.Map;

public class ValidationProcessForTimestampsWithArchivalData
extends Chain<XmlValidationProcessArchivalDataTimestamp> {
    private final XmlValidationProcessBasicTimestamp vpftsp;
    private final TimestampWrapper timestamp;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;
    private final Date currentTime;
    private final ValidationPolicy policy;
    private final POEExtraction poe;

    public ValidationProcessForTimestampsWithArchivalData(I18nProvider i18nProvider, TimestampWrapper timestamp, XmlValidationProcessBasicTimestamp vpftsp, Map<String, XmlBasicBuildingBlocks> bbbs, Date currentTime, ValidationPolicy policy, POEExtraction poe) {
        super(i18nProvider, new XmlValidationProcessArchivalDataTimestamp());
        this.vpftsp = vpftsp;
        this.timestamp = timestamp;
        this.bbbs = bbbs;
        this.currentTime = currentTime;
        this.policy = policy;
        this.poe = poe;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.VPFTSPWATSP;
    }

    @Override
    protected void initChain() {
        XmlProofOfExistence lowestPOE = this.getLowestPOE();
        Date lowestPOETime = lowestPOE.getTime();
        ((XmlValidationProcessArchivalDataTimestamp)this.result).setProofOfExistence(lowestPOE);
        XmlConclusion basicTimestampConclusion = this.vpftsp.getConclusion();
        ChainItem<XmlValidationProcessArchivalDataTimestamp> item = this.firstItem = this.timestampBasicSignatureValidationAcceptable(this.vpftsp);
        if (ValidationProcessUtils.isAllowedBasicTimestampValidation(basicTimestampConclusion)) {
            item = item.setNextItem(this.timestampBasicSignatureValidationConclusive(this.timestamp, this.vpftsp));
            MessageImprintDigestAlgorithmValidation midav = this.timestampDigestAlgorithmValidation(this.timestamp, lowestPOETime);
            XmlSAV davResult = (XmlSAV)midav.execute();
            if (this.isValid((XmlConstraintsConclusion)this.vpftsp)) {
                item = item.setNextItem(this.messageImprintDigestAlgorithm(this.timestamp, davResult, lowestPOETime));
                if (this.isValid((XmlConstraintsConclusion)davResult)) {
                    item = item.setNextItem(this.timestampMessageImprint(this.timestamp));
                }
            } else {
                PastSignatureValidation psv = new PastSignatureValidation(this.i18nProvider, (TokenProxy)this.timestamp, this.bbbs, basicTimestampConclusion, this.poe, this.currentTime, this.policy, Context.TIMESTAMP);
                XmlPSV psvResult = (XmlPSV)psv.execute();
                XmlBasicBuildingBlocks tstBBB = this.bbbs.get(this.timestamp.getId());
                this.enrichBBBWithPSVConclusion(tstBBB, psvResult);
                item = item.setNextItem(this.pastTimestampValidation(this.timestamp, psvResult));
                if (this.isValid((XmlConstraintsConclusion)psvResult)) {
                    item = item.setNextItem(this.messageImprintDigestAlgorithm(this.timestamp, davResult, lowestPOETime));
                    if (this.isValid((XmlConstraintsConclusion)davResult)) {
                        item = item.setNextItem(this.timestampMessageImprint(this.timestamp));
                    }
                }
            }
        }
    }

    private XmlProofOfExistence getLowestPOE() {
        POE lowestPOE = this.poe.getLowestPOE(this.timestamp.getId());
        XmlProofOfExistence poe = new XmlProofOfExistence();
        poe.setTime(lowestPOE.getTime());
        return poe;
    }

    private ChainItem<XmlValidationProcessArchivalDataTimestamp> timestampBasicSignatureValidationAcceptable(XmlValidationProcessBasicTimestamp timestampValidationResult) {
        return new AcceptableBasicTimestampValidationCheck<XmlValidationProcessArchivalDataTimestamp>(this.i18nProvider, (XmlValidationProcessArchivalDataTimestamp)this.result, (XmlConstraintsConclusion)timestampValidationResult, this.getFailLevelConstraint());
    }

    private void enrichBBBWithPSVConclusion(XmlBasicBuildingBlocks bbb, XmlPSV psv) {
        bbb.setPSV(psv);
        XmlConclusion bbbConclusion = bbb.getConclusion();
        XmlConclusion psvConclusion = psv.getConclusion();
        bbbConclusion.setIndication(psvConclusion.getIndication());
        bbbConclusion.setSubIndication(psvConclusion.getSubIndication());
        bbbConclusion.getErrors().addAll(psvConclusion.getErrors());
        bbbConclusion.getWarnings().addAll(psvConclusion.getWarnings());
        bbbConclusion.getInfos().addAll(psvConclusion.getInfos());
    }

    private ChainItem<XmlValidationProcessArchivalDataTimestamp> timestampBasicSignatureValidationConclusive(TimestampWrapper timestampWrapper, XmlValidationProcessBasicTimestamp timestampValidationResult) {
        return new BasicTimestampValidationCheck<XmlValidationProcessArchivalDataTimestamp>(this.i18nProvider, (XmlValidationProcessArchivalDataTimestamp)this.result, timestampWrapper, timestampValidationResult, this.getWarnLevelConstraint());
    }

    private MessageImprintDigestAlgorithmValidation timestampDigestAlgorithmValidation(TimestampWrapper newestTimestamp, Date poeTime) {
        CryptographicConstraint cryptographicConstraint = this.policy.getSignatureCryptographicConstraint(Context.TIMESTAMP);
        return new MessageImprintDigestAlgorithmValidation(this.i18nProvider, poeTime, newestTimestamp.getMessageImprint().getDigestMethod(), cryptographicConstraint);
    }

    private ChainItem<XmlValidationProcessArchivalDataTimestamp> pastTimestampValidation(TimestampWrapper timestamp, XmlPSV xmlPSV) {
        return new PastTimestampValidationCheck<XmlValidationProcessArchivalDataTimestamp>(this.i18nProvider, (XmlValidationProcessArchivalDataTimestamp)this.result, timestamp, xmlPSV, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationProcessArchivalDataTimestamp> messageImprintDigestAlgorithm(TimestampWrapper timestampWrapper, XmlSAV davResult, Date poeTime) {
        return new MessageImprintDigestAlgorithmValidationCheck<XmlValidationProcessArchivalDataTimestamp>(this.i18nProvider, (XmlValidationProcessArchivalDataTimestamp)this.result, timestampWrapper, davResult, poeTime, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationProcessArchivalDataTimestamp> timestampMessageImprint(TimestampWrapper timestampWrapper) {
        return new TimestampMessageImprintCheck<XmlValidationProcessArchivalDataTimestamp>(this.i18nProvider, (XmlValidationProcessArchivalDataTimestamp)this.result, timestampWrapper, this.getWarnLevelConstraint());
    }

    @Override
    protected void collectMessages(XmlConclusion conclusion, XmlConstraint constraint) {
        if (!XmlBlockType.TST_BBB.equals((Object)constraint.getBlockType()) && !XmlBlockType.TST_PSV.equals((Object)constraint.getBlockType()) || this.policy.getTimestampValidConstraint() != null) {
            super.collectMessages(conclusion, constraint);
        }
    }

    @Override
    protected void collectAdditionalMessages(XmlConclusion conclusion) {
        if (!ValidationProcessUtils.isAllowedBasicTimestampValidation(this.vpftsp.getConclusion())) {
            conclusion.getWarnings().addAll(this.vpftsp.getConclusion().getWarnings());
            conclusion.getInfos().addAll(this.vpftsp.getConclusion().getInfos());
        }
    }
}

