/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.cc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.Level;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.AbstractCryptographicCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicConstraintWrapper;
import java.util.Date;

public class EncryptionAlgorithmAtValidationTimeCheck
extends AbstractCryptographicCheck {
    private final EncryptionAlgorithm encryptionAlgo;
    private final String keyLength;
    private final Date validationDate;
    private final CryptographicConstraintWrapper constraintWrapper;

    protected EncryptionAlgorithmAtValidationTimeCheck(I18nProvider i18nProvider, EncryptionAlgorithm encryptionAlgo, String keyLength, Date validationDate, XmlCC result, MessageTag position, CryptographicConstraintWrapper constraintWrapper) {
        super(i18nProvider, result, position, constraintWrapper.getAlgoExpirationDateLevel());
        this.encryptionAlgo = encryptionAlgo;
        this.keyLength = keyLength;
        this.validationDate = validationDate;
        this.constraintWrapper = constraintWrapper;
    }

    @Override
    protected boolean process() {
        Date expirationDate = this.constraintWrapper.getExpirationDate(this.encryptionAlgo, this.keyLength);
        return expirationDate == null || !expirationDate.before(this.validationDate);
    }

    @Override
    protected Level getLevel() {
        Date algoExpirationDate = this.constraintWrapper.getExpirationDate(this.encryptionAlgo, this.keyLength);
        Date cryptographicSuiteUpdateDate = this.constraintWrapper.getCryptographicSuiteUpdateDate();
        if (algoExpirationDate != null && cryptographicSuiteUpdateDate != null && cryptographicSuiteUpdateDate.before(algoExpirationDate)) {
            return this.constraintWrapper.getAlgoExpirationDateAfterUpdateLevel();
        }
        return super.getLevel();
    }

    @Override
    protected XmlMessage buildConstraintMessage() {
        return this.buildXmlMessage(MessageTag.ASCCM_AR, this.getName(this.encryptionAlgo));
    }

    @Override
    protected XmlMessage buildErrorMessage() {
        return this.buildXmlMessage(MessageTag.ASCCM_AR_ANS_AKSNR, this.getName(this.encryptionAlgo), this.keyLength, this.position);
    }
}

