/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav;

import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.MessageImprintCryptographicCheck;
import java.util.Date;

public class MessageImprintDigestAlgorithmValidation
extends Chain<XmlSAV> {
    private final DigestAlgorithm digestAlgorithm;
    private final Date currentTime;
    private final CryptographicConstraint constraint;

    public MessageImprintDigestAlgorithmValidation(I18nProvider i18nProvider, Date currentTime, DigestAlgorithm digestAlgorithm, CryptographicConstraint constraint) {
        super(i18nProvider, new XmlSAV());
        this.digestAlgorithm = digestAlgorithm;
        this.currentTime = currentTime;
        this.constraint = constraint;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.DAAV;
    }

    @Override
    protected void initChain() {
        this.firstItem = this.messageImprintCryptographic();
    }

    private ChainItem<XmlSAV> messageImprintCryptographic() {
        return new MessageImprintCryptographicCheck(this.i18nProvider, this.digestAlgorithm, (XmlSAV)this.result, this.currentTime, this.constraint);
    }
}

