/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlPSV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessArchivalData;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.AbstractPastTokenValidationCheck;

public class PastTimestampValidationCheck
extends AbstractPastTokenValidationCheck {
    private TimestampWrapper timestamp;

    public PastTimestampValidationCheck(I18nProvider i18nProvider, XmlValidationProcessArchivalData result, TimestampWrapper timestamp, XmlPSV xmlPSV, LevelConstraint constraint) {
        super(i18nProvider, result, (TokenProxy)timestamp, xmlPSV, constraint);
        this.timestamp = timestamp;
    }

    @Override
    protected XmlBlockType getBlockType() {
        return XmlBlockType.TST_PSV;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.PSV_IPTVC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.PSV_IPTVC_ANS;
    }

    @Override
    protected String buildAdditionalInfo() {
        String date = ValidationProcessUtils.getFormattedDate(this.timestamp.getProductionTime());
        return this.i18nProvider.getMessage(MessageTag.TIMESTAMP_VALIDATION, new Object[]{ValidationProcessUtils.getTimestampTypeMessageTag(this.timestamp.getType()), this.timestamp.getId(), date});
    }
}

