/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp;

import eu.europa.esig.dss.diagnostic.jaxb.XmlTimestampedObject;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.validation.process.vpfswatsp.POE;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;

public class POEComparator
implements Comparator<POE>,
Serializable {
    private static final long serialVersionUID = -4256501779628944917L;

    @Override
    public int compare(POE poe1, POE poe2) {
        int result = this.compareByTime(poe1, poe2);
        if (result == 0) {
            result = this.compareByType(poe1, poe2);
        }
        if (result == 0) {
            result = this.compareByTimestampType(poe1, poe2);
        }
        if (result == 0) {
            result = this.compareByTimestampedReferences(poe1, poe2);
        }
        return result;
    }

    private int compareByTime(POE poe1, POE poe2) {
        return poe1.getTime().compareTo(poe2.getTime());
    }

    private int compareByType(POE poe1, POE poe2) {
        if (poe1.isTimestampPoe() && !poe2.isTimestampPoe()) {
            return -1;
        }
        if (!poe1.isTimestampPoe() && poe2.isTimestampPoe()) {
            return 1;
        }
        return 0;
    }

    private int compareByTimestampType(POE poe1, POE poe2) {
        TimestampType poe1TstType = poe1.getTimestampType();
        TimestampType poe2TstType = poe2.getTimestampType();
        if (poe1TstType != null && poe2TstType != null) {
            return poe1TstType.compare(poe2TstType);
        }
        return 0;
    }

    private int compareByTimestampedReferences(POE poe1, POE poe2) {
        List<XmlTimestampedObject> poe1References = poe1.getTimestampedObjects();
        List<XmlTimestampedObject> poe2References = poe2.getTimestampedObjects();
        if (poe1References != null && poe2References != null) {
            if (poe1References.size() < poe2References.size()) {
                return -1;
            }
            if (poe1References.size() > poe2References.size()) {
                return 1;
            }
        }
        return 0;
    }

    public boolean before(POE poe1, POE poe2) {
        return this.compare(poe1, poe2) == -1;
    }
}

