/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfltvd;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCRS;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraint;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRAC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRevocationBasicValidation;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.xcv.crs.CertificateRevocationSelector;
import eu.europa.esig.dss.validation.process.vpfltvd.RevocationBasicValidationProcess;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.RevocationDataAcceptableCheck;
import java.util.Date;
import java.util.Map;

public class LongTermValidationCertificateRevocationSelector
extends CertificateRevocationSelector {
    private final DiagnosticData diagnosticData;
    protected final Map<String, XmlBasicBuildingBlocks> bbbs;
    protected final String tokenId;

    public LongTermValidationCertificateRevocationSelector(I18nProvider i18nProvider, CertificateWrapper certificate, Date currentTime, DiagnosticData diagnosticData, Map<String, XmlBasicBuildingBlocks> bbbs, String tokenId, ValidationPolicy validationPolicy) {
        super(i18nProvider, certificate, currentTime, validationPolicy);
        this.diagnosticData = diagnosticData;
        this.bbbs = bbbs;
        this.tokenId = tokenId;
    }

    protected LongTermValidationCertificateRevocationSelector(I18nProvider i18nProvider, CertificateWrapper certificate, Date currentTime, Map<String, XmlBasicBuildingBlocks> bbbs, String tokenId, ValidationPolicy validationPolicy) {
        this(i18nProvider, certificate, currentTime, null, bbbs, tokenId, validationPolicy);
    }

    @Override
    protected ChainItem<XmlCRS> verifyRevocationData(ChainItem<XmlCRS> item, CertificateRevocationWrapper revocationWrapper) {
        XmlConclusion revocationBBBConclusion = this.getRevocationBBBConclusion(revocationWrapper);
        if (revocationBBBConclusion != null) {
            if (item == null) {
                this.firstItem = this.revocationBasicValidationAcceptable(revocationWrapper.getId(), revocationBBBConclusion);
                item = this.firstItem;
            } else {
                item = item.setNextItem(this.revocationBasicValidationAcceptable(revocationWrapper.getId(), revocationBBBConclusion));
            }
            if (ValidationProcessUtils.isAllowedBasicRevocationDataValidation(revocationBBBConclusion)) {
                item = super.verifyRevocationData(item, revocationWrapper);
            }
        }
        boolean allowedBBB = ValidationProcessUtils.isAllowedBasicRevocationDataValidation(revocationBBBConclusion);
        Boolean validity = (Boolean)this.revocationDataValidityMap.get(revocationWrapper);
        validity = validity == null ? Boolean.valueOf(allowedBBB) : Boolean.valueOf(validity != false && allowedBBB);
        this.revocationDataValidityMap.put(revocationWrapper, validity);
        return item;
    }

    protected XmlConclusion getRevocationBBBConclusion(CertificateRevocationWrapper revocationWrapper) {
        RevocationBasicValidationProcess rbvp = new RevocationBasicValidationProcess(this.i18nProvider, this.diagnosticData, (RevocationWrapper)revocationWrapper, this.bbbs);
        XmlRevocationBasicValidation revocationBasicValidationResult = (XmlRevocationBasicValidation)rbvp.execute();
        return revocationBasicValidationResult.getConclusion();
    }

    @Override
    protected XmlRAC getRevocationAcceptanceValidationResult(CertificateRevocationWrapper revocationWrapper) {
        return this.getRevocationAcceptanceValidationResult(revocationWrapper.getId());
    }

    private XmlRAC getRevocationAcceptanceValidationResult(String revocationId) {
        XmlBasicBuildingBlocks tokenBBB = this.bbbs.get(this.tokenId);
        return ValidationProcessUtils.getRevocationAcceptanceCheckerResult(tokenBBB, this.certificate.getId(), revocationId);
    }

    private ChainItem<XmlCRS> revocationBasicValidationAcceptable(String revocationId, XmlConclusion revocationBBBConclusion) {
        return new RevocationDataAcceptableCheck<XmlCRS>(this.i18nProvider, (XmlCRS)this.result, revocationId, revocationBBBConclusion, this.getWarnLevelConstraint());
    }

    @Override
    protected void collectMessages(XmlConclusion conclusion, XmlConstraint constraint) {
        XmlRAC xmlRAC;
        if (XmlBlockType.REV_BBB.equals((Object)constraint.getBlockType()) && !this.isValid(this.result)) {
            this.collectMessagesForBBB(conclusion, constraint);
        }
        if (XmlBlockType.RAC.equals((Object)constraint.getBlockType()) && !this.isValid(this.result) && (xmlRAC = this.getRevocationAcceptanceValidationResult(constraint.getId())) != null) {
            this.collectAllMessages(conclusion, xmlRAC.getConclusion());
        }
        super.collectMessages(conclusion, constraint);
    }

    private void collectMessagesForBBB(XmlConclusion conclusion, XmlConstraint constraint) {
        super.collectMessages(conclusion, constraint);
        XmlBasicBuildingBlocks xmlBasicBuildingBlocks = this.bbbs.get(constraint.getId());
        this.collectAllMessages(conclusion, xmlBasicBuildingBlocks.getConclusion());
    }
}

