/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust.consistency;

import eu.europa.esig.dss.diagnostic.TrustedServiceWrapper;
import eu.europa.esig.dss.enumerations.ServiceQualification;
import eu.europa.esig.dss.validation.process.qualification.trust.consistency.TrustedServiceCondition;
import java.util.List;
import java.util.stream.Stream;

class TrustedServiceUsageConsistency
implements TrustedServiceCondition {
    TrustedServiceUsageConsistency() {
    }

    @Override
    public boolean isConsistent(TrustedServiceWrapper trustedService) {
        List capturedQualifiers = trustedService.getCapturedQualifiers();
        boolean qcForEsig = ServiceQualification.isQcForEsig((List)capturedQualifiers);
        boolean qcForEseal = ServiceQualification.isQcForEseal((List)capturedQualifiers);
        boolean qcForWSA = ServiceQualification.isQcForWSA((List)capturedQualifiers);
        boolean noneOfThem = !qcForEsig && !qcForEseal && !qcForWSA;
        boolean onlyOneOfThem = Stream.of(qcForEsig, qcForEseal, qcForWSA).filter(b -> b).count() == 1L;
        return noneOfThem || onlyOneOfThem;
    }
}

