/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlTLAnalysis;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedList;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.enumerations.TSLTypeEnum;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;

public class TLMRACheck
extends ChainItem<XmlTLAnalysis> {
    private final XmlTrustedList currentTL;

    public TLMRACheck(I18nProvider i18nProvider, XmlTLAnalysis result, XmlTrustedList currentTL, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.currentTL = currentTL;
    }

    @Override
    protected boolean process() {
        return this.currentTL.isMra() == null || this.currentTL.isMra() == false;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.QUAL_TL_IMRA;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        XmlTrustedList parentTL = this.currentTL.getParent();
        if (parentTL != null) {
            String tslType = parentTL.getTSLType();
            if (TSLTypeEnum.EUlistofthelists.getUri().equals(tslType)) {
                return MessageTag.QUAL_TL_IMRA_ANS_V1;
            }
            if (TSLTypeEnum.AdESlistofthelists.getUri().equals(tslType)) {
                return MessageTag.QUAL_TL_IMRA_ANS_V2;
            }
        }
        return MessageTag.QUAL_TL_IMRA_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return null;
    }
}

