/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.rfc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlRFC;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.SubContext;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.policy.jaxb.Level;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.policy.jaxb.TimeConstraint;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.checks.NextUpdateCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.checks.RevocationDataFreshCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.checks.RevocationDataFreshCheckWithNullConstraint;
import java.util.Date;

public class RevocationFreshnessChecker
extends Chain<XmlRFC> {
    private static final MessageTag REVOCATION_POSITION = MessageTag.ACCM_POS_REVOC_SIG;
    private final RevocationWrapper revocationData;
    private final Date validationDate;
    private final ValidationPolicy policy;
    private final Context context;
    private final SubContext subContext;

    public RevocationFreshnessChecker(I18nProvider i18nProvider, RevocationWrapper revocationData, Date validationDate, Context context, SubContext subContext, ValidationPolicy policy) {
        super(i18nProvider, new XmlRFC());
        if (revocationData != null) {
            ((XmlRFC)this.result).setId(revocationData.getId());
        }
        this.revocationData = revocationData;
        this.validationDate = validationDate;
        this.policy = policy;
        this.context = context;
        this.subContext = subContext;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.REVOCATION_FRESHNESS_CHECKER;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlRFC> item = null;
        if (this.revocationData != null) {
            ((XmlRFC)this.result).setId(this.revocationData.getId());
            TimeConstraint revocationFreshnessConstraint = this.policy.getRevocationFreshnessConstraint(this.context, this.subContext);
            if (revocationFreshnessConstraint == null || Level.IGNORE.equals((Object)revocationFreshnessConstraint.getLevel())) {
                switch (this.revocationData.getRevocationType()) {
                    case CRL: {
                        this.firstItem = this.crlNextUpdateCheck(this.revocationData);
                        item = this.firstItem;
                        break;
                    }
                    case OCSP: {
                        this.firstItem = this.ocspNextUpdateCheck(this.revocationData);
                        item = this.firstItem;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("The RevocationType '%s' is not supported!", this.revocationData.getRevocationType()));
                    }
                }
            }
            if (item == null) {
                this.firstItem = this.revocationDataFreshCheck(this.revocationData, revocationFreshnessConstraint);
                item = this.firstItem;
            } else {
                item = item.setNextItem(this.revocationDataFreshCheck(this.revocationData, revocationFreshnessConstraint));
            }
            item = item.setNextItem(this.revocationCryptographic(this.revocationData));
        }
    }

    private ChainItem<XmlRFC> crlNextUpdateCheck(RevocationWrapper revocationData) {
        LevelConstraint constraint = this.policy.getCRLNextUpdatePresentConstraint(this.context, this.subContext);
        return new NextUpdateCheck(this.i18nProvider, (XmlRFC)this.result, revocationData, constraint);
    }

    private ChainItem<XmlRFC> ocspNextUpdateCheck(RevocationWrapper revocationData) {
        LevelConstraint constraint = this.policy.getOCSPNextUpdatePresentConstraint(this.context, this.subContext);
        return new NextUpdateCheck(this.i18nProvider, (XmlRFC)this.result, revocationData, constraint);
    }

    private ChainItem<XmlRFC> revocationDataFreshCheck(RevocationWrapper revocationData, TimeConstraint revocationFreshnessConstraint) {
        if (revocationFreshnessConstraint != null) {
            return new RevocationDataFreshCheck(this.i18nProvider, (XmlRFC)this.result, revocationData, this.validationDate, revocationFreshnessConstraint);
        }
        LevelConstraint constraint = this.policy.getRevocationFreshnessNextUpdateConstraint(this.context, this.subContext);
        return new RevocationDataFreshCheckWithNullConstraint(this.i18nProvider, (XmlRFC)this.result, revocationData, this.validationDate, constraint);
    }

    private ChainItem<XmlRFC> revocationCryptographic(RevocationWrapper revocationData) {
        CryptographicConstraint cryptographicConstraint = this.policy.getSignatureCryptographicConstraint(Context.REVOCATION);
        return new CryptographicCheck<XmlRFC>(this.i18nProvider, (XmlRFC)this.result, (TokenProxy)revocationData, REVOCATION_POSITION, this.validationDate, cryptographicConstraint);
    }
}

