/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;

public class ProspectiveCertificateChainCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final CertificateWrapper certificate;
    private final Context context;

    public ProspectiveCertificateChainCheck(I18nProvider i18nProvider, T result, CertificateWrapper certificate, Context context, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.certificate = certificate;
        this.context = context;
    }

    @Override
    protected boolean process() {
        return this.certificate.isTrusted() || this.certificate.isTrustedChain();
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_CCCBB;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        switch (this.context) {
            case SIGNATURE: 
            case COUNTER_SIGNATURE: {
                return MessageTag.BBB_XCV_CCCBB_SIG_ANS;
            }
            case TIMESTAMP: {
                return MessageTag.BBB_XCV_CCCBB_TSP_ANS;
            }
            case REVOCATION: {
                return MessageTag.BBB_XCV_CCCBB_REV_ANS;
            }
        }
        return MessageTag.BBB_XCV_CCCBB_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.NO_CERTIFICATE_CHAIN_FOUND;
    }
}

