/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.cv;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCV;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.cv.checks.ManifestEntryExistenceCheck;
import eu.europa.esig.dss.validation.process.bbb.cv.checks.ReferenceDataExistenceCheck;
import eu.europa.esig.dss.validation.process.bbb.cv.checks.ReferenceDataIntactCheck;
import eu.europa.esig.dss.validation.process.bbb.cv.checks.SignatureIntactCheck;
import java.util.Collection;
import java.util.List;

public class CryptographicVerification
extends Chain<XmlCV> {
    private final TokenProxy token;
    private final ValidationPolicy validationPolicy;
    private final Context context;

    public CryptographicVerification(I18nProvider i18nProvider, TokenProxy token, Context context, ValidationPolicy validationPolicy) {
        super(i18nProvider, new XmlCV());
        this.token = token;
        this.context = context;
        this.validationPolicy = validationPolicy;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.CRYPTOGRAPHIC_VERIFICATION;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlCV> item = null;
        List digestMatchers = this.token.getDigestMatchers();
        if (Utils.isCollectionNotEmpty((Collection)digestMatchers)) {
            for (XmlDigestMatcher digestMatcher : digestMatchers) {
                ChainItem<XmlCV> referenceDataFound = this.referenceDataFound(digestMatcher);
                if (item == null) {
                    item = referenceDataFound;
                    this.firstItem = item;
                } else {
                    item = item.setNextItem(referenceDataFound);
                }
                item = item.setNextItem(this.referenceDataIntact(digestMatcher));
            }
        }
        if (this.containsManifest(digestMatchers)) {
            ChainItem<XmlCV> manifestEntryExistence = this.manifestEntryExistence(digestMatchers);
            if (item == null) {
                item = manifestEntryExistence;
                this.firstItem = item;
            } else {
                item = item.setNextItem(manifestEntryExistence);
            }
        }
        ChainItem<XmlCV> signatureIntact = this.signatureIntact();
        if (item == null) {
            this.firstItem = item = signatureIntact;
        } else {
            item = item.setNextItem(signatureIntact);
        }
    }

    private boolean containsManifest(List<XmlDigestMatcher> digestMatchers) {
        for (XmlDigestMatcher xmlDigestMatcher : digestMatchers) {
            if (!DigestMatcherType.MANIFEST.equals((Object)xmlDigestMatcher.getType())) continue;
            return true;
        }
        return false;
    }

    private ChainItem<XmlCV> referenceDataFound(XmlDigestMatcher digestMatcher) {
        LevelConstraint constraint = this.validationPolicy.getReferenceDataExistenceConstraint(this.context);
        return new ReferenceDataExistenceCheck(this.i18nProvider, (XmlCV)this.result, digestMatcher, constraint);
    }

    private ChainItem<XmlCV> referenceDataIntact(XmlDigestMatcher digestMatcher) {
        LevelConstraint constraint = this.validationPolicy.getReferenceDataIntactConstraint(this.context);
        return new ReferenceDataIntactCheck(this.i18nProvider, (XmlCV)this.result, digestMatcher, constraint);
    }

    private ChainItem<XmlCV> manifestEntryExistence(List<XmlDigestMatcher> digestMatchers) {
        LevelConstraint constraint = this.validationPolicy.getManifestEntryObjectExistenceConstraint(this.context);
        return new ManifestEntryExistenceCheck(this.i18nProvider, (XmlCV)this.result, digestMatchers, constraint);
    }

    private ChainItem<XmlCV> signatureIntact() {
        LevelConstraint constraint = this.validationPolicy.getSignatureIntactConstraint(this.context);
        return new SignatureIntactCheck<XmlCV>(this.i18nProvider, (XmlCV)this.result, this.token, this.context, constraint);
    }
}

