/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.reference;

import eu.europa.esig.dss.xades.reference.XPathTransform;
import eu.europa.esig.dss.xml.common.definition.DSSElement;
import eu.europa.esig.dss.xml.common.definition.DSSNamespace;
import eu.europa.esig.dss.xml.utils.DomUtils;
import eu.europa.esig.xades.definition.XAdESNamespace;
import eu.europa.esig.xmldsig.definition.XMLDSigAttribute;
import eu.europa.esig.xmldsig.definition.XMLDSigElement;
import eu.europa.esig.xmldsig.definition.XMLDSigNamespace;
import java.util.Objects;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XPath2FilterTransform
extends XPathTransform {
    private static final long serialVersionUID = -7152990450159701613L;
    private static final String FILTER_ATTRIBUTE = "Filter";
    private final String filter;

    public XPath2FilterTransform(String xPathExpression, String filter) {
        this(XMLDSigNamespace.NS, xPathExpression, filter);
    }

    public XPath2FilterTransform(DSSNamespace xmlDSigNamespace, String xPathExpression, String filter) {
        super(xmlDSigNamespace, "http://www.w3.org/2002/06/xmldsig-filter2", xPathExpression);
        Objects.requireNonNull(filter, "filter cannot be null!");
        this.filter = filter;
    }

    @Override
    public Element createTransform(Document document, Element parentNode) {
        Element transform = DomUtils.addElement((Document)document, (Element)parentNode, (DSSNamespace)this.namespace, (DSSElement)XMLDSigElement.TRANSFORM);
        transform.setAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName(), this.algorithm);
        Element xPathElement = DomUtils.addTextElement((Document)document, (Element)transform, (DSSNamespace)XAdESNamespace.XMLDSIG_FILTER2, (DSSElement)XMLDSigElement.XPATH, (String)this.xPathExpression);
        xPathElement.setPrefix(XAdESNamespace.XMLDSIG_FILTER2.getPrefix());
        xPathElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + XAdESNamespace.XMLDSIG_FILTER2.getPrefix(), XAdESNamespace.XMLDSIG_FILTER2.getUri());
        xPathElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + this.namespace.getPrefix(), this.namespace.getUri());
        xPathElement.setAttribute(FILTER_ATTRIBUTE, this.filter);
        return xPathElement;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.filter == null ? 0 : this.filter.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XPath2FilterTransform other = (XPath2FilterTransform)obj;
        return Objects.equals(this.filter, other.filter);
    }

    @Override
    public String toString() {
        return "XPath2FilterTransform [filter=" + this.filter + ", xPathExpression=" + this.xPathExpression + ", algorithm=" + this.algorithm + ", namespace=" + this.namespace + "]";
    }
}

