/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.reference;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.reference.Base64Transform;
import eu.europa.esig.dss.xades.reference.DSSReference;
import eu.europa.esig.dss.xades.reference.DSSTransform;
import eu.europa.esig.dss.xml.common.definition.DSSElement;
import eu.europa.esig.dss.xml.common.definition.DSSNamespace;
import eu.europa.esig.dss.xml.utils.DomUtils;
import eu.europa.esig.xmldsig.definition.XMLDSigAttribute;
import eu.europa.esig.xmldsig.definition.XMLDSigElement;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReferenceProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ReferenceProcessor.class);
    private XAdESSignatureParameters signatureParameters;

    public ReferenceProcessor() {
    }

    public ReferenceProcessor(XAdESSignatureParameters signatureParameters) {
        this.signatureParameters = signatureParameters;
    }

    public DSSDocument getReferenceOutput(DSSReference reference) {
        if (reference.getContents() instanceof DigestDocument) {
            return reference.getContents();
        }
        Node nodeToTransform = this.dereferenceNode(reference);
        if (nodeToTransform == null) {
            return reference.getContents();
        }
        List<DSSTransform> transforms = reference.getTransforms();
        if (this.isUniqueBase64Transform(transforms)) {
            return reference.getContents();
        }
        byte[] referenceOutputResult = DSSXMLUtils.applyTransforms(nodeToTransform, reference.getTransforms());
        if (LOG.isTraceEnabled()) {
            LOG.trace("Reference output : ");
            LOG.trace(new String(referenceOutputResult));
        }
        return new InMemoryDocument(referenceOutputResult);
    }

    private Node dereferenceNode(DSSReference reference) {
        Document document = this.getDocumentToTransform(reference);
        if (document != null && DSSXMLUtils.isSameDocumentReference(reference.getUri()) && !DomUtils.isXPointerQuery((String)reference.getUri())) {
            document = DomUtils.excludeComments((Node)document);
        }
        return this.getNodeToTransform(document, reference);
    }

    private Document getDocumentToTransform(DSSReference reference) {
        DSSDocument contents = reference.getContents();
        if (!DomUtils.isDOM((DSSDocument)contents)) {
            return null;
        }
        return DomUtils.buildDOM((DSSDocument)contents);
    }

    private Node getNodeToTransform(Document doc, DSSReference reference) {
        String targetId;
        Element elementById;
        String uri = reference.getUri();
        if (this.signatureParameters != null && this.signatureParameters.isEmbedXML()) {
            Document doc2 = DomUtils.buildDOM();
            Element dom = DomUtils.createElementNS((Document)doc2, (DSSNamespace)this.signatureParameters.getXmldsigNamespace(), (DSSElement)XMLDSigElement.OBJECT);
            Element dom2 = DomUtils.createElementNS((Document)doc2, (DSSNamespace)this.signatureParameters.getXmldsigNamespace(), (DSSElement)XMLDSigElement.OBJECT);
            doc2.appendChild(dom2);
            dom2.appendChild(dom);
            dom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), DomUtils.getId((String)uri));
            DomUtils.adoptChildren((Element)dom, (Node)doc);
            return dom;
        }
        if (DomUtils.isElementReference((String)uri) && (elementById = DomUtils.getElementById((Node)doc, (String)(targetId = DomUtils.getId((String)uri)))) != null) {
            return elementById;
        }
        if (Utils.isCollectionNotEmpty(reference.getTransforms())) {
            return doc;
        }
        return null;
    }

    private boolean isUniqueBase64Transform(List<DSSTransform> transforms) {
        return transforms != null && transforms.size() == 1 && transforms.get(0) instanceof Base64Transform;
    }

    public void incorporateReferences(Element referenceContainer, List<DSSReference> references, DSSNamespace namespace) {
        if (Utils.isCollectionNotEmpty(references)) {
            Document documentDom = referenceContainer.getOwnerDocument();
            for (DSSReference dssReference : references) {
                String referenceType;
                String uri;
                Element referenceDom = DomUtils.createElementNS((Document)documentDom, (DSSNamespace)namespace, (DSSElement)XMLDSigElement.REFERENCE);
                referenceContainer.appendChild(referenceDom);
                if (dssReference.getId() != null) {
                    referenceDom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), dssReference.getId());
                }
                if ((uri = dssReference.getUri()) != null) {
                    referenceDom.setAttribute(XMLDSigAttribute.URI.getAttributeName(), uri);
                }
                if ((referenceType = dssReference.getType()) != null) {
                    referenceDom.setAttribute(XMLDSigAttribute.TYPE.getAttributeName(), referenceType);
                }
                DSSXMLUtils.incorporateTransforms(referenceDom, dssReference.getTransforms(), namespace);
                DSSXMLUtils.incorporateDigestMethod(referenceDom, dssReference.getDigestMethodAlgorithm(), namespace);
                DSSDocument documentAfterTransforms = this.getReferenceOutput(dssReference);
                String base64EncodedDigestBytes = documentAfterTransforms.getDigest(dssReference.getDigestMethodAlgorithm());
                DSSXMLUtils.incorporateDigestValue(referenceDom, base64EncodedDigestBytes, namespace);
            }
        }
    }
}

