/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades;

import eu.europa.esig.dss.utils.Utils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.apache.xml.security.utils.resolver.ResourceResolverContext;
import org.apache.xml.security.utils.resolver.implementations.ResolverFragment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnforcedResolverFragment
extends ResolverFragment {
    private static final Logger LOG = LoggerFactory.getLogger(EnforcedResolverFragment.class);
    private static final String XPATH_CHAR_FILTER = "()='[]:,*/ ";

    public boolean engineCanResolveURI(ResourceResolverContext context) {
        return this.checkValueForXpathInjection(context.uriToResolve) && super.engineCanResolveURI(context);
    }

    public boolean checkValueForXpathInjection(String xpathString) {
        if (Utils.isStringNotEmpty((String)xpathString)) {
            try {
                String decodedValue = URLDecoder.decode(xpathString, StandardCharsets.UTF_8.name());
                for (char c : decodedValue.toCharArray()) {
                    if (XPATH_CHAR_FILTER.indexOf(c) == -1) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Forbidden char '{}' detected", (Object)Character.valueOf(c));
                    }
                    return false;
                }
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn("Unable to decode '{}' : {}", (Object)xpathString, (Object)e.getMessage());
                return false;
            }
        }
        return true;
    }
}

