/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.definition.DSSElement;
import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigAttribute;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigElement;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.signature.SignatureExtension;
import eu.europa.esig.dss.signature.SignatureRequirementsChecker;
import eu.europa.esig.dss.signature.SigningOperation;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.validation.ValidationData;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XAdESProfileParameters;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.XAdESTimestampParameters;
import eu.europa.esig.dss.xades.definition.XAdESNamespaces;
import eu.europa.esig.dss.xades.definition.xades111.XAdES111Attribute;
import eu.europa.esig.dss.xades.definition.xades111.XAdES111Element;
import eu.europa.esig.dss.xades.definition.xades122.XAdES122Attribute;
import eu.europa.esig.dss.xades.definition.xades122.XAdES122Element;
import eu.europa.esig.dss.xades.definition.xades141.XAdES141Element;
import eu.europa.esig.dss.xades.signature.ExtensionBuilder;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.XMLDocumentValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XAdESLevelBaselineT
extends ExtensionBuilder
implements SignatureExtension<XAdESSignatureParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESLevelBaselineT.class);
    protected TSPSource tspSource;

    public XAdESLevelBaselineT(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    private void incorporateC14nMethod(Element parentDom, String signedInfoC14nMethod) {
        Element canonicalizationMethodDom = DomUtils.createElementNS((Document)this.documentDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.CANONICALIZATION_METHOD);
        canonicalizationMethodDom.setAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName(), signedInfoC14nMethod);
        parentDom.appendChild(canonicalizationMethodDom);
    }

    public DSSDocument extendSignatures(DSSDocument dssDocument, XAdESSignatureParameters params) throws DSSException {
        Objects.requireNonNull(dssDocument, "The document cannot be null");
        Objects.requireNonNull(this.tspSource, "The TSPSource cannot be null");
        this.params = params;
        XAdESProfileParameters context = params.getContext();
        if (LOG.isInfoEnabled()) {
            LOG.info("====> Extending: {}", (Object)(dssDocument.getName() == null ? "IN MEMORY DOCUMENT" : dssDocument.getName()));
        }
        this.documentValidator = new XMLDocumentValidator(dssDocument);
        this.documentValidator.setCertificateVerifier(this.certificateVerifier);
        this.documentValidator.setDetachedContents(params.getDetachedContents());
        this.documentDom = this.documentValidator.getRootElement();
        List<AdvancedSignature> signatures = this.documentValidator.getSignatures();
        if (Utils.isCollectionEmpty((Collection)signatures)) {
            throw new IllegalInputException("There is no signature to extend!");
        }
        List<AdvancedSignature> signaturesToExtend = signatures;
        SigningOperation operationKind = context.getOperationKind();
        if (SigningOperation.SIGN.equals((Object)operationKind)) {
            String signatureId = params.getDeterministicId();
            for (AdvancedSignature signature : signatures) {
                if (!signatureId.equals(signature.getDAIdentifier())) continue;
                signaturesToExtend = Collections.singletonList(signature);
                break;
            }
        }
        signaturesToExtend = this.assertNoEmbeddedSignaturesPresent(signaturesToExtend);
        this.extendSignatures(signaturesToExtend);
        return this.createXmlDocument();
    }

    private List<AdvancedSignature> assertNoEmbeddedSignaturesPresent(List<AdvancedSignature> signatures) {
        ArrayList<AdvancedSignature> result = new ArrayList<AdvancedSignature>();
        for (AdvancedSignature signature : signatures) {
            XAdESSignature xadesSignature = (XAdESSignature)signature;
            Element signatureElement = xadesSignature.getSignatureElement();
            if (!this.hasSignatureAsParent(signatureElement)) {
                result.add(signature);
                continue;
            }
            LOG.warn("The signature with Id '{}' has a ds:Signature parent within its XML tree! The signature will not be extended.", (Object)signature.getId());
        }
        return result;
    }

    private boolean hasSignatureAsParent(Element element) {
        for (Node parent = element.getParentNode(); parent != null; parent = parent.getParentNode()) {
            if (!XMLDSigElement.SIGNATURE.isSameTagName(parent.getLocalName()) || !XMLDSigElement.SIGNATURE.getURI().equals(parent.getNamespaceURI())) continue;
            return true;
        }
        return false;
    }

    protected void extendSignatures(List<AdvancedSignature> signatures) {
        SignatureRequirementsChecker signatureRequirementsChecker = new SignatureRequirementsChecker(this.certificateVerifier, (AbstractSignatureParameters)this.params);
        for (AdvancedSignature signature : signatures) {
            this.initializeSignatureBuilder((XAdESSignature)signature);
            if (!this.tLevelExtensionRequired()) continue;
            this.assertExtendSignatureToTPossible();
            this.assertSignatureValid(this.xadesSignature);
            Element levelBUnsignedProperties = (Element)this.unsignedSignaturePropertiesDom.cloneNode(true);
            signatureRequirementsChecker.assertSigningCertificateIsValid(signature);
            XAdESTimestampParameters signatureTimestampParameters = this.params.getSignatureTimestampParameters();
            String canonicalizationMethod = signatureTimestampParameters.getCanonicalizationMethod();
            byte[] canonicalizedValue = this.xadesSignature.getTimestampSource().getSignatureTimestampData(canonicalizationMethod);
            DigestAlgorithm timestampDigestAlgorithm = signatureTimestampParameters.getDigestAlgorithm();
            byte[] digestValue = DSSUtils.digest((DigestAlgorithm)timestampDigestAlgorithm, (byte[])canonicalizedValue);
            this.createXAdESTimeStampType(TimestampType.SIGNATURE_TIMESTAMP, canonicalizationMethod, digestValue);
            this.unsignedSignaturePropertiesDom = this.indentIfPrettyPrint(this.unsignedSignaturePropertiesDom, levelBUnsignedProperties);
        }
    }

    private boolean tLevelExtensionRequired() {
        return SignatureLevel.XAdES_BASELINE_T.equals((Object)this.params.getSignatureLevel()) || !this.xadesSignature.hasTProfile();
    }

    private void assertExtendSignatureToTPossible() {
        SignatureLevel signatureLevel = this.params.getSignatureLevel();
        if (SignatureLevel.XAdES_BASELINE_T.equals((Object)signatureLevel) && (this.xadesSignature.hasLTAProfile() || (this.xadesSignature.hasLTProfile() || this.xadesSignature.hasCProfile()) && !this.xadesSignature.areAllSelfSignedCertificates())) {
            throw new IllegalInputException(String.format("Cannot extend signature to '%s'. The signature is already extended with LT level.", signatureLevel));
        }
    }

    public void setTspSource(TSPSource tspSource) {
        this.tspSource = tspSource;
    }

    protected Element incorporateCertificateValues(Element parentDom, Collection<CertificateToken> certificatesToBeAdded) {
        Element certificateValuesDom = null;
        if (Utils.isCollectionNotEmpty(certificatesToBeAdded)) {
            certificateValuesDom = DomUtils.addElement((Document)this.documentDom, (Element)parentDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementCertificateValues());
            for (CertificateToken certificateToken : certificatesToBeAdded) {
                String base64EncodeCertificate = Utils.toBase64((byte[])certificateToken.getEncoded());
                DomUtils.addTextElement((Document)this.documentDom, (Element)certificateValuesDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementEncapsulatedX509Certificate(), (String)base64EncodeCertificate);
            }
        }
        return certificateValuesDom;
    }

    protected Element incorporateRevocationValues(Element parentDom, Collection<CRLToken> crlsToAdd, Collection<OCSPToken> ocspsToAdd) {
        Element revocationValuesDom = null;
        if (Utils.isCollectionNotEmpty(crlsToAdd) || Utils.isCollectionNotEmpty(ocspsToAdd)) {
            revocationValuesDom = DomUtils.addElement((Document)this.documentDom, (Element)parentDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementRevocationValues());
            this.incorporateCrlTokens(revocationValuesDom, crlsToAdd);
            this.incorporateOcspTokens(revocationValuesDom, ocspsToAdd);
        }
        return revocationValuesDom;
    }

    private void incorporateCrlTokens(Element parentDom, Collection<CRLToken> crlTokens) {
        if (crlTokens.isEmpty()) {
            return;
        }
        Element crlValuesDom = DomUtils.addElement((Document)this.documentDom, (Element)parentDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementCRLValues());
        for (RevocationToken revocationToken : crlTokens) {
            byte[] encodedCRL = revocationToken.getEncoded();
            String base64EncodedCRL = Utils.toBase64((byte[])encodedCRL);
            DomUtils.addTextElement((Document)this.documentDom, (Element)crlValuesDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementEncapsulatedCRLValue(), (String)base64EncodedCRL);
        }
    }

    private void incorporateOcspTokens(Element parentDom, Collection<OCSPToken> ocspTokens) {
        if (ocspTokens.isEmpty()) {
            return;
        }
        Element ocspValuesDom = DomUtils.addElement((Document)this.documentDom, (Element)parentDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementOCSPValues());
        for (RevocationToken revocationToken : ocspTokens) {
            byte[] encodedOCSP = revocationToken.getEncoded();
            String base64EncodedOCSP = Utils.toBase64((byte[])encodedOCSP);
            DomUtils.addTextElement((Document)this.documentDom, (Element)ocspValuesDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementEncapsulatedOCSPValue(), (String)base64EncodedOCSP);
        }
    }

    protected void incorporateCertificateValues(Element parentDom, Collection<CertificateToken> certificatesToBeAdded, String indent) {
        Element certificatesDom = this.incorporateCertificateValues(parentDom, certificatesToBeAdded);
        if (certificatesDom != null && indent != null) {
            DomUtils.setTextNode((Document)this.documentDom, (Element)parentDom, (String)indent);
            DSSXMLUtils.indentAndReplace(this.documentDom, certificatesDom);
        }
    }

    protected void incorporateRevocationValues(Element parentDom, Collection<CRLToken> crlsToAdd, Collection<OCSPToken> ocspsToAdd, String indent) {
        Element revocationDom = this.incorporateRevocationValues(parentDom, crlsToAdd, ocspsToAdd);
        if (revocationDom != null && indent != null) {
            DomUtils.setTextNode((Document)this.documentDom, (Element)parentDom, (String)indent);
            DSSXMLUtils.indentAndReplace(this.documentDom, revocationDom);
        }
    }

    protected String removeOldCertificateValues() {
        String text = null;
        Element toRemove = this.xadesSignature.getCertificateValues();
        if (toRemove != null) {
            text = this.removeNode(toRemove);
            this.xadesSignature.resetCertificateSource();
        }
        return text;
    }

    protected void removeOldRevocationValues() {
        Element toRemove = this.xadesSignature.getRevocationValues();
        if (toRemove != null) {
            this.removeNode(toRemove);
            this.xadesSignature.resetRevocationSources();
        }
    }

    protected String removeLastTimestampValidationData() {
        Element toRemove = this.xadesSignature.getLastTimestampValidationData();
        if (toRemove != null) {
            this.xadesSignature.resetCertificateSource();
            this.xadesSignature.resetRevocationSources();
            return this.removeNode(toRemove);
        }
        return null;
    }

    protected void incorporateTimestampValidationData(ValidationData validationDataForInclusion, String indent) {
        if (!validationDataForInclusion.isEmpty()) {
            Set certificateValuesToAdd = validationDataForInclusion.getCertificateTokens();
            Set crlsToAdd = validationDataForInclusion.getCrlTokens();
            Set ocspsToAdd = validationDataForInclusion.getOcspTokens();
            Element timeStampValidationDataDom = DomUtils.addElement((Document)this.documentDom, (Element)this.unsignedSignaturePropertiesDom, (DSSNamespace)this.getXades141Namespace(), (DSSElement)XAdES141Element.TIMESTAMP_VALIDATION_DATA);
            this.incorporateCertificateValues(timeStampValidationDataDom, certificateValuesToAdd, indent);
            this.incorporateRevocationValues(timeStampValidationDataDom, crlsToAdd, ocspsToAdd, indent);
            String id = "1";
            List archiveTimestamps = this.xadesSignature.getArchiveTimestamps();
            if (Utils.isCollectionNotEmpty((Collection)archiveTimestamps)) {
                TimestampToken timestampToken = (TimestampToken)archiveTimestamps.get(archiveTimestamps.size() - 1);
                id = timestampToken.getDSSIdAsString();
            }
            timeStampValidationDataDom.setAttribute("Id", "id-" + id);
            if (this.params.isPrettyPrint()) {
                DSSXMLUtils.indentAndReplace(this.documentDom, timeStampValidationDataDom);
            }
        }
    }

    protected void incorporateArchiveTimestamp() {
        XAdESTimestampParameters archiveTimestampParameters = this.params.getArchiveTimestampParameters();
        String canonicalizationMethod = archiveTimestampParameters.getCanonicalizationMethod();
        byte[] archiveTimestampData = this.xadesSignature.getTimestampSource().getArchiveTimestampData(canonicalizationMethod);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Data to be signed by the ArchiveTimestamp:");
            LOG.trace(new String(archiveTimestampData));
        }
        DigestAlgorithm timestampDigestAlgorithm = archiveTimestampParameters.getDigestAlgorithm();
        byte[] digestBytes = DSSUtils.digest((DigestAlgorithm)timestampDigestAlgorithm, (byte[])archiveTimestampData);
        this.createXAdESTimeStampType(TimestampType.ARCHIVE_TIMESTAMP, canonicalizationMethod, digestBytes);
    }

    protected void createXAdESTimeStampType(TimestampType timestampType, String timestampC14nMethod, byte[] digestValue) throws DSSException {
        Element timeStampDom;
        if ((XAdESNamespaces.XADES_111.isSameUri(this.getXadesNamespace().getUri()) || XAdESNamespaces.XADES_122.isSameUri(this.getXadesNamespace().getUri())) && TimestampType.SIGNATURE_TIMESTAMP != timestampType) {
            throw new UnsupportedOperationException("Signature Timestamp creation is only supported for XAdES 1.1.1 and 1.2.2");
        }
        XAdESTimestampParameters signatureTimestampParameters = this.params.getSignatureTimestampParameters();
        DigestAlgorithm timestampDigestAlgorithm = signatureTimestampParameters.getDigestAlgorithm();
        switch (timestampType) {
            case SIGNATURE_TIMESTAMP: {
                timeStampDom = DomUtils.addElement((Document)this.documentDom, (Element)this.unsignedSignaturePropertiesDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementSignatureTimeStamp());
                break;
            }
            case VALIDATION_DATA_TIMESTAMP: {
                if (this.params.isEn319132()) {
                    timeStampDom = DomUtils.addElement((Document)this.documentDom, (Element)this.unsignedSignaturePropertiesDom, (DSSNamespace)this.getXades141Namespace(), (DSSElement)XAdES141Element.SIG_AND_REFS_TIMESTAMP_V2);
                    break;
                }
                timeStampDom = DomUtils.addElement((Document)this.documentDom, (Element)this.unsignedSignaturePropertiesDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementSigAndRefsTimeStamp());
                break;
            }
            case VALIDATION_DATA_REFSONLY_TIMESTAMP: {
                if (this.params.isEn319132()) {
                    timeStampDom = DomUtils.addElement((Document)this.documentDom, (Element)this.unsignedSignaturePropertiesDom, (DSSNamespace)this.getXades141Namespace(), (DSSElement)XAdES141Element.REFS_ONLY_TIMESTAMP_V2);
                    break;
                }
                timeStampDom = DomUtils.addElement((Document)this.documentDom, (Element)this.unsignedSignaturePropertiesDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementRefsOnlyTimeStamp());
                break;
            }
            case ARCHIVE_TIMESTAMP: {
                timeStampDom = DomUtils.addElement((Document)this.documentDom, (Element)this.unsignedSignaturePropertiesDom, (DSSNamespace)this.getXades141Namespace(), (DSSElement)XAdES141Element.ARCHIVE_TIMESTAMP);
                timestampDigestAlgorithm = this.params.getArchiveTimestampParameters().getDigestAlgorithm();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported timestamp type : " + timestampType);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Timestamp generation: {} / {} / {}", new Object[]{timestampDigestAlgorithm.getName(), timestampC14nMethod, Utils.toBase64((byte[])digestValue)});
        }
        TimestampBinary timeStampToken = this.tspSource.getTimeStampResponse(timestampDigestAlgorithm, digestValue);
        String base64EncodedTimeStampToken = Utils.toBase64((byte[])DSSASN1Utils.getDEREncoded((TimestampBinary)timeStampToken));
        if (XAdESNamespaces.XADES_122.isSameUri(this.getXadesNamespace().getUri())) {
            this.incorporateXAdES122Include(timeStampDom);
        }
        String timestampId = UUID.randomUUID().toString();
        if (!XAdESNamespaces.XADES_111.isSameUri(this.getXadesNamespace().getUri())) {
            timeStampDom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), "TS-" + timestampId);
            this.incorporateC14nMethod(timeStampDom, timestampC14nMethod);
        } else {
            this.incorporateHashDataInfo(timeStampDom, timestampC14nMethod);
        }
        Element encapsulatedTimeStampDom = DomUtils.addElement((Document)this.documentDom, (Element)timeStampDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementEncapsulatedTimeStamp());
        encapsulatedTimeStampDom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), "ETS-" + timestampId);
        DomUtils.setTextNode((Document)this.documentDom, (Element)encapsulatedTimeStampDom, (String)base64EncodedTimeStampToken);
    }

    private void incorporateHashDataInfo(Element timeStampDom, String timestampC14nMethod) {
        Element hashDataInfoDom = DomUtils.addElement((Document)this.documentDom, (Element)timeStampDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)XAdES111Element.HASH_DATA_INFO);
        hashDataInfoDom.setAttribute(XAdES111Attribute.URI.getAttributeName(), '#' + this.xadesSignature.getId());
        Element transformsDom = DomUtils.addElement((Document)this.documentDom, (Element)hashDataInfoDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)XAdES111Element.TRANSFORMS);
        Element transformDom = DomUtils.addElement((Document)this.documentDom, (Element)transformsDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.TRANSFORM);
        transformDom.setAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName(), timestampC14nMethod);
    }

    private void incorporateXAdES122Include(Element timeStampDom) {
        Element includeDom = DomUtils.addElement((Document)this.documentDom, (Element)timeStampDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)XAdES122Element.INCLUDE);
        includeDom.setAttribute(XAdES122Attribute.URI.getAttributeName(), '#' + this.xadesSignature.getSignatureValueId());
    }

    protected void checkSignatureIntegrity() throws DSSException {
        SignatureCryptographicVerification signatureCryptographicVerification = this.xadesSignature.getSignatureCryptographicVerification();
        if (!signatureCryptographicVerification.isSignatureIntact()) {
            String errorMessage = signatureCryptographicVerification.getErrorMessage();
            throw new DSSException("Cryptographic signature verification has failed" + (errorMessage.isEmpty() ? "." : " / " + errorMessage));
        }
    }

    protected void assertDetachedDocumentsContainBinaries() {
        List detachedContents = this.params.getDetachedContents();
        if (Utils.isCollectionNotEmpty((Collection)detachedContents)) {
            for (DSSDocument detachedDocument : detachedContents) {
                if (!(detachedDocument instanceof DigestDocument)) continue;
                throw new IllegalArgumentException("XAdES-LTA requires complete binaries of signed documents! Extension with a DigestDocument is not possible.");
            }
        }
    }
}

