/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.utils.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PrettyPrintTransformer {
    private static final String NEW_LINE = "\n";
    private static final String SPACE = " ";
    private Document ownerDocument;
    private int indentAmount = 4;

    public void setIndentAmount(int indentAmount) {
        this.indentAmount = indentAmount;
    }

    public Node transform(Node nodeToTransform) {
        Node clonedNode = nodeToTransform.cloneNode(true);
        this.ownerDocument = clonedNode.getOwnerDocument();
        return this.indent(clonedNode, 1);
    }

    private Node indent(Node nodeToTransform, int level) {
        if (this.hasElementChilds(nodeToTransform)) {
            Node indentNode;
            String indentString = this.getIndentString(level);
            boolean skip = false;
            for (Node childNode = nodeToTransform.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                if (3 == childNode.getNodeType()) {
                    skip = true;
                    continue;
                }
                if (!skip && Utils.isStringNotEmpty((String)indentString)) {
                    indentNode = this.getIndentNode(indentString);
                    nodeToTransform.insertBefore(indentNode, childNode);
                }
                skip = false;
                childNode = this.indent(childNode, level + 1);
            }
            if (!skip) {
                indentString = this.getIndentString(level - 1);
                indentNode = this.getIndentNode(indentString);
                nodeToTransform.appendChild(indentNode);
            }
        }
        return nodeToTransform;
    }

    private Node getIndentNode(String indentString) {
        return this.ownerDocument.createTextNode(indentString);
    }

    private String getIndentString(int level) {
        int spacesExpected = level * this.indentAmount;
        StringBuilder stringBuilder = new StringBuilder(NEW_LINE);
        for (int ii = 0; ii < spacesExpected; ++ii) {
            stringBuilder.append(SPACE);
        }
        return stringBuilder.toString();
    }

    private boolean hasElementChilds(Node node) {
        if (node == null) {
            return false;
        }
        NodeList childNodes = node.getChildNodes();
        for (int ii = 0; ii < childNodes.getLength(); ++ii) {
            Node item = childNodes.item(ii);
            if (1 != item.getNodeType()) continue;
            return true;
        }
        return false;
    }
}

