/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades;

import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.identifier.TokenIdentifier;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.DSSObject;
import eu.europa.esig.dss.xades.XAdESProfileParameters;
import eu.europa.esig.dss.xades.XAdESTimestampParameters;
import eu.europa.esig.dss.xades.definition.XAdESNamespaces;
import eu.europa.esig.dss.xades.reference.DSSReference;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.w3c.dom.Document;

public class XAdESSignatureParameters
extends AbstractSignatureParameters<XAdESTimestampParameters> {
    private static final long serialVersionUID = 9131889715562901184L;
    private boolean addX509SubjectName;
    private List<DSSReference> dssReferences;
    private boolean embedXML;
    private boolean en319132 = true;
    private String keyInfoCanonicalizationMethod = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private String signedInfoCanonicalizationMethod = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private String signedPropertiesCanonicalizationMethod = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private boolean manifestSignature;
    private Document rootDocument;
    private byte[] signedAdESObject;
    private DigestAlgorithm signingCertificateDigestMethod = DigestAlgorithm.SHA512;
    private boolean signKeyInfo = false;
    private String xPathLocationString;
    private XPathElementPlacement xPathElementPlacement;
    private boolean prettyPrint = false;
    private DSSNamespace xmldsigNamespace = XAdESNamespaces.XMLDSIG;
    private DSSNamespace xadesNamespace = new DSSNamespace(XAdESNamespaces.XADES_132.getUri(), "xades");
    private DSSNamespace xades141Namespace = XAdESNamespaces.XADES_141;
    private List<DSSObject> objects;
    private DigestAlgorithm tokenReferencesDigestAlgorithm = DigestAlgorithm.SHA256;

    public void setSignatureLevel(SignatureLevel signatureLevel) {
        if (signatureLevel == null || SignatureForm.XAdES != signatureLevel.getSignatureForm()) {
            throw new IllegalArgumentException("Only XAdES form is allowed !");
        }
        super.setSignatureLevel(signatureLevel);
    }

    public void setSigningCertificateDigestMethod(DigestAlgorithm signingCertificateDigestMethod) {
        Objects.requireNonNull(signingCertificateDigestMethod, "SigningCertificateDigestMethod cannot be null!");
        this.signingCertificateDigestMethod = signingCertificateDigestMethod;
    }

    public DigestAlgorithm getSigningCertificateDigestMethod() {
        return this.signingCertificateDigestMethod;
    }

    public String getSignedInfoCanonicalizationMethod() {
        return this.signedInfoCanonicalizationMethod;
    }

    public void setSignedInfoCanonicalizationMethod(String signedInfoCanonicalizationMethod) {
        if (Utils.isStringEmpty((String)signedInfoCanonicalizationMethod)) {
            throw new IllegalArgumentException("Canonicalization cannot be empty! See EN 319 132-1: 3.1.2 Signature Generation.");
        }
        this.signedInfoCanonicalizationMethod = signedInfoCanonicalizationMethod;
    }

    public String getSignedPropertiesCanonicalizationMethod() {
        return this.signedPropertiesCanonicalizationMethod;
    }

    public void setSignedPropertiesCanonicalizationMethod(String signedPropertiesCanonicalizationMethod) {
        if (Utils.isStringEmpty((String)signedPropertiesCanonicalizationMethod)) {
            throw new IllegalArgumentException("Canonicalization cannot be empty! See EN 319 132-1: 3.1.2 Signature Generation.");
        }
        this.signedPropertiesCanonicalizationMethod = signedPropertiesCanonicalizationMethod;
    }

    public String getKeyInfoCanonicalizationMethod() {
        return this.keyInfoCanonicalizationMethod;
    }

    public void setKeyInfoCanonicalizationMethod(String keyInfoCanonicalizationMethod) {
        if (Utils.isStringEmpty((String)keyInfoCanonicalizationMethod)) {
            throw new IllegalArgumentException("Canonicalization cannot be empty! See EN 319 132-1: 3.1.2 Signature Generation.");
        }
        this.keyInfoCanonicalizationMethod = keyInfoCanonicalizationMethod;
    }

    public boolean isSignKeyInfo() {
        return this.signKeyInfo;
    }

    public void setSignKeyInfo(boolean signKeyInfo) {
        this.signKeyInfo = signKeyInfo;
    }

    public List<DSSReference> getReferences() {
        if (Utils.isCollectionNotEmpty(this.dssReferences)) {
            return this.dssReferences;
        }
        XAdESProfileParameters context = this.getContext();
        if (context != null) {
            return context.getReferences();
        }
        return null;
    }

    public void setReferences(List<DSSReference> references) {
        this.dssReferences = references;
    }

    public String getXPathLocationString() {
        return this.xPathLocationString;
    }

    public void setXPathLocationString(String xPathLocationString) {
        this.xPathLocationString = xPathLocationString;
    }

    public XPathElementPlacement getXPathElementPlacement() {
        return this.xPathElementPlacement;
    }

    public void setXPathElementPlacement(XPathElementPlacement xPathElementPlacement) {
        this.xPathElementPlacement = xPathElementPlacement;
    }

    public Document getRootDocument() {
        return this.rootDocument;
    }

    public void setRootDocument(Document rootDocument) {
        this.rootDocument = rootDocument;
    }

    public String getDeterministicId() {
        String deterministicId = this.getContext().getDeterministicId();
        if (deterministicId == null) {
            TokenIdentifier identifier = this.getSigningCertificate() == null ? null : this.getSigningCertificate().getDSSId();
            deterministicId = DSSUtils.getDeterministicId((Date)this.bLevel().getSigningDate(), (TokenIdentifier)identifier);
            this.getContext().setDeterministicId(deterministicId);
        }
        return deterministicId;
    }

    public XAdESProfileParameters getContext() {
        if (this.context == null) {
            this.context = new XAdESProfileParameters();
        }
        return (XAdESProfileParameters)this.context;
    }

    public boolean isEn319132() {
        return this.en319132;
    }

    public void setEn319132(boolean en319132) {
        this.en319132 = en319132;
    }

    public boolean isEmbedXML() {
        return this.embedXML;
    }

    public void setEmbedXML(boolean embedXML) {
        this.embedXML = embedXML;
    }

    public boolean isManifestSignature() {
        return this.manifestSignature;
    }

    public void setManifestSignature(boolean manifestSignature) {
        this.manifestSignature = manifestSignature;
    }

    public boolean isAddX509SubjectName() {
        return this.addX509SubjectName;
    }

    public void setAddX509SubjectName(boolean addX509SubjectName) {
        this.addX509SubjectName = addX509SubjectName;
    }

    public byte[] getSignedAdESObject() {
        return this.signedAdESObject;
    }

    public void setSignedAdESObject(byte[] signedAdESObject) {
        this.signedAdESObject = signedAdESObject;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public DSSNamespace getXmldsigNamespace() {
        return this.xmldsigNamespace;
    }

    public void setXmldsigNamespace(DSSNamespace xmldsigNamespace) {
        Objects.requireNonNull(xmldsigNamespace);
        String uri = xmldsigNamespace.getUri();
        if (!XAdESNamespaces.XMLDSIG.isSameUri(uri)) {
            throw new IllegalArgumentException("Not accepted URI");
        }
        this.xmldsigNamespace = xmldsigNamespace;
    }

    public DSSNamespace getXadesNamespace() {
        return this.xadesNamespace;
    }

    public void setXadesNamespace(DSSNamespace xadesNamespace) {
        Objects.requireNonNull(xadesNamespace);
        String uri = xadesNamespace.getUri();
        if (!(XAdESNamespaces.XADES_111.isSameUri(uri) || XAdESNamespaces.XADES_122.isSameUri(uri) || XAdESNamespaces.XADES_132.isSameUri(uri))) {
            throw new IllegalArgumentException("Not accepted URI");
        }
        this.xadesNamespace = xadesNamespace;
    }

    public DSSNamespace getXades141Namespace() {
        return this.xades141Namespace;
    }

    public void setXades141Namespace(DSSNamespace xades141Namespace) {
        Objects.requireNonNull(xades141Namespace);
        String uri = xades141Namespace.getUri();
        if (!XAdESNamespaces.XADES_141.isSameUri(uri)) {
            throw new IllegalArgumentException("Not accepted URI");
        }
        this.xades141Namespace = xades141Namespace;
    }

    public List<DSSObject> getObjects() {
        return this.objects;
    }

    public void setObjects(List<DSSObject> objects) {
        this.objects = objects;
    }

    public DigestAlgorithm getTokenReferencesDigestAlgorithm() {
        return this.tokenReferencesDigestAlgorithm;
    }

    public void setTokenReferencesDigestAlgorithm(DigestAlgorithm tokenReferencesDigestAlgorithm) {
        this.tokenReferencesDigestAlgorithm = tokenReferencesDigestAlgorithm;
    }

    public XAdESTimestampParameters getContentTimestampParameters() {
        if (this.contentTimestampParameters == null) {
            this.contentTimestampParameters = new XAdESTimestampParameters();
        }
        return (XAdESTimestampParameters)this.contentTimestampParameters;
    }

    public XAdESTimestampParameters getSignatureTimestampParameters() {
        if (this.signatureTimestampParameters == null) {
            this.signatureTimestampParameters = new XAdESTimestampParameters();
        }
        return (XAdESTimestampParameters)this.signatureTimestampParameters;
    }

    public XAdESTimestampParameters getArchiveTimestampParameters() {
        if (this.archiveTimestampParameters == null) {
            this.archiveTimestampParameters = new XAdESTimestampParameters();
        }
        return (XAdESTimestampParameters)this.archiveTimestampParameters;
    }

    public void reinit() {
        super.reinit();
        this.context = null;
    }

    public static enum XPathElementPlacement {
        XPathAfter,
        XPathFirstChildOf;

    }
}

