/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.evidencerecord;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCryptographicValidation;
import eu.europa.esig.dss.detailedreport.jaxb.XmlProofOfExistence;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessArchivalDataTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessEvidenceRecord;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.EvidenceRecordWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.EvidenceRecordOrigin;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.CryptographicSuite;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.cv.checks.AtLeastOneReferenceDataObjectFoundCheck;
import eu.europa.esig.dss.validation.process.bbb.cv.checks.ReferenceDataExistenceCheck;
import eu.europa.esig.dss.validation.process.bbb.cv.checks.ReferenceDataGroupCheck;
import eu.europa.esig.dss.validation.process.bbb.cv.checks.ReferenceDataIntactCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.DigestMatcherListCryptographicChainBuilder;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.TimestampValidationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.evidencerecord.checks.EvidenceRecordSignedAndTimestampedFilesCoveredCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.evidencerecord.checks.EvidenceRecordSignedFilesCoveredCheck;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class EvidenceRecordValidationProcess
extends Chain<XmlValidationProcessEvidenceRecord> {
    private final DiagnosticData diagnosticData;
    private final EvidenceRecordWrapper evidenceRecord;
    private final Collection<XmlTimestamp> xmlTimestamps;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;
    private final ValidationPolicy policy;
    private final Date currentTime;

    public EvidenceRecordValidationProcess(I18nProvider i18nProvider, DiagnosticData diagnosticData, EvidenceRecordWrapper evidenceRecord, Collection<XmlTimestamp> xmlTimestamps, Map<String, XmlBasicBuildingBlocks> bbbs, ValidationPolicy validationPolicy, Date currentTime) {
        super(i18nProvider, new XmlValidationProcessEvidenceRecord());
        this.diagnosticData = diagnosticData;
        this.evidenceRecord = evidenceRecord;
        this.xmlTimestamps = xmlTimestamps;
        this.bbbs = bbbs;
        this.policy = validationPolicy;
        this.currentTime = currentTime;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.VPER;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlValidationProcessEvidenceRecord> item = null;
        List digestMatchers = this.evidenceRecord.getDigestMatchers();
        if (Utils.isCollectionNotEmpty((Collection)digestMatchers)) {
            for (XmlDigestMatcher digestMatcher : digestMatchers) {
                if (DigestMatcherType.EVIDENCE_RECORD_ORPHAN_REFERENCE == digestMatcher.getType()) continue;
                ChainItem<XmlValidationProcessEvidenceRecord> referenceDataFound = this.referenceDataFound(digestMatcher);
                if (item == null) {
                    item = referenceDataFound;
                    this.firstItem = item;
                } else {
                    item = item.setNextItem(referenceDataFound);
                }
                if (!digestMatcher.isDataFound()) continue;
                item = item.setNextItem(this.referenceDataIntact(digestMatcher));
            }
            ChainItem<XmlValidationProcessEvidenceRecord> atLeastOneDataObjectFound = this.atLeastOneDataObjectFound(digestMatchers);
            if (item == null) {
                this.firstItem = item = atLeastOneDataObjectFound;
            } else {
                item = item.setNextItem(atLeastOneDataObjectFound);
            }
            item = item.setNextItem(this.referenceDataGroup(digestMatchers));
        }
        if (item == null) {
            throw new IllegalStateException("Evidence record shall contain at least one DigestMatcher!");
        }
        if ((EvidenceRecordOrigin.SIGNATURE == this.evidenceRecord.getOrigin() || EvidenceRecordOrigin.EXTERNAL == this.evidenceRecord.getOrigin()) && Utils.isCollectionNotEmpty((Collection)this.evidenceRecord.getCoveredSignatures())) {
            item = item.setNextItem(this.signedFilesCoveredCheck());
        }
        if (this.diagnosticData.isContainerInfoPresent() && this.coversSignatureOrTimestampOrEvidenceRecord(this.evidenceRecord)) {
            item = item.setNextItem(this.signedAndTimestampedFilesCoveredCheck());
        }
        XmlCryptographicValidation cryptographicValidation = null;
        XmlProofOfExistence lowestPOE = this.toXmlProofOfExistence(this.currentTime);
        List timestampsList = this.evidenceRecord.getTimestampList();
        if (Utils.isCollectionNotEmpty((Collection)timestampsList)) {
            for (TimestampWrapper timestamp : timestampsList) {
                XmlBasicBuildingBlocks bbbTsp = this.bbbs.get(timestamp.getId());
                XmlValidationProcessArchivalDataTimestamp timestampValidation = this.getTimestampValidation(timestamp);
                if (bbbTsp == null || timestampValidation == null) continue;
                item = item.setNextItem(this.timestampValidationConclusive(timestamp, timestampValidation));
                XmlConclusion timestampConclusion = timestampValidation.getConclusion();
                if (Indication.INDETERMINATE == timestampConclusion.getIndication() && (SubIndication.CRYPTO_CONSTRAINTS_FAILURE == timestampConclusion.getSubIndication() || SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE == timestampConclusion.getSubIndication())) {
                    XmlSAV sav = bbbTsp.getSAV();
                    if ((cryptographicValidation == null || cryptographicValidation.isSecure()) && sav != null) {
                        cryptographicValidation = sav.getCryptographicValidation();
                    }
                }
                if (this.isValid((XmlConstraintsConclusion)timestampValidation)) continue;
                ((XmlValidationProcessEvidenceRecord)this.result).setConclusion(timestampValidation.getConclusion());
                break;
            }
            if (((XmlValidationProcessEvidenceRecord)this.result).getConclusion() == null) {
                lowestPOE = this.toXmlProofOfExistence((TimestampWrapper)timestampsList.get(0));
            }
        }
        ((XmlValidationProcessEvidenceRecord)this.result).setProofOfExistence(lowestPOE);
        if (Utils.isCollectionNotEmpty((Collection)digestMatchers)) {
            CryptographicSuite cryptographicSuite = this.policy.getEvidenceRecordCryptographicConstraint();
            DigestMatcherListCryptographicChainBuilder<XmlValidationProcessEvidenceRecord> digestMatcherCCBuilder = new DigestMatcherListCryptographicChainBuilder<XmlValidationProcessEvidenceRecord>(this.i18nProvider, (XmlValidationProcessEvidenceRecord)this.result, digestMatchers, lowestPOE.getTime(), cryptographicSuite);
            item = digestMatcherCCBuilder.build(item);
            XmlCC failedCC = digestMatcherCCBuilder.getConcernedCC();
            if (failedCC != null && (cryptographicValidation == null || cryptographicValidation.isSecure() && !this.isValid((XmlConstraintsConclusion)failedCC))) {
                cryptographicValidation = this.getCryptographicValidation(failedCC, lowestPOE.getTime());
            }
        }
        ((XmlValidationProcessEvidenceRecord)this.result).setCryptographicValidation(cryptographicValidation);
    }

    private ChainItem<XmlValidationProcessEvidenceRecord> referenceDataFound(XmlDigestMatcher digestMatcher) {
        LevelRule constraint = this.policy.getEvidenceRecordDataObjectExistenceConstraint();
        return new ReferenceDataExistenceCheck<XmlValidationProcessEvidenceRecord>(this.i18nProvider, (XmlValidationProcessEvidenceRecord)this.result, digestMatcher, constraint);
    }

    private ChainItem<XmlValidationProcessEvidenceRecord> referenceDataIntact(XmlDigestMatcher digestMatcher) {
        LevelRule constraint = this.policy.getEvidenceRecordDataObjectIntactConstraint();
        return new ReferenceDataIntactCheck<XmlValidationProcessEvidenceRecord>(this.i18nProvider, (XmlValidationProcessEvidenceRecord)this.result, digestMatcher, constraint);
    }

    private ChainItem<XmlValidationProcessEvidenceRecord> atLeastOneDataObjectFound(List<XmlDigestMatcher> digestMatchers) {
        LevelRule constraint = this.policy.getEvidenceRecordDataObjectFoundConstraint();
        return new AtLeastOneReferenceDataObjectFoundCheck<XmlValidationProcessEvidenceRecord>(this.i18nProvider, (XmlValidationProcessEvidenceRecord)this.result, digestMatchers, constraint);
    }

    private ChainItem<XmlValidationProcessEvidenceRecord> referenceDataGroup(List<XmlDigestMatcher> digestMatchers) {
        LevelRule constraint = this.policy.getEvidenceRecordDataObjectGroupConstraint();
        return new ReferenceDataGroupCheck<XmlValidationProcessEvidenceRecord>(this.i18nProvider, (XmlValidationProcessEvidenceRecord)this.result, digestMatchers, constraint);
    }

    private ChainItem<XmlValidationProcessEvidenceRecord> signedFilesCoveredCheck() {
        LevelRule constraint = this.policy.getEvidenceRecordSignedFilesCoveredConstraint();
        return new EvidenceRecordSignedFilesCoveredCheck(this.i18nProvider, (XmlValidationProcessEvidenceRecord)this.result, this.evidenceRecord, constraint);
    }

    private ChainItem<XmlValidationProcessEvidenceRecord> signedAndTimestampedFilesCoveredCheck() {
        LevelRule constraint = this.policy.getEvidenceRecordContainerSignedAndTimestampedFilesCoveredConstraint();
        return new EvidenceRecordSignedAndTimestampedFilesCoveredCheck(this.i18nProvider, (XmlValidationProcessEvidenceRecord)this.result, this.diagnosticData, this.evidenceRecord, constraint);
    }

    private ChainItem<XmlValidationProcessEvidenceRecord> timestampValidationConclusive(TimestampWrapper timestampWrapper, XmlValidationProcessArchivalDataTimestamp timestampValidationResult) {
        return new TimestampValidationCheck<XmlValidationProcessEvidenceRecord>(this.i18nProvider, (XmlValidationProcessEvidenceRecord)this.result, timestampWrapper, timestampValidationResult, this.getFailLevelRule());
    }

    private XmlValidationProcessArchivalDataTimestamp getTimestampValidation(TimestampWrapper newestTimestamp) {
        for (XmlTimestamp xmlTimestamp : this.xmlTimestamps) {
            if (!Utils.areStringsEqual((String)xmlTimestamp.getId(), (String)newestTimestamp.getId())) continue;
            return xmlTimestamp.getValidationProcessArchivalDataTimestamp();
        }
        return null;
    }

    private XmlProofOfExistence toXmlProofOfExistence(Date date) {
        XmlProofOfExistence xmlPoe = new XmlProofOfExistence();
        xmlPoe.setTime(date);
        return xmlPoe;
    }

    private XmlProofOfExistence toXmlProofOfExistence(TimestampWrapper timestampWrapper) {
        XmlProofOfExistence xmlPoe = this.toXmlProofOfExistence(timestampWrapper.getProductionTime());
        xmlPoe.setTimestampId(timestampWrapper.getId());
        return xmlPoe;
    }

    private XmlCryptographicValidation getCryptographicValidation(XmlCC ccResult, Date validationTime) {
        XmlCryptographicValidation cryptographicValidation = new XmlCryptographicValidation();
        cryptographicValidation.setAlgorithm(ccResult.getVerifiedAlgorithm());
        cryptographicValidation.setNotAfter(ccResult.getNotAfter());
        cryptographicValidation.setSecure(this.isValid((XmlConstraintsConclusion)ccResult));
        cryptographicValidation.setValidationTime(validationTime);
        cryptographicValidation.setConcernedMaterial(this.evidenceRecord.getId());
        return cryptographicValidation;
    }

    private boolean coversSignatureOrTimestampOrEvidenceRecord(EvidenceRecordWrapper evidenceRecord) {
        return Utils.isCollectionNotEmpty((Collection)evidenceRecord.getCoveredSignatures()) || Utils.isCollectionNotEmpty((Collection)evidenceRecord.getCoveredTimestamps()) || Utils.isCollectionNotEmpty((Collection)evidenceRecord.getCoveredEvidenceRecords());
    }
}

