/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.signature.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;

public class TrustedListReachedForCertificateChainCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final CertificateWrapper signingCertificate;

    public TrustedListReachedForCertificateChainCheck(I18nProvider i18nProvider, T result, CertificateWrapper signingCertificate, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.signingCertificate = signingCertificate;
    }

    @Override
    protected boolean process() {
        return this.signingCertificate != null && this.signingCertificate.isTrustedListReached();
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.QUAL_CERT_TRUSTED_LIST_REACHED;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.QUAL_CERT_TRUSTED_LIST_REACHED_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return null;
    }
}

