/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd;

import eu.europa.esig.dss.diagnostic.TrustServiceWrapper;
import eu.europa.esig.dss.enumerations.CertificateQualifiedStatus;
import eu.europa.esig.dss.enumerations.QSCDStatus;
import eu.europa.esig.dss.enumerations.ServiceQualification;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.qualification.EIDASUtils;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd.QSCDStrategy;
import java.util.Collection;
import java.util.List;

class QSCDByTL
implements QSCDStrategy {
    private final TrustServiceWrapper trustService;
    private final CertificateQualifiedStatus qualified;
    private final QSCDStrategy qscdFromCertificate;

    public QSCDByTL(TrustServiceWrapper trustService, CertificateQualifiedStatus qualified, QSCDStrategy qscdFromCertificate) {
        this.trustService = trustService;
        this.qualified = qualified;
        this.qscdFromCertificate = qscdFromCertificate;
    }

    @Override
    public QSCDStatus getQSCDStatus() {
        if (this.trustService == null || !CertificateQualifiedStatus.isQC((CertificateQualifiedStatus)this.qualified)) {
            return QSCDStatus.NOT_QSCD;
        }
        List capturedQualifiers = this.trustService.getCapturedQualifierUris();
        if (Utils.isCollectionNotEmpty((Collection)capturedQualifiers)) {
            if (EIDASUtils.isPostEIDAS(this.trustService.getStartDate())) {
                if (ServiceQualification.isQcWithQSCD((List)capturedQualifiers) || ServiceQualification.isQcQSCDManagedOnBehalf((List)capturedQualifiers)) {
                    return QSCDStatus.QSCD;
                }
                if (ServiceQualification.isQcQSCDStatusAsInCert((List)capturedQualifiers)) {
                    return this.qscdFromCertificate.getQSCDStatus();
                }
                if (ServiceQualification.isQcNoQSCD((List)capturedQualifiers)) {
                    return QSCDStatus.NOT_QSCD;
                }
            } else {
                if (ServiceQualification.isQcWithSSCD((List)capturedQualifiers)) {
                    return QSCDStatus.QSCD;
                }
                if (ServiceQualification.isQcSSCDStatusAsInCert((List)capturedQualifiers)) {
                    return this.qscdFromCertificate.getQSCDStatus();
                }
                if (ServiceQualification.isQcNoSSCD((List)capturedQualifiers)) {
                    return QSCDStatus.NOT_QSCD;
                }
            }
        }
        return this.qscdFromCertificate.getQSCDStatus();
    }
}

