/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificateContentEquivalence;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.ArrayList;
import java.util.Collection;

public class MRACertificateEquivalenceApplied<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final CertificateWrapper certificateWrapper;

    public MRACertificateEquivalenceApplied(I18nProvider i18nProvider, T result, CertificateWrapper certificateWrapper, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.certificateWrapper = certificateWrapper;
    }

    @Override
    protected boolean process() {
        if (!this.certificateWrapper.isEnactedMRA()) {
            return false;
        }
        for (XmlCertificateContentEquivalence certificateContentEquivalence : this.certificateWrapper.getMRACertificateContentEquivalenceList()) {
            if (certificateContentEquivalence.isEnacted()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.QUAL_HAS_METS_HCCECBA;
    }

    @Override
    protected XmlMessage buildErrorMessage() {
        if (!this.certificateWrapper.isEnactedMRA()) {
            return this.buildXmlMessage(MessageTag.QUAL_HAS_METS_HCCECBA_ANS, new Object[0]);
        }
        Collection<String> uriList = this.getFailedCertificateEquivalenceContextUris();
        MessageTag errorTag = Utils.collectionSize(uriList) == 1 ? MessageTag.QUAL_HAS_METS_HCCECBA_ANS_2 : MessageTag.QUAL_HAS_METS_HCCECBA_ANS_3;
        String argument = Utils.collectionSize(uriList) == 1 ? uriList.iterator().next() : uriList.toString();
        return this.buildXmlMessage(errorTag, argument);
    }

    private Collection<String> getFailedCertificateEquivalenceContextUris() {
        ArrayList<String> result = new ArrayList<String>();
        for (XmlCertificateContentEquivalence certificateContentEquivalence : this.certificateWrapper.getMRACertificateContentEquivalenceList()) {
            if (certificateContentEquivalence.isEnacted()) continue;
            result.add(certificateContentEquivalence.getUri());
        }
        return result;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return null;
    }
}

