/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Date;

public class CertificateValidationBeforeSunsetDateCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final CertificateWrapper certificate;
    private final Date controlTime;

    public CertificateValidationBeforeSunsetDateCheck(I18nProvider i18nProvider, T result, CertificateWrapper certificate, Date controlTime, LevelRule constraint) {
        this(i18nProvider, result, certificate, controlTime, constraint, null);
    }

    protected CertificateValidationBeforeSunsetDateCheck(I18nProvider i18nProvider, T result, CertificateWrapper certificate, Date controlTime, LevelRule constraint, String certificateId) {
        super(i18nProvider, result, constraint, certificateId);
        this.certificate = certificate;
        this.controlTime = controlTime;
    }

    @Override
    protected XmlBlockType getBlockType() {
        return XmlBlockType.SUB_XCV_TA;
    }

    @Override
    protected boolean process() {
        if (this.certificate.getTrustSunsetDate() != null) {
            return this.controlTime.before(this.certificate.getTrustSunsetDate());
        }
        return this.certificate.isTrusted();
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_IVTBCTSD;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_IVTBCTSD_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.NO_CERTIFICATE_CHAIN_FOUND_NO_POE;
    }

    @Override
    protected String buildAdditionalInfo() {
        if (this.certificate.getTrustSunsetDate() != null) {
            return this.i18nProvider.getMessage(MessageTag.CERTIFICATE_SUNSET_DATE, new Object[]{ValidationProcessUtils.getFormattedDate(this.controlTime), ValidationProcessUtils.getFormattedDate(this.certificate.getTrustSunsetDate())});
        }
        return this.i18nProvider.getMessage(MessageTag.CERTIFICATE_SUNSET_DATE_VALID, new Object[0]);
    }
}

