/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.fc.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlFC;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlManifestFile;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.FilenameAdherenceCheck;

public class TimestampFilenameAdherenceCheck
extends FilenameAdherenceCheck<TimestampWrapper> {
    private static final String TST_EXTENSION = ".tst";
    private static final String TIMESTAMP_TST = "META-INF/timestamp.tst";

    public TimestampFilenameAdherenceCheck(I18nProvider i18nProvider, XmlFC result, DiagnosticData diagnosticData, TimestampWrapper token, LevelRule constraint) {
        super(i18nProvider, result, diagnosticData, token, constraint);
    }

    @Override
    protected boolean process() {
        String filename = ((TimestampWrapper)this.token).getFilename();
        if (Utils.isStringEmpty((String)filename)) {
            return false;
        }
        switch (this.diagnosticData.getContainerType()) {
            case ASiC_S: {
                return this.isInitialTimestampToken(filename) || this.isArchiveTimestampToken(filename);
            }
            case ASiC_E: {
                return this.isTimestamp(filename);
            }
        }
        throw new UnsupportedOperationException(String.format("Container type '%s' is not supported!", this.diagnosticData.getContainerType()));
    }

    private boolean isInitialTimestampToken(String filename) {
        return TIMESTAMP_TST.equals(filename);
    }

    private boolean isArchiveTimestampToken(String filename) {
        XmlManifestFile manifestFile = this.diagnosticData.getManifestFileForFilename(filename);
        if (manifestFile != null && manifestFile.getFilename() != null && this.isASiCArchiveManifest(manifestFile.getFilename())) {
            return this.isTimestamp(filename);
        }
        return false;
    }

    private boolean isTimestamp(String filename) {
        return filename.startsWith("META-INF/") && filename.contains("timestamp") && filename.endsWith(TST_EXTENSION);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_FC_ISFCS;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_FC_ISFCS_ANS;
    }
}

