/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.fc.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlFC;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlManifestFile;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.FilenameAdherenceCheck;

public class SignatureManifestFilenameAdherenceCheck
extends FilenameAdherenceCheck<SignatureWrapper> {
    public SignatureManifestFilenameAdherenceCheck(I18nProvider i18nProvider, XmlFC result, DiagnosticData diagnosticData, SignatureWrapper token, LevelRule constraint) {
        super(i18nProvider, result, diagnosticData, token, constraint);
    }

    @Override
    protected boolean process() {
        if (ASiCContainerType.ASiC_S == this.diagnosticData.getContainerType()) {
            return true;
        }
        XmlManifestFile manifestFile = this.diagnosticData.getManifestFileForFilename(((SignatureWrapper)this.token).getFilename());
        if (manifestFile == null) {
            return SignatureForm.XAdES == ((SignatureWrapper)this.token).getSignatureFormat().getSignatureForm();
        }
        String manifestFilename = manifestFile.getFilename();
        if (Utils.isStringEmpty((String)manifestFilename)) {
            return false;
        }
        switch (((SignatureWrapper)this.token).getSignatureFormat().getSignatureForm()) {
            case XAdES: {
                return "META-INF/manifest.xml".equals(manifestFilename);
            }
            case CAdES: {
                return this.isASiCManifest(manifestFilename);
            }
        }
        throw new UnsupportedOperationException(String.format("Only XAdES and CAdES ASiC container types are supported! Found : %s", ((SignatureWrapper)this.token).getSignatureFormat().getSignatureForm()));
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_FC_IMFCS;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_FC_IMFCS_ANS;
    }
}

