/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.fc.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlFC;
import eu.europa.esig.dss.diagnostic.PDFRevisionWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.AbstractPdfLockDictionaryCheck;
import java.util.Collection;

public class SigFieldLockCheck
extends AbstractPdfLockDictionaryCheck {
    public SigFieldLockCheck(I18nProvider i18nProvider, XmlFC result, PDFRevisionWrapper pdfRevision, LevelRule constraint) {
        super(i18nProvider, result, pdfRevision, pdfRevision.getSigFieldLock(), constraint);
    }

    @Override
    protected boolean process() {
        if (!super.process()) {
            return false;
        }
        if (!this.pdfRevision.arePdfObjectModificationsDetected()) {
            return true;
        }
        if (this.pdfLockDictionary == null) {
            return true;
        }
        if (this.pdfLockDictionary.getPermissions() != null) {
            switch (this.pdfLockDictionary.getPermissions()) {
                case NO_CHANGE_PERMITTED: {
                    if (!Utils.isCollectionNotEmpty((Collection)this.pdfRevision.getPdfSignatureOrFormFillChanges()) && !Utils.isCollectionNotEmpty((Collection)this.pdfRevision.getPdfAnnotationChanges()) && !Utils.isCollectionNotEmpty((Collection)this.pdfRevision.getPdfUndefinedChanges())) break;
                    return false;
                }
                case MINIMAL_CHANGES_PERMITTED: {
                    if (!Utils.isCollectionNotEmpty((Collection)this.pdfRevision.getPdfAnnotationChanges()) && !Utils.isCollectionNotEmpty((Collection)this.pdfRevision.getPdfUndefinedChanges())) break;
                    return false;
                }
                case CHANGES_PERMITTED: {
                    if (!Utils.isCollectionNotEmpty((Collection)this.pdfRevision.getPdfUndefinedChanges())) break;
                    return false;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("The value '%s' is not supported!", this.pdfLockDictionary.getPermissions()));
                }
            }
        }
        return true;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_FC_ISVASFLD;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_FC_ISVASFLD_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.FORMAT_FAILURE;
    }
}

