/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.fc.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlFC;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlContainerInfo;
import eu.europa.esig.dss.diagnostic.jaxb.XmlManifestFile;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignatureScope;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureScopeType;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AllFilesSignedCheck
extends ChainItem<XmlFC> {
    private final SignatureWrapper signature;
    private final XmlContainerInfo containerInfo;

    public AllFilesSignedCheck(I18nProvider i18nProvider, XmlFC result, SignatureWrapper signature, XmlContainerInfo containerInfo, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.signature = signature;
        this.containerInfo = containerInfo;
    }

    @Override
    protected boolean process() {
        if (ASiCContainerType.ASiC_S.equals((Object)this.containerInfo.getContainerType())) {
            return 1 == Utils.collectionSize((Collection)this.containerInfo.getContentFiles());
        }
        if (ASiCContainerType.ASiC_E.equals((Object)this.containerInfo.getContainerType())) {
            List coveredFiles;
            String signatureFilename = this.signature.getFilename();
            List contentFiles = this.containerInfo.getContentFiles();
            XmlManifestFile manifestFile = this.getRelatedManifestFile(signatureFilename);
            if (manifestFile != null ? !this.coversAllOriginalFiles(coveredFiles = manifestFile.getEntries(), contentFiles) : SignatureForm.CAdES.equals((Object)this.signature.getSignatureFormat().getSignatureForm())) {
                return false;
            }
            if (SignatureForm.XAdES.equals((Object)this.signature.getSignatureFormat().getSignatureForm())) {
                List<String> coveredFilesFromScope = this.getCoveredFilesFromScope();
                return this.coversAllOriginalFiles(coveredFilesFromScope, contentFiles);
            }
            return true;
        }
        return false;
    }

    private boolean coversAllOriginalFiles(List<String> coveredFiles, List<String> originalFiles) {
        for (String file : originalFiles) {
            if (coveredFiles.contains(file)) continue;
            return false;
        }
        return true;
    }

    private XmlManifestFile getRelatedManifestFile(String signatureFilename) {
        List manifestFiles = this.containerInfo.getManifestFiles();
        for (XmlManifestFile xmlManifestFile : manifestFiles) {
            if (!Utils.areStringsEqual((String)signatureFilename, (String)xmlManifestFile.getSignatureFilename())) continue;
            return xmlManifestFile;
        }
        return null;
    }

    private List<String> getCoveredFilesFromScope() {
        ArrayList<String> result = new ArrayList<String>();
        List signatureScopes = this.signature.getSignatureScopes();
        for (XmlSignatureScope xmlSignatureScope : signatureScopes) {
            if (SignatureScopeType.FULL != xmlSignatureScope.getScope()) continue;
            result.add(xmlSignatureScope.getName());
        }
        return result;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_CV_IAFS;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_CV_IAFS_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.FORMAT_FAILURE;
    }
}

