/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.fc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlFC;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.fc.AbstractFormatChecking;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.CAdESV3HashIndexCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.SignedAndTimestampedFilesCoveredCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.TimestampFilenameAdherenceCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.TimestampManifestFilenameAdherenceCheck;
import java.util.Collection;

public class TimestampFormatChecking
extends AbstractFormatChecking<TimestampWrapper> {
    public TimestampFormatChecking(I18nProvider i18nProvider, DiagnosticData diagnosticData, TimestampWrapper timestamp, Context context, ValidationPolicy policy) {
        super(i18nProvider, diagnosticData, timestamp, context, policy);
    }

    @Override
    protected void initChain() {
        ChainItem<XmlFC> item = this.firstItem;
        if (TimestampType.ARCHIVE_TIMESTAMP == ((TimestampWrapper)this.token).getType() && ArchiveTimestampType.CAdES_V3 == ((TimestampWrapper)this.token).getArchiveTimestampType()) {
            this.firstItem = this.cadesAtsV3HashIndex();
            item = this.firstItem;
        }
        if (((TimestampWrapper)this.token).getPDFRevision() != null) {
            item = this.getPDFRevisionValidationChain(item);
        }
        if (this.diagnosticData.isPDFAValidationPerformed() && ((TimestampWrapper)this.token).getType().isDocumentTimestamp() && Utils.isCollectionEmpty((Collection)((TimestampWrapper)this.token).getTimestampedSignatures())) {
            item = this.getPdfaValidationChain(item);
        }
        if (this.diagnosticData.isContainerInfoPresent() && ((TimestampWrapper)this.token).getType().isContainerTimestamp()) {
            if (Utils.isCollectionEmpty((Collection)((TimestampWrapper)this.token).getTimestampedSignatures())) {
                item = this.getASiCContainerValidationChain(item);
            }
            if (this.coversSignatureOrTimestampOrEvidenceRecord((TimestampWrapper)this.token)) {
                if (item == null) {
                    this.firstItem = this.signedAndTimestampedFilesCovered();
                    item = this.firstItem;
                } else {
                    item = item.setNextItem(this.signedAndTimestampedFilesCovered());
                }
            }
        }
    }

    private ChainItem<XmlFC> cadesAtsV3HashIndex() {
        LevelRule constraint = this.policy.getAtsHashIndexConstraint();
        return new CAdESV3HashIndexCheck(this.i18nProvider, (XmlFC)this.result, (TimestampWrapper)this.token, constraint);
    }

    private ChainItem<XmlFC> signedAndTimestampedFilesCovered() {
        LevelRule constraint = this.policy.getTimestampContainerSignedAndTimestampedFilesCoveredConstraint();
        return new SignedAndTimestampedFilesCoveredCheck(this.i18nProvider, (XmlFC)this.result, this.diagnosticData, (TimestampWrapper)this.token, constraint);
    }

    @Override
    protected ChainItem<XmlFC> filenameAdherenceCheck() {
        LevelRule constraint = this.policy.getFilenameAdherenceConstraint();
        return new TimestampFilenameAdherenceCheck(this.i18nProvider, (XmlFC)this.result, this.diagnosticData, (TimestampWrapper)this.token, constraint);
    }

    @Override
    protected ChainItem<XmlFC> manifestFilenameAdherenceCheck() {
        LevelRule constraint = this.policy.getFilenameAdherenceConstraint();
        return new TimestampManifestFilenameAdherenceCheck(this.i18nProvider, (XmlFC)this.result, this.diagnosticData, (TimestampWrapper)this.token, constraint);
    }

    private boolean coversSignatureOrTimestampOrEvidenceRecord(TimestampWrapper timestamp) {
        return Utils.isCollectionNotEmpty((Collection)timestamp.getTimestampedSignatures()) || Utils.isCollectionNotEmpty((Collection)timestamp.getTimestampedTimestamps()) || Utils.isCollectionNotEmpty((Collection)timestamp.getTimestampedEvidenceRecords());
    }
}

