/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.executor.signature;

import eu.europa.esig.dss.detailedreport.DetailedReport;
import eu.europa.esig.dss.diagnostic.AbstractTokenProxy;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.EvidenceRecordWrapper;
import eu.europa.esig.dss.diagnostic.RelatedRevocationWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlLangAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignatureScope;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTimestampedObject;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustService;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustServiceProvider;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SignatureQualification;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.enumerations.TimestampQualification;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.jaxb.object.Message;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.simplereport.jaxb.XmlCertificate;
import eu.europa.esig.dss.simplereport.jaxb.XmlCertificateChain;
import eu.europa.esig.dss.simplereport.jaxb.XmlDetails;
import eu.europa.esig.dss.simplereport.jaxb.XmlEvidenceRecord;
import eu.europa.esig.dss.simplereport.jaxb.XmlEvidenceRecords;
import eu.europa.esig.dss.simplereport.jaxb.XmlMessage;
import eu.europa.esig.dss.simplereport.jaxb.XmlPDFAInfo;
import eu.europa.esig.dss.simplereport.jaxb.XmlSemantic;
import eu.europa.esig.dss.simplereport.jaxb.XmlSignature;
import eu.europa.esig.dss.simplereport.jaxb.XmlSignatureLevel;
import eu.europa.esig.dss.simplereport.jaxb.XmlSimpleReport;
import eu.europa.esig.dss.simplereport.jaxb.XmlTimestamp;
import eu.europa.esig.dss.simplereport.jaxb.XmlTimestampLevel;
import eu.europa.esig.dss.simplereport.jaxb.XmlTimestamps;
import eu.europa.esig.dss.simplereport.jaxb.XmlTrustAnchor;
import eu.europa.esig.dss.simplereport.jaxb.XmlTrustAnchors;
import eu.europa.esig.dss.simplereport.jaxb.XmlValidationMessages;
import eu.europa.esig.dss.simplereport.jaxb.XmlValidationPolicy;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class SimpleReportBuilder {
    private final I18nProvider i18nProvider;
    private final boolean includeSemantics;
    private final Date currentTime;
    private final ValidationPolicy policy;
    private final DiagnosticData diagnosticData;
    private final DetailedReport detailedReport;
    private int totalSignatureCount = 0;
    private int validSignatureCount = 0;
    private final Set<Indication> finalIndications = new HashSet<Indication>();
    private final Set<SubIndication> finalSubIndications = new HashSet<SubIndication>();
    private POEExtraction poe;

    public SimpleReportBuilder(I18nProvider i18nProvider, Date currentTime, ValidationPolicy policy, DiagnosticData diagnosticData, DetailedReport detailedReport, boolean includeSemantics) {
        this.currentTime = currentTime;
        this.policy = policy;
        this.diagnosticData = diagnosticData;
        this.detailedReport = detailedReport;
        this.i18nProvider = i18nProvider;
        this.includeSemantics = includeSemantics;
    }

    public XmlSimpleReport build() {
        Indication tstValidationIndication;
        this.validSignatureCount = 0;
        this.totalSignatureCount = 0;
        this.poe = new POEExtraction();
        this.poe.init(this.diagnosticData, this.diagnosticData.getValidationDate());
        this.poe.collectAllPOE(this.diagnosticData.getTimestampList());
        XmlSimpleReport simpleReport = new XmlSimpleReport();
        this.addPolicyNode(simpleReport);
        this.addValidationTime(simpleReport);
        this.addDocumentName(simpleReport);
        boolean containerInfoPresent = this.diagnosticData.isContainerInfoPresent();
        if (containerInfoPresent) {
            this.addContainerType(simpleReport);
        }
        HashSet<String> attachedTimestampIds = new HashSet<String>();
        HashSet attachedEvidenceRecordIds = new HashSet();
        for (SignatureWrapper signature : this.diagnosticData.getSignatures()) {
            attachedTimestampIds.addAll(signature.getTimestampIdsList());
            attachedEvidenceRecordIds.addAll(signature.getEvidenceRecordIdsList());
            attachedTimestampIds.addAll(signature.getEvidenceRecordTimestampIds());
            simpleReport.getSignatureOrTimestampOrEvidenceRecord().add(this.getSignature(signature, containerInfoPresent));
        }
        for (TimestampWrapper timestamp : this.diagnosticData.getNonEvidenceRecordTimestamps()) {
            if (attachedTimestampIds.contains(timestamp.getId())) continue;
            attachedTimestampIds.add(timestamp.getId());
            attachedEvidenceRecordIds.addAll(timestamp.getEvidenceRecordIdsList());
            attachedTimestampIds.addAll(timestamp.getEvidenceRecordTimestampIds());
            tstValidationIndication = this.detailedReport.getBasicTimestampValidationIndication(timestamp.getId());
            if (tstValidationIndication == null) continue;
            XmlTimestamp xmlTimestamp = this.getXmlTimestamp(timestamp);
            if (this.isValidConclusion(timestamp.getId())) {
                this.determineExtensionPeriod(xmlTimestamp);
            }
            simpleReport.getSignatureOrTimestampOrEvidenceRecord().add(xmlTimestamp);
        }
        for (EvidenceRecordWrapper evidenceRecord : this.diagnosticData.getEvidenceRecords()) {
            if (attachedEvidenceRecordIds.contains(evidenceRecord.getId())) continue;
            attachedTimestampIds.addAll(evidenceRecord.getTimestampIdsList());
            Indication erValidationIndication = this.detailedReport.getEvidenceRecordValidationIndication(evidenceRecord.getId());
            if (erValidationIndication == null) continue;
            simpleReport.getSignatureOrTimestampOrEvidenceRecord().add(this.getXmlEvidenceRecord(evidenceRecord));
        }
        for (TimestampWrapper timestamp : this.diagnosticData.getTimestampList()) {
            if (attachedTimestampIds.contains(timestamp.getId()) || (tstValidationIndication = this.detailedReport.getBasicTimestampValidationIndication(timestamp.getId())) == null) continue;
            simpleReport.getSignatureOrTimestampOrEvidenceRecord().add(this.getXmlTimestamp(timestamp));
        }
        this.addStatistics(simpleReport);
        if (this.includeSemantics) {
            this.addSemantics(simpleReport);
        }
        this.addPDFAProfile(simpleReport);
        return simpleReport;
    }

    private void addPolicyNode(XmlSimpleReport report) {
        XmlValidationPolicy xmlPolicy = new XmlValidationPolicy();
        xmlPolicy.setPolicyName(this.policy.getPolicyName());
        xmlPolicy.setPolicyDescription(this.policy.getPolicyDescription());
        report.setValidationPolicy(xmlPolicy);
    }

    private void addValidationTime(XmlSimpleReport report) {
        report.setValidationTime(this.currentTime);
    }

    private void addDocumentName(XmlSimpleReport report) {
        report.setDocumentName(this.diagnosticData.getDocumentName());
    }

    private void addContainerType(XmlSimpleReport simpleReport) {
        simpleReport.setContainerType(this.diagnosticData.getContainerType());
    }

    private void addSemantics(XmlSimpleReport simpleReport) {
        XmlSemantic semantic;
        for (Indication indication : this.finalIndications) {
            semantic = new XmlSemantic();
            semantic.setKey(indication.name());
            semantic.setValue(this.i18nProvider.getMessage(MessageTag.getSemantic((String)indication.name()), new Object[0]));
            simpleReport.getSemantic().add(semantic);
        }
        for (SubIndication subIndication : this.finalSubIndications) {
            semantic = new XmlSemantic();
            semantic.setKey(subIndication.name());
            semantic.setValue(this.i18nProvider.getMessage(MessageTag.getSemantic((String)subIndication.name()), new Object[0]));
            simpleReport.getSemantic().add(semantic);
        }
    }

    private void addStatistics(XmlSimpleReport simpleReport) {
        simpleReport.setValidSignaturesCount(this.validSignatureCount);
        simpleReport.setSignaturesCount(this.totalSignatureCount);
    }

    private void addPDFAProfile(XmlSimpleReport simpleReport) {
        String pdfaProfileId = this.diagnosticData.getPDFAProfileId();
        if (pdfaProfileId != null) {
            XmlPDFAInfo xmlPDFAInfo = new XmlPDFAInfo();
            xmlPDFAInfo.setPDFAProfile(pdfaProfileId);
            xmlPDFAInfo.setValid(Boolean.valueOf(this.diagnosticData.isPDFACompliant()));
            if (Utils.isCollectionNotEmpty((Collection)this.diagnosticData.getPDFAValidationErrors())) {
                xmlPDFAInfo.setValidationMessages(this.toXmlValidationMessages(this.diagnosticData.getPDFAValidationErrors()));
            }
            simpleReport.setPDFAInfo(xmlPDFAInfo);
        }
    }

    private XmlValidationMessages toXmlValidationMessages(Collection<String> errors) {
        XmlValidationMessages xmlValidationMessages = new XmlValidationMessages();
        xmlValidationMessages.getError().addAll(errors);
        return xmlValidationMessages;
    }

    private XmlSignature getSignature(SignatureWrapper signature, boolean container) {
        List timestampList;
        XmlDetails qualificationDetails;
        XmlDetails validationDetails;
        ++this.totalSignatureCount;
        String signatureId = signature.getId();
        XmlSignature xmlSignature = new XmlSignature();
        xmlSignature.setId(signatureId);
        this.addCounterSignature(signature, xmlSignature);
        this.addSignatureScope(signature, xmlSignature);
        this.addSigningTime(signature, xmlSignature);
        this.addBestSignatureTime(signature, xmlSignature);
        this.addSignatureFormat(signature, xmlSignature);
        CertificateWrapper signingCertificate = signature.getSigningCertificate();
        if (signingCertificate != null) {
            xmlSignature.setSignedBy(this.getReadableCertificateName(signingCertificate.getId()));
        }
        if (this.isNotEmpty(validationDetails = this.getAdESValidationDetails(signatureId))) {
            xmlSignature.setAdESValidationDetails(validationDetails);
        }
        if (this.isNotEmpty(qualificationDetails = this.getQualificationDetails(signatureId))) {
            xmlSignature.setQualificationDetails(qualificationDetails);
        }
        if (container) {
            xmlSignature.setFilename(signature.getFilename());
        }
        Indication indication = this.detailedReport.getFinalIndication(signatureId);
        SubIndication subIndication = this.detailedReport.getFinalSubIndication(signatureId);
        if (Indication.TOTAL_PASSED.equals((Object)indication)) {
            this.determineExtensionPeriod(xmlSignature);
            ++this.validSignatureCount;
        } else if (Indication.INDETERMINATE.equals((Object)indication) && SubIndication.TRY_LATER.equals((Object)subIndication)) {
            this.determineExtensionPeriod(xmlSignature);
        }
        xmlSignature.setIndication(indication);
        this.finalIndications.add(indication);
        if (subIndication != null) {
            xmlSignature.setSubIndication(subIndication);
            this.finalSubIndications.add(subIndication);
        }
        this.addSignatureProfile(xmlSignature);
        xmlSignature.setCertificateChain(this.getCertChain(signatureId));
        List evidenceRecordList = signature.getEvidenceRecords();
        if (Utils.isCollectionNotEmpty((Collection)evidenceRecordList)) {
            XmlEvidenceRecords xmlEvidenceRecords = new XmlEvidenceRecords();
            for (EvidenceRecordWrapper evidenceRecord : evidenceRecordList) {
                Indication erIndication = this.detailedReport.getEvidenceRecordValidationIndication(evidenceRecord.getId());
                if (erIndication == null) continue;
                xmlEvidenceRecords.getEvidenceRecord().add(this.getXmlEvidenceRecord(evidenceRecord));
            }
            if (Utils.isCollectionNotEmpty((Collection)xmlEvidenceRecords.getEvidenceRecord())) {
                xmlSignature.setEvidenceRecords(xmlEvidenceRecords);
            }
        }
        if (Utils.isCollectionNotEmpty((Collection)(timestampList = signature.getTimestampList()))) {
            XmlTimestamps xmlTimestamps = new XmlTimestamps();
            for (TimestampWrapper timestamp : timestampList) {
                Indication tstValidationIndication = this.detailedReport.getBasicTimestampValidationIndication(timestamp.getId());
                if (tstValidationIndication == null) continue;
                xmlTimestamps.getTimestamp().add(this.getXmlTimestamp(timestamp));
            }
            if (Utils.isCollectionNotEmpty((Collection)xmlTimestamps.getTimestamp())) {
                xmlSignature.setTimestamps(xmlTimestamps);
            }
        }
        return xmlSignature;
    }

    private XmlDetails getAdESValidationDetails(String tokenId) {
        XmlDetails validationDetails = new XmlDetails();
        validationDetails.getError().addAll(this.convert(this.detailedReport.getAdESValidationErrors(tokenId)));
        validationDetails.getWarning().addAll(this.convert(this.detailedReport.getAdESValidationWarnings(tokenId)));
        validationDetails.getInfo().addAll(this.convert(this.detailedReport.getAdESValidationInfos(tokenId)));
        return validationDetails;
    }

    private XmlDetails getQualificationDetails(String tokenId) {
        XmlDetails qualificationDetails = new XmlDetails();
        qualificationDetails.getError().addAll(this.convert(this.detailedReport.getQualificationErrors(tokenId)));
        qualificationDetails.getWarning().addAll(this.convert(this.detailedReport.getQualificationWarnings(tokenId)));
        qualificationDetails.getInfo().addAll(this.convert(this.detailedReport.getQualificationInfos(tokenId)));
        return qualificationDetails;
    }

    private boolean isNotEmpty(XmlDetails details) {
        return Utils.isCollectionNotEmpty((Collection)details.getError()) || Utils.isCollectionNotEmpty((Collection)details.getWarning()) || Utils.isCollectionNotEmpty((Collection)details.getInfo());
    }

    private List<XmlMessage> convert(Collection<Message> messages) {
        return messages.stream().map(m -> {
            XmlMessage xmlMessage = new XmlMessage();
            xmlMessage.setKey(m.getKey());
            xmlMessage.setValue(m.getValue());
            return xmlMessage;
        }).collect(Collectors.toList());
    }

    private XmlCertificateChain getCertChain(String tokenId) {
        List certIds = this.detailedReport.getBasicBuildingBlocksCertChain(tokenId);
        XmlCertificateChain xmlCertificateChain = new XmlCertificateChain();
        if (Utils.isCollectionNotEmpty((Collection)certIds)) {
            for (String certId : certIds) {
                XmlCertificate certificate = new XmlCertificate();
                certificate.setId(certId);
                certificate.setQualifiedName(this.getReadableCertificateName(certId));
                if (this.isTrustAnchor(certId)) {
                    certificate.setTrusted(Boolean.valueOf(true));
                    certificate.setSunsetDate(this.getCertificateSunsetDate(certId));
                    certificate.setTrustAnchors(this.getXmlTrustAnchors(certId));
                }
                xmlCertificateChain.getCertificate().add(certificate);
            }
        }
        return xmlCertificateChain;
    }

    private Date getCertificateSunsetDate(String certId) {
        CertificateWrapper certificate = this.diagnosticData.getCertificateById(certId);
        if (certificate != null) {
            return certificate.getTrustSunsetDate();
        }
        return null;
    }

    private XmlTrustAnchors getXmlTrustAnchors(String certId) {
        List<XmlTrustServiceProvider> xmlTrustServiceProviders = this.filterByCertificateId(certId);
        if (Utils.isCollectionNotEmpty(xmlTrustServiceProviders)) {
            XmlTrustAnchors xmlTrustAnchors = new XmlTrustAnchors();
            for (XmlTrustServiceProvider trustServiceProvider : xmlTrustServiceProviders) {
                XmlTrustAnchor trustAnchor = new XmlTrustAnchor();
                if (trustServiceProvider.getTL() != null) {
                    trustAnchor.setCountryCode(trustServiceProvider.getTL().getCountryCode());
                    trustAnchor.setTSLType(trustServiceProvider.getTL().getTSLType());
                }
                trustAnchor.setTrustServiceProvider(this.getEnOrFirst(trustServiceProvider.getTSPNames()));
                List tspRegistrationIdentifiers = trustServiceProvider.getTSPRegistrationIdentifiers();
                if (Utils.isCollectionNotEmpty((Collection)tspRegistrationIdentifiers)) {
                    trustAnchor.setTrustServiceProviderRegistrationId((String)tspRegistrationIdentifiers.get(0));
                }
                trustAnchor.getTrustServiceName().addAll(this.getUniqueServiceNames(trustServiceProvider));
                xmlTrustAnchors.getTrustAnchor().add(trustAnchor);
            }
            return xmlTrustAnchors;
        }
        return null;
    }

    private Set<String> getUniqueServiceNames(XmlTrustServiceProvider trustServiceProvider) {
        HashSet<String> result = new HashSet<String>();
        for (XmlTrustService xmlTrustService : trustServiceProvider.getTrustServices()) {
            result.add(this.getEnOrFirst(xmlTrustService.getServiceNames()));
        }
        return result;
    }

    private String getEnOrFirst(List<XmlLangAndValue> langAndValues) {
        if (Utils.isCollectionNotEmpty(langAndValues)) {
            for (XmlLangAndValue langAndValue : langAndValues) {
                if (langAndValue.getLang() == null || !"en".equalsIgnoreCase(langAndValue.getLang())) continue;
                return langAndValue.getValue();
            }
            return langAndValues.get(0).getValue();
        }
        return null;
    }

    private List<XmlTrustServiceProvider> filterByCertificateId(String certId) {
        CertificateWrapper certificate = this.diagnosticData.getCertificateById(certId);
        ArrayList<XmlTrustServiceProvider> result = new ArrayList<XmlTrustServiceProvider>();
        for (XmlTrustServiceProvider xmlTrustServiceProvider : certificate.getTrustServiceProviders()) {
            List trustServices = xmlTrustServiceProvider.getTrustServices();
            boolean foundCertId = false;
            for (XmlTrustService xmlTrustService : trustServices) {
                if (!Utils.areStringsEqual((String)certId, (String)xmlTrustService.getServiceDigitalIdentifier().getId())) continue;
                foundCertId = true;
                break;
            }
            if (!foundCertId) continue;
            result.add(xmlTrustServiceProvider);
        }
        return result;
    }

    private void addBestSignatureTime(SignatureWrapper signature, XmlSignature xmlSignature) {
        xmlSignature.setBestSignatureTime(this.detailedReport.getBestSignatureTime(signature.getId()));
    }

    private void addCounterSignature(SignatureWrapper signature, XmlSignature xmlSignature) {
        if (signature.isCounterSignature()) {
            xmlSignature.setCounterSignature(Boolean.valueOf(true));
            xmlSignature.setParentId(signature.getParent().getId());
        }
    }

    private void addSignatureScope(SignatureWrapper signature, XmlSignature xmlSignature) {
        List signatureScopes = signature.getSignatureScopes();
        if (Utils.isCollectionNotEmpty((Collection)signatureScopes)) {
            for (XmlSignatureScope signatureScope : signatureScopes) {
                xmlSignature.getSignatureScope().add(this.getXmlSignatureScope(signatureScope));
            }
        }
    }

    private eu.europa.esig.dss.simplereport.jaxb.XmlSignatureScope getXmlSignatureScope(XmlSignatureScope signatureScope) {
        eu.europa.esig.dss.simplereport.jaxb.XmlSignatureScope xmlSignatureScope = new eu.europa.esig.dss.simplereport.jaxb.XmlSignatureScope();
        xmlSignatureScope.setId(signatureScope.getSignerData().getId());
        xmlSignatureScope.setName(signatureScope.getName());
        xmlSignatureScope.setScope(signatureScope.getScope());
        xmlSignatureScope.setValue(signatureScope.getDescription());
        return xmlSignatureScope;
    }

    private void addSigningTime(SignatureWrapper signature, XmlSignature xmlSignature) {
        xmlSignature.setSigningTime(signature.getClaimedSigningTime());
    }

    private void addSignatureFormat(SignatureWrapper signature, XmlSignature xmlSignature) {
        xmlSignature.setSignatureFormat(signature.getSignatureFormat());
    }

    private String getReadableCertificateName(String certId) {
        CertificateWrapper certificateWrapper = this.diagnosticData.getUsedCertificateByIdNullSafe(certId);
        return certificateWrapper.getReadableCertificateName();
    }

    private boolean isTrustAnchor(String certId) {
        CertificateWrapper certificateWrapper = this.diagnosticData.getUsedCertificateByIdNullSafe(certId);
        return certificateWrapper.isTrusted();
    }

    private void addSignatureProfile(XmlSignature xmlSignature) {
        SignatureQualification qualification = this.detailedReport.getSignatureQualification(xmlSignature.getId());
        if (qualification != null) {
            XmlSignatureLevel sigLevel = new XmlSignatureLevel();
            sigLevel.setValue(qualification);
            sigLevel.setDescription(qualification.getLabel());
            xmlSignature.setSignatureLevel(sigLevel);
        }
    }

    private XmlTimestamp getXmlTimestamp(TimestampWrapper timestampWrapper) {
        XmlDetails qualificationDetails;
        XmlDetails validationDetails;
        TimestampQualification timestampQualification;
        XmlTimestamp xmlTimestamp = new XmlTimestamp();
        String timestampId = timestampWrapper.getId();
        xmlTimestamp.setId(timestampId);
        xmlTimestamp.setProductionTime(timestampWrapper.getProductionTime());
        xmlTimestamp.setProducedBy(this.getProducedByName(timestampWrapper));
        xmlTimestamp.setCertificateChain(this.getCertChain(timestampId));
        xmlTimestamp.setFilename(timestampWrapper.getFilename());
        Indication indication = this.detailedReport.getFinalIndication(timestampId);
        xmlTimestamp.setIndication(indication);
        this.finalIndications.add(indication);
        SubIndication subIndication = this.detailedReport.getFinalSubIndication(timestampId);
        if (subIndication != null) {
            xmlTimestamp.setSubIndication(subIndication);
            this.finalSubIndications.add(subIndication);
        }
        if ((timestampQualification = this.detailedReport.getTimestampQualification(timestampId)) != null) {
            XmlTimestampLevel xmlTimestampLevel = new XmlTimestampLevel();
            xmlTimestampLevel.setValue(timestampQualification);
            xmlTimestampLevel.setDescription(timestampQualification.getLabel());
            xmlTimestamp.setTimestampLevel(xmlTimestampLevel);
        }
        if (this.isNotEmpty(validationDetails = this.getAdESValidationDetails(timestampId))) {
            xmlTimestamp.setAdESValidationDetails(validationDetails);
        }
        if (this.isNotEmpty(qualificationDetails = this.getQualificationDetails(timestampId))) {
            xmlTimestamp.setQualificationDetails(qualificationDetails);
        }
        if (Utils.isCollectionNotEmpty((Collection)timestampWrapper.getTimestampScopes())) {
            for (XmlSignatureScope timestampScope : timestampWrapper.getTimestampScopes()) {
                xmlTimestamp.getTimestampScope().add(this.getXmlSignatureScope(timestampScope));
            }
        }
        if (Utils.isCollectionNotEmpty((Collection)timestampWrapper.getEvidenceRecords())) {
            XmlEvidenceRecords xmlEvidenceRecords = new XmlEvidenceRecords();
            for (EvidenceRecordWrapper evidenceRecord : timestampWrapper.getEvidenceRecords()) {
                Indication erIndication = this.detailedReport.getEvidenceRecordValidationIndication(evidenceRecord.getId());
                if (erIndication == null) continue;
                xmlEvidenceRecords.getEvidenceRecord().add(this.getXmlEvidenceRecord(evidenceRecord));
            }
            if (Utils.isCollectionNotEmpty((Collection)xmlEvidenceRecords.getEvidenceRecord())) {
                xmlTimestamp.setEvidenceRecords(xmlEvidenceRecords);
            }
        }
        return xmlTimestamp;
    }

    private XmlEvidenceRecord getXmlEvidenceRecord(EvidenceRecordWrapper evidenceRecordWrapper) {
        List timestampList;
        XmlDetails validationDetails;
        XmlEvidenceRecord xmlEvidenceRecord = new XmlEvidenceRecord();
        String evidenceRecordId = evidenceRecordWrapper.getId();
        xmlEvidenceRecord.setId(evidenceRecordId);
        xmlEvidenceRecord.setFilename(evidenceRecordWrapper.getFilename());
        xmlEvidenceRecord.setPOETime(this.detailedReport.getEvidenceRecordLowestPOETime(evidenceRecordId));
        Indication indication = this.detailedReport.getFinalIndication(evidenceRecordId);
        xmlEvidenceRecord.setIndication(indication);
        this.finalIndications.add(indication);
        SubIndication subIndication = this.detailedReport.getFinalSubIndication(evidenceRecordId);
        if (subIndication != null) {
            xmlEvidenceRecord.setSubIndication(subIndication);
            this.finalSubIndications.add(subIndication);
        }
        if (this.isNotEmpty(validationDetails = this.getAdESValidationDetails(evidenceRecordId))) {
            xmlEvidenceRecord.setAdESValidationDetails(validationDetails);
        }
        if (this.isValidConclusion(evidenceRecordId)) {
            this.determineExtensionPeriod(xmlEvidenceRecord);
        }
        if (Utils.isCollectionNotEmpty((Collection)evidenceRecordWrapper.getEvidenceRecordScopes())) {
            for (XmlSignatureScope timestampScope : evidenceRecordWrapper.getEvidenceRecordScopes()) {
                xmlEvidenceRecord.getEvidenceRecordScope().add(this.getXmlSignatureScope(timestampScope));
            }
        }
        if (Utils.isCollectionNotEmpty((Collection)(timestampList = evidenceRecordWrapper.getTimestampList()))) {
            XmlTimestamps xmlTimestamps = new XmlTimestamps();
            for (TimestampWrapper timestamp : timestampList) {
                Indication tstValidationIndication = this.detailedReport.getBasicTimestampValidationIndication(timestamp.getId());
                if (tstValidationIndication == null) continue;
                xmlTimestamps.getTimestamp().add(this.getXmlTimestamp(timestamp));
            }
            if (Utils.isCollectionNotEmpty((Collection)xmlTimestamps.getTimestamp())) {
                xmlEvidenceRecord.setTimestamps(xmlTimestamps);
            }
        }
        if (evidenceRecordWrapper.isEmbedded()) {
            xmlEvidenceRecord.setEmbedded(Boolean.valueOf(true));
            xmlEvidenceRecord.setParentId(evidenceRecordWrapper.getParent().getId());
        }
        return xmlEvidenceRecord;
    }

    private String getProducedByName(TimestampWrapper timestampWrapper) {
        CertificateWrapper signingCertificate = timestampWrapper.getSigningCertificate();
        if (signingCertificate != null) {
            return signingCertificate.getReadableCertificateName();
        }
        return "";
    }

    private void determineExtensionPeriod(XmlSignature xmlSignature) {
        SignatureWrapper signatureWrapper = this.diagnosticData.getSignatureById(xmlSignature.getId());
        List<TimestampWrapper> timestampList = this.getAllTimestampsForSignature(signatureWrapper);
        xmlSignature.setExtensionPeriodMin(this.getMinExtensionPeriod((AbstractTokenProxy)signatureWrapper, timestampList));
        xmlSignature.setExtensionPeriodMax(this.getMaxExtensionPeriod((AbstractTokenProxy)signatureWrapper, timestampList));
    }

    private List<TimestampWrapper> getAllTimestampsForSignature(SignatureWrapper signatureWrapper) {
        ArrayList<TimestampWrapper> timestampList = new ArrayList<TimestampWrapper>(signatureWrapper.getAllTimestampsProducedAfterSignatureCreation());
        timestampList.addAll(this.getEvidenceRecordTimestampsForTokenWithId(signatureWrapper.getId()));
        return timestampList;
    }

    private void determineExtensionPeriod(XmlTimestamp xmlTimestamp) {
        TimestampWrapper timestampWrapper = this.diagnosticData.getTimestampById(xmlTimestamp.getId());
        List<TimestampWrapper> timestampList = this.getAllTimestampsForTimestamp(timestampWrapper);
        xmlTimestamp.setExtensionPeriodMin(this.getMinExtensionPeriod((AbstractTokenProxy)timestampWrapper, timestampList));
        xmlTimestamp.setExtensionPeriodMax(this.getMaxExtensionPeriod((AbstractTokenProxy)timestampWrapper, timestampList));
    }

    private List<TimestampWrapper> getAllTimestampsForTimestamp(TimestampWrapper timestampWrapper) {
        ArrayList<TimestampWrapper> timestampList = new ArrayList<TimestampWrapper>();
        for (TimestampWrapper timestamp : this.diagnosticData.getTimestampList()) {
            List timestampedObjects = timestamp.getTimestampedObjects();
            if (!this.containObjectWithId(timestampedObjects, timestampWrapper.getId())) continue;
            timestampList.add(timestamp);
        }
        timestampList.addAll(this.getEvidenceRecordTimestampsForTokenWithId(timestampWrapper.getId()));
        return timestampList;
    }

    private void determineExtensionPeriod(XmlEvidenceRecord xmlEvidenceRecord) {
        EvidenceRecordWrapper evidenceRecordWrapper = this.diagnosticData.getEvidenceRecordById(xmlEvidenceRecord.getId());
        List<TimestampWrapper> timestampList = this.getAllTimestampsForEvidenceRecord(evidenceRecordWrapper);
        xmlEvidenceRecord.setExtensionPeriodMin(this.getMinExtensionPeriodForTimestampList(timestampList));
        xmlEvidenceRecord.setExtensionPeriodMax(this.getMaxExtensionPeriodForTimestampList(timestampList));
    }

    private List<TimestampWrapper> getAllTimestampsForEvidenceRecord(EvidenceRecordWrapper evidenceRecordWrapper) {
        ArrayList<TimestampWrapper> timestampList = new ArrayList<TimestampWrapper>(evidenceRecordWrapper.getTimestampList());
        timestampList.addAll(this.getEvidenceRecordTimestampsForTokenWithId(evidenceRecordWrapper.getId()));
        return timestampList;
    }

    private List<TimestampWrapper> getEvidenceRecordTimestampsForTokenWithId(String tokenId) {
        ArrayList<TimestampWrapper> timestampList = new ArrayList<TimestampWrapper>();
        for (EvidenceRecordWrapper evidenceRecord : this.diagnosticData.getEvidenceRecords()) {
            List coveredObjects;
            if (!this.isValidConclusion(evidenceRecord.getId()) || !this.containObjectWithId(coveredObjects = evidenceRecord.getCoveredObjects(), tokenId)) continue;
            timestampList.addAll(evidenceRecord.getTimestampList());
        }
        return timestampList;
    }

    private Date getMinExtensionPeriod(AbstractTokenProxy token, List<TimestampWrapper> timestampList) {
        Date min = null;
        ArrayList<List> chains = new ArrayList<List>();
        chains.add(token.getCertificateChain());
        List<RelatedRevocationWrapper> relatedRevocations = this.getRelatedRevocations(token);
        for (RevocationWrapper revocationWrapper : relatedRevocations) {
            chains.add(revocationWrapper.getCertificateChain());
        }
        for (List list : chains) {
            Date certChainMin = this.getMinExtensionPeriodForChain(list, null);
            if (certChainMin == null || min != null && !min.before(certChainMin)) continue;
            min = certChainMin;
        }
        Date minExtensionPeriodForTimestampList = this.getMinExtensionPeriodForTimestampList(timestampList);
        if (minExtensionPeriodForTimestampList != null && (min == null || min.before(minExtensionPeriodForTimestampList))) {
            min = minExtensionPeriodForTimestampList;
        }
        return min;
    }

    private List<RelatedRevocationWrapper> getRelatedRevocations(AbstractTokenProxy token) {
        return token.foundRevocations().getRelatedRevocationData().stream().filter(r -> this.poe.getLowestPOE(r.getId()).isTokenProvided()).collect(Collectors.toList());
    }

    private Date getMinExtensionPeriodForTimestampList(List<TimestampWrapper> timestampList) {
        Date min = null;
        for (TimestampWrapper timestampWrapper : timestampList) {
            Date certChainMin = this.getMinExtensionPeriodForChain(timestampWrapper.getCertificateChain(), timestampWrapper.getProductionTime());
            if (certChainMin == null || min != null && !min.before(certChainMin)) continue;
            min = certChainMin;
        }
        return min;
    }

    private Date getMinExtensionPeriodForChain(List<CertificateWrapper> certificateChain, Date usageTime) {
        Date min = null;
        for (CertificateWrapper certificateWrapper : certificateChain) {
            if (certificateWrapper.isTrusted() || certificateWrapper.isSelfSigned()) break;
            if (!Utils.isCollectionNotEmpty((Collection)certificateWrapper.getCertificateRevocationData())) continue;
            Date lastTrustedUsage = usageTime != null ? usageTime : this.poe.getLowestPOETime(certificateWrapper.getId());
            Date tempMin = null;
            boolean goodRevocationFound = false;
            List certificateRevocationData = certificateWrapper.getCertificateRevocationData();
            for (CertificateRevocationWrapper revocationData : certificateRevocationData) {
                if (lastTrustedUsage.before(revocationData.getThisUpdate())) {
                    goodRevocationFound = true;
                    break;
                }
                Date nextUpdate = revocationData.getNextUpdate();
                if (nextUpdate == null) {
                    nextUpdate = new Date(lastTrustedUsage.getTime() + 1000L);
                }
                if (tempMin != null && !tempMin.after(nextUpdate)) continue;
                tempMin = nextUpdate;
            }
            if (goodRevocationFound || tempMin == null || min != null && !min.before(tempMin)) continue;
            min = tempMin;
        }
        return min;
    }

    private Date getMaxExtensionPeriod(AbstractTokenProxy token, List<TimestampWrapper> timestampList) {
        CertificateWrapper signingCertificate = token.getSigningCertificate();
        if (signingCertificate == null) {
            return null;
        }
        Date max = signingCertificate.getNotAfter();
        Date maxTimestampExtensionPeriod = this.getMaxExtensionPeriodForTimestampList(timestampList);
        if (maxTimestampExtensionPeriod != null && maxTimestampExtensionPeriod.after(max)) {
            max = maxTimestampExtensionPeriod;
        }
        return this.ensureMaxExtensionTimeIsAfterValidationTime(max);
    }

    private Date getMaxExtensionPeriodForTimestampList(List<TimestampWrapper> timestampList) {
        Date max = null;
        for (TimestampWrapper timestampWrapper : timestampList) {
            CertificateWrapper timestampSigningCertificate;
            if (!this.isValidConclusion(timestampWrapper.getId()) || (timestampSigningCertificate = timestampWrapper.getSigningCertificate()) == null || max != null && !timestampSigningCertificate.getNotAfter().after(max)) continue;
            max = timestampSigningCertificate.getNotAfter();
        }
        return this.ensureMaxExtensionTimeIsAfterValidationTime(max);
    }

    private Date ensureMaxExtensionTimeIsAfterValidationTime(Date maxExtensionTime) {
        if (maxExtensionTime == null) {
            return null;
        }
        if (this.currentTime != null && this.currentTime.before(maxExtensionTime)) {
            return maxExtensionTime;
        }
        return null;
    }

    private boolean isValidConclusion(String tokenId) {
        Indication finalIndication = this.detailedReport.getFinalIndication(tokenId);
        return Indication.TOTAL_PASSED == finalIndication || Indication.PASSED == finalIndication;
    }

    private boolean containObjectWithId(List<XmlTimestampedObject> timestampedObjects, String tokenId) {
        return timestampedObjects.stream().anyMatch(o -> tokenId.equals(o.getToken().getId()));
    }
}

