/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Level;
import eu.europa.esig.dss.enumerations.SubContext;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.spi.validation.TrustAnchorVerifier;

public class TrustAnchorVerifierFactory {
    private final ValidationPolicy validationPolicy;

    public TrustAnchorVerifierFactory(ValidationPolicy validationPolicy) {
        this.validationPolicy = validationPolicy;
    }

    public TrustAnchorVerifier create() {
        TrustAnchorVerifier trustAnchorVerifier = TrustAnchorVerifier.createEmptyTrustAnchorVerifier();
        this.instantiateAcceptUntrustedCertificateChains(trustAnchorVerifier, this.validationPolicy);
        this.instantiateUseSunsetDate(trustAnchorVerifier, this.validationPolicy);
        return trustAnchorVerifier;
    }

    private void instantiateAcceptUntrustedCertificateChains(TrustAnchorVerifier trustAnchorVerifier, ValidationPolicy validationPolicy) {
        boolean acceptUntrustedCertificateChains = this.getAcceptUntrustedCertificateChains(validationPolicy, Context.REVOCATION);
        trustAnchorVerifier.setAcceptRevocationUntrustedCertificateChains(acceptUntrustedCertificateChains);
        acceptUntrustedCertificateChains = this.getAcceptUntrustedCertificateChains(validationPolicy, Context.TIMESTAMP);
        trustAnchorVerifier.setAcceptTimestampUntrustedCertificateChains(acceptUntrustedCertificateChains);
    }

    private boolean getAcceptUntrustedCertificateChains(ValidationPolicy validationPolicy, Context context) {
        LevelRule constraint = validationPolicy.getProspectiveCertificateChainConstraint(context);
        return constraint == null || !Level.FAIL.equals((Object)constraint.getLevel());
    }

    private void instantiateUseSunsetDate(TrustAnchorVerifier trustAnchorVerifier, ValidationPolicy validationPolicy) {
        boolean useSunsetDate = this.getUseSunsetDate(validationPolicy, Context.SIGNATURE);
        useSunsetDate = useSunsetDate || this.getUseSunsetDate(validationPolicy, Context.COUNTER_SIGNATURE);
        useSunsetDate = useSunsetDate || this.getUseSunsetDate(validationPolicy, Context.TIMESTAMP);
        useSunsetDate = useSunsetDate || this.getUseSunsetDate(validationPolicy, Context.REVOCATION);
        trustAnchorVerifier.setUseSunsetDate(useSunsetDate);
    }

    private boolean getUseSunsetDate(ValidationPolicy validationPolicy, Context context) {
        LevelRule constraint = validationPolicy.getCertificateSunsetDateConstraint(context, SubContext.SIGNING_CERT);
        if (constraint != null && Level.FAIL.equals((Object)constraint.getLevel())) {
            return true;
        }
        constraint = validationPolicy.getCertificateSunsetDateConstraint(context, SubContext.CA_CERTIFICATE);
        return constraint != null && Level.FAIL.equals((Object)constraint.getLevel());
    }
}

