/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.validation;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampTokenVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(TimestampTokenVerifier.class);
    private CertificateSource trustedCertificateSource;
    private boolean acceptUntrustedCertificateChains;

    protected TimestampTokenVerifier() {
    }

    public static TimestampTokenVerifier createEmptyTimestampTokenVerifier() {
        return new TimestampTokenVerifier();
    }

    public static TimestampTokenVerifier createDefaultTimestampTokenVerifier() {
        TimestampTokenVerifier timestampTokenVerifier = new TimestampTokenVerifier();
        timestampTokenVerifier.setAcceptUntrustedCertificateChains(false);
        return timestampTokenVerifier;
    }

    public CertificateSource getTrustedCertificateSource() {
        return this.trustedCertificateSource;
    }

    protected void setTrustedCertificateSource(CertificateSource trustedCertificateSource) {
        this.trustedCertificateSource = trustedCertificateSource;
    }

    public void setAcceptUntrustedCertificateChains(boolean acceptUntrustedCertificateChains) {
        this.acceptUntrustedCertificateChains = acceptUntrustedCertificateChains;
    }

    public boolean isAcceptable(TimestampToken timestampToken) {
        return this.isAcceptable(timestampToken, Collections.emptyList());
    }

    public boolean isAcceptable(TimestampToken timestampToken, List<CertificateToken> certificateChain) {
        return this.isTrustedTimestampToken(timestampToken, certificateChain) && this.isCryptographicallyValid(timestampToken);
    }

    protected boolean isTrustedTimestampToken(TimestampToken timestampToken, List<CertificateToken> certificateChain) {
        if (!this.acceptUntrustedCertificateChains && !this.containsTrustAnchor(certificateChain)) {
            LOG.warn("POE extraction is skipped for untrusted timestamp : {}.", (Object)timestampToken.getDSSIdAsString());
            return false;
        }
        return true;
    }

    private boolean containsTrustAnchor(List<CertificateToken> certChain) {
        if (Utils.isCollectionNotEmpty(certChain)) {
            for (CertificateToken token : certChain) {
                if (!this.isTrusted(token)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isTrusted(CertificateToken certificateToken) {
        return this.trustedCertificateSource != null && this.trustedCertificateSource.isTrusted(certificateToken);
    }

    protected boolean isCryptographicallyValid(TimestampToken timestampToken) {
        if (!timestampToken.isMessageImprintDataIntact()) {
            LOG.warn("POE extraction is skipped for timestamp : {}. The message-imprint is not intact!", (Object)timestampToken.getDSSIdAsString());
            return false;
        }
        if (!timestampToken.isSignatureIntact()) {
            LOG.warn("POE extraction is skipped for timestamp : {}. The signature is not intact!", (Object)timestampToken.getDSSIdAsString());
            return false;
        }
        return true;
    }
}

