/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DSSMessageDigest;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DSSMessageDigestCalculator {
    private final DigestAlgorithm digestAlgorithm;
    private final MessageDigest messageDigest;

    public DSSMessageDigestCalculator(DigestAlgorithm digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
        this.messageDigest = this.toMessageDigest(digestAlgorithm);
    }

    private MessageDigest toMessageDigest(DigestAlgorithm digestAlgorithm) {
        try {
            return digestAlgorithm.getMessageDigest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new DSSException(String.format("Unable to build MessageDigest for the algorithm '%s' : %s", digestAlgorithm.getName(), e.getMessage()), (Throwable)e);
        }
    }

    public void update(byte byteToAdd) {
        this.messageDigest.update(byteToAdd);
    }

    public void update(byte[] bytes) {
        if (bytes != null) {
            this.messageDigest.update(bytes);
        }
    }

    public void update(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return;
        }
        try (InputStream is = inputStream;){
            int count;
            byte[] buffer = new byte[4096];
            while ((count = is.read(buffer)) >= 0) {
                this.messageDigest.update(buffer, 0, count);
            }
        }
    }

    public DSSMessageDigest getMessageDigest() {
        return new DSSMessageDigest(this.digestAlgorithm, this.messageDigest.digest());
    }
}

