/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.CommonCertificateSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreCertificateSource
extends CommonCertificateSource {
    private static final Logger LOG = LoggerFactory.getLogger(KeyStoreCertificateSource.class);
    private KeyStore keyStore;
    private char[] passwordProtection;

    @Deprecated
    public KeyStoreCertificateSource(String ksType, String ksPassword) {
        this((InputStream)null, ksType, ksPassword.toCharArray());
    }

    public KeyStoreCertificateSource(String ksType, char[] ksPassword) {
        this((InputStream)null, ksType, ksPassword);
    }

    @Deprecated
    public KeyStoreCertificateSource(String ksFilePath, String ksType, String ksPassword) throws IOException {
        this(new File(ksFilePath), ksType, ksPassword.toCharArray());
    }

    public KeyStoreCertificateSource(String ksFilePath, String ksType, char[] ksPassword) throws IOException {
        this(new File(ksFilePath), ksType, ksPassword);
    }

    @Deprecated
    public KeyStoreCertificateSource(File ksFile, String ksType, String ksPassword) throws IOException {
        this(Files.newInputStream(ksFile.toPath(), new OpenOption[0]), ksType, ksPassword.toCharArray());
    }

    public KeyStoreCertificateSource(File ksFile, String ksType, char[] ksPassword) throws IOException {
        this(Files.newInputStream(ksFile.toPath(), new OpenOption[0]), ksType, ksPassword);
    }

    @Deprecated
    public KeyStoreCertificateSource(InputStream ksStream, String ksType, String ksPassword) {
        this.initKeystore(ksStream, ksType, ksPassword.toCharArray());
    }

    public KeyStoreCertificateSource(InputStream ksStream, String ksType, char[] ksPassword) {
        this.initKeystore(ksStream, ksType, ksPassword);
    }

    private void initKeystore(InputStream ksStream, String ksType, char[] ksPassword) {
        try (InputStream is = ksStream;){
            this.keyStore = KeyStore.getInstance(ksType);
            this.keyStore.load(is, ksPassword);
            this.passwordProtection = ksPassword;
            this.extractCertificates();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new DSSException("Unable to initialize the keystore", (Throwable)e);
        }
    }

    private void extractCertificates() {
        try {
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate certificate = this.keyStore.getCertificate(this.getKey(aliases.nextElement()));
                CertificateToken certificateToken = DSSUtils.loadCertificate(certificate.getEncoded());
                super.addCertificate(certificateToken);
            }
        }
        catch (GeneralSecurityException e) {
            throw new DSSException("Unable to retrieve certificates from the keystore", (Throwable)e);
        }
    }

    public CertificateToken getCertificate(String alias) {
        try {
            String aliasToSearch = this.getKey(alias);
            if (this.keyStore.containsAlias(aliasToSearch)) {
                Certificate certificate = this.keyStore.getCertificate(aliasToSearch);
                return DSSUtils.loadCertificate(certificate.getEncoded());
            }
            LOG.warn("Certificate '{}' not found in the keystore", (Object)aliasToSearch);
            return null;
        }
        catch (GeneralSecurityException e) {
            throw new DSSException("Unable to retrieve certificate from the keystore", (Throwable)e);
        }
    }

    public void addAllCertificatesToKeyStore(List<CertificateToken> certificates) {
        for (CertificateToken certificateToken : certificates) {
            this.addCertificateToKeyStore(certificateToken);
        }
    }

    public void addCertificateToKeyStore(CertificateToken certificateToken) {
        try {
            this.keyStore.setCertificateEntry(this.getKey(certificateToken.getDSSIdAsString()), certificateToken.getCertificate());
            super.addCertificate(certificateToken);
            LOG.debug("Certificate '{}' successfully added to the keystore", (Object)certificateToken);
        }
        catch (GeneralSecurityException e) {
            throw new DSSException("Unable to add certificate to the keystore", (Throwable)e);
        }
    }

    @Override
    public CertificateToken addCertificate(CertificateToken certificateToAdd) {
        throw new UnsupportedOperationException("Use addCertificateToKeyStore(CertificateToken) method to add a certificate to keyStore!");
    }

    public void deleteCertificateFromKeyStore(String alias) {
        try {
            if (this.keyStore.containsAlias(alias)) {
                CertificateToken certificate = this.getCertificate(alias);
                this.removeCertificate(certificate);
                this.keyStore.deleteEntry(alias);
                LOG.debug("Certificate '{}' successfully removed from the keystore", (Object)alias);
            } else {
                LOG.warn("Certificate '{}' not found in the keystore", (Object)alias);
            }
        }
        catch (GeneralSecurityException e) {
            throw new DSSException("Unable to delete certificate from the keystore", (Throwable)e);
        }
    }

    public void clearAllCertificates() {
        try {
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                this.deleteCertificateFromKeyStore(alias);
            }
            this.reset();
            LOG.debug("Keystore has been successfully cleared");
        }
        catch (GeneralSecurityException e) {
            throw new DSSException("Unable to clear certificates from the keystore", (Throwable)e);
        }
    }

    public void store(OutputStream os) {
        try {
            this.keyStore.store(os, this.passwordProtection);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new DSSException("Unable to store the keystore", (Throwable)e);
        }
    }

    private String getKey(String inputKey) {
        if ("PKCS12".equals(this.keyStore.getType())) {
            return inputKey.toLowerCase(Locale.ROOT);
        }
        return inputKey;
    }
}

