/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.Revocation;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeRevocationSource<T extends Revocation, R extends RevocationSource<T>>
implements RevocationSource<T> {
    private static final long serialVersionUID = 948088043702414489L;
    private static final Logger LOG = LoggerFactory.getLogger(CompositeRevocationSource.class);
    private Map<String, R> compositeRevocationSources;

    public void setSources(Map<String, R> compositeRevocationSources) {
        this.compositeRevocationSources = compositeRevocationSources;
    }

    @Override
    public RevocationToken<T> getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        for (Map.Entry<String, R> entry : this.compositeRevocationSources.entrySet()) {
            String sourceKey = entry.getKey();
            RevocationSource source = (RevocationSource)entry.getValue();
            LOG.debug("Trying to get revocation token with Source '{}'", (Object)sourceKey);
            try {
                RevocationToken ocspToken = source.getRevocationToken(certificateToken, issuerCertificateToken);
                if (ocspToken == null) continue;
                LOG.debug("Successfully retrieved revocation token with Source '{}'", (Object)sourceKey);
                return ocspToken;
            }
            catch (Exception e) {
                LOG.debug("Unable to retrieve the revocation token with Source '{}' : {}", (Object)sourceKey, (Object)e.getMessage());
            }
        }
        LOG.debug("Unable to retrieve the ocsp token (" + this.compositeRevocationSources.size() + " tries)");
        return null;
    }
}

