/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.client.http;

import eu.europa.esig.dss.spi.client.http.MaxSizeInputStream;
import eu.europa.esig.dss.spi.exception.DSSExternalResourceException;
import eu.europa.esig.dss.utils.Utils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.Callable;

public class NativeDataLoaderCall
implements Callable<byte[]> {
    private static final String ERROR_MESSAGE = "An error occurred while reading from url '%s' : %s";
    private final String url;
    private final byte[] content;
    private final boolean useCaches;
    private final int maxInputSize;
    private final int connectTimeout;
    private final int readTimeout;

    public NativeDataLoaderCall(String url, byte[] content, boolean useCaches, int maxInputSize) {
        this(url, content, useCaches, maxInputSize, 0, 0);
    }

    public NativeDataLoaderCall(String url, byte[] content, boolean useCaches, int maxInputSize, int connectTimeout, int readTimeout) {
        this.url = url;
        this.content = content;
        this.useCaches = useCaches;
        this.maxInputSize = maxInputSize;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    @Override
    public byte[] call() {
        byte[] result;
        OutputStream os = null;
        InputStream is = null;
        try {
            URLConnection connection = this.createConnection();
            connection.setUseCaches(this.useCaches);
            connection.setDoInput(true);
            if (this.connectTimeout > 0) {
                connection.setConnectTimeout(this.connectTimeout);
            }
            if (this.readTimeout > 0) {
                connection.setReadTimeout(this.readTimeout);
            }
            if (this.content != null) {
                connection.setDoOutput(true);
                os = connection.getOutputStream();
                Utils.write((byte[])this.content, (OutputStream)os);
            }
            is = connection.getInputStream();
            if (this.maxInputSize > 0) {
                is = new MaxSizeInputStream(is, this.maxInputSize, this.url);
            }
            result = Utils.toByteArray((InputStream)is);
        }
        catch (IOException e) {
            try {
                throw new DSSExternalResourceException(String.format(ERROR_MESSAGE, this.url, e.getMessage()), e);
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(os);
                Utils.closeQuietly(is);
                throw throwable;
            }
        }
        Utils.closeQuietly((Closeable)os);
        Utils.closeQuietly((Closeable)is);
        return result;
    }

    protected URLConnection createConnection() throws IOException {
        return new URL(this.url).openConnection();
    }
}

