/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.aia;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.aia.AIASource;
import eu.europa.esig.dss.spi.x509.aia.OnlineAIASource;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RepositoryAIASource
implements AIASource {
    private static final long serialVersionUID = -8629948836670094079L;
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryAIASource.class);
    protected OnlineAIASource proxiedSource;

    protected RepositoryAIASource() {
    }

    public void setProxySource(OnlineAIASource proxiedSource) {
        this.proxiedSource = proxiedSource;
    }

    @Override
    public Set<CertificateToken> getCertificatesByAIA(CertificateToken certificateToken) {
        return this.getCertificatesByAIA(certificateToken, false);
    }

    public Set<CertificateToken> getCertificatesByAIA(CertificateToken certificateToken, boolean forceRefresh) {
        Objects.requireNonNull(certificateToken, "CertificateToken shall be provided!");
        List<String> urls = DSSASN1Utils.getCAAccessLocations(certificateToken);
        if (Utils.isCollectionEmpty(urls)) {
            LOG.info("There is no AIA extension for certificate download.");
            return Collections.emptySet();
        }
        List<String> aiaKeys = this.initCertificateAIAKeys(urls);
        if (forceRefresh) {
            LOG.info("Cache is skipped to retrieve the certificates by AIA for the certificate with Id '{}'", (Object)certificateToken.getDSSIdAsString());
        } else {
            Set<CertificateToken> aiaCertificates = this.extractAIAFromCacheSource(aiaKeys);
            if (Utils.isCollectionNotEmpty(aiaCertificates)) {
                return aiaCertificates;
            }
        }
        return this.extractAndInsertCertificatesFromProxiedSource(certificateToken, aiaKeys);
    }

    private Set<CertificateToken> extractAndInsertCertificatesFromProxiedSource(CertificateToken certificateToken, List<String> aiaKeys) {
        if (this.proxiedSource == null) {
            LOG.warn("Proxied AIASource is not provided!");
            return Collections.emptySet();
        }
        List<String> existingAIAKeys = this.getExistingAIAKeys();
        for (String aiaKey : aiaKeys) {
            if (!existingAIAKeys.contains(aiaKey)) continue;
            LOG.info("AIA Certificates with key '{}' have been removed from DB", (Object)aiaKey);
            this.removeCertificates(aiaKey);
        }
        HashSet<CertificateToken> certificatesByAIA = new HashSet<CertificateToken>();
        List<OnlineAIASource.CertificatesAndAIAUrl> certificatesAndAIAUrls = this.proxiedSource.getCertificatesAndAIAUrls(certificateToken);
        if (Utils.isCollectionNotEmpty(certificatesAndAIAUrls)) {
            for (OnlineAIASource.CertificatesAndAIAUrl certificatesByAiaUrl : certificatesAndAIAUrls) {
                String aiaUrl = certificatesByAiaUrl.getAiaUrl();
                List<CertificateToken> certificateTokens = certificatesByAiaUrl.getCertificates();
                if (!Utils.isCollectionNotEmpty(certificateTokens)) continue;
                this.insertCertificates(aiaUrl, certificateTokens);
                certificatesByAIA.addAll(certificateTokens);
                LOG.info("Certificate tokens with AIA '{}' are added into the cache", (Object)aiaUrl);
            }
        }
        return certificatesByAIA;
    }

    protected abstract List<String> getExistingAIAKeys();

    protected List<String> initCertificateAIAKeys(List<String> aiaUrls) {
        ArrayList<String> keys = new ArrayList<String>();
        for (String url : aiaUrls) {
            keys.add(DSSUtils.getSHA1Digest(url));
        }
        return keys;
    }

    private Set<CertificateToken> extractAIAFromCacheSource(List<String> aiaKeys) {
        LinkedHashSet<CertificateToken> certificateTokens = new LinkedHashSet<CertificateToken>();
        for (String key : aiaKeys) {
            certificateTokens.addAll(this.findCertificates(key));
        }
        return certificateTokens;
    }

    protected abstract Set<CertificateToken> findCertificates(String var1);

    protected abstract void insertCertificates(String var1, Collection<CertificateToken> var2);

    protected abstract void removeCertificates(String var1);
}

