/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.policy;

import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Level;
import eu.europa.esig.dss.enumerations.SubContext;
import eu.europa.esig.dss.enumerations.ValidationModel;
import eu.europa.esig.dss.model.policy.CertificateApplicabilityRule;
import eu.europa.esig.dss.model.policy.CryptographicSuite;
import eu.europa.esig.dss.model.policy.DurationRule;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.model.policy.MultiValuesRule;
import eu.europa.esig.dss.model.policy.NumericValueRule;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.model.policy.ValueRule;
import eu.europa.esig.dss.policy.CertificateValuesConstraintWrapper;
import eu.europa.esig.dss.policy.CryptographicConstraintWrapper;
import eu.europa.esig.dss.policy.IntValueConstraintWrapper;
import eu.europa.esig.dss.policy.LevelConstraintWrapper;
import eu.europa.esig.dss.policy.MultiValuesConstraintWrapper;
import eu.europa.esig.dss.policy.TimeConstraintWrapper;
import eu.europa.esig.dss.policy.ValueConstraintWrapper;
import eu.europa.esig.dss.policy.jaxb.BasicSignatureConstraints;
import eu.europa.esig.dss.policy.jaxb.CertificateConstraints;
import eu.europa.esig.dss.policy.jaxb.CertificateValuesConstraint;
import eu.europa.esig.dss.policy.jaxb.ConstraintsParameters;
import eu.europa.esig.dss.policy.jaxb.ContainerConstraints;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.policy.jaxb.EIDAS;
import eu.europa.esig.dss.policy.jaxb.EvidenceRecordConstraints;
import eu.europa.esig.dss.policy.jaxb.IntValueConstraint;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.policy.jaxb.ModelConstraint;
import eu.europa.esig.dss.policy.jaxb.MultiValuesConstraint;
import eu.europa.esig.dss.policy.jaxb.PDFAConstraints;
import eu.europa.esig.dss.policy.jaxb.RevocationConstraints;
import eu.europa.esig.dss.policy.jaxb.SignatureConstraints;
import eu.europa.esig.dss.policy.jaxb.SignedAttributesConstraints;
import eu.europa.esig.dss.policy.jaxb.TimeConstraint;
import eu.europa.esig.dss.policy.jaxb.TimestampConstraints;
import eu.europa.esig.dss.policy.jaxb.UnsignedAttributesConstraints;
import eu.europa.esig.dss.policy.jaxb.ValueConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtsiValidationPolicy
implements ValidationPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(EtsiValidationPolicy.class);
    private static final ValidationModel DEFAULT_VALIDATION_MODEL = ValidationModel.SHELL;
    private ConstraintsParameters policy;

    public EtsiValidationPolicy(ConstraintsParameters policy) {
        this.policy = policy;
    }

    public MultiValuesRule getSignaturePolicyConstraint(Context context) {
        SignatureConstraints signatureConstraints = this.getSignatureConstraintsByContext(context);
        if (signatureConstraints != null) {
            return this.toRule(signatureConstraints.getAcceptablePolicies());
        }
        return null;
    }

    public LevelRule getSignaturePolicyIdentifiedConstraint(Context context) {
        SignatureConstraints signatureConstraints = this.getSignatureConstraintsByContext(context);
        if (signatureConstraints != null) {
            return this.toLevelRule(signatureConstraints.getPolicyAvailable());
        }
        return null;
    }

    public LevelRule getSignaturePolicyStorePresentConstraint(Context context) {
        SignatureConstraints signatureConstraints = this.getSignatureConstraintsByContext(context);
        if (signatureConstraints != null) {
            return this.toLevelRule(signatureConstraints.getSignaturePolicyStorePresent());
        }
        return null;
    }

    public LevelRule getSignaturePolicyPolicyHashValid(Context context) {
        SignatureConstraints signatureConstraints = this.getSignatureConstraintsByContext(context);
        if (signatureConstraints != null) {
            return this.toLevelRule(signatureConstraints.getPolicyHashMatch());
        }
        return null;
    }

    public MultiValuesRule getSignatureFormatConstraint(Context context) {
        SignatureConstraints signatureConstraints = this.getSignatureConstraintsByContext(context);
        if (signatureConstraints != null) {
            return this.toRule(signatureConstraints.getAcceptableFormats());
        }
        return null;
    }

    public LevelRule getSignerInformationStoreConstraint(Context context) {
        BasicSignatureConstraints basicSignatureConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignatureConstraints != null) {
            return this.toLevelRule(basicSignatureConstraints.getSignerInformationStore());
        }
        return null;
    }

    public LevelRule getByteRangeConstraint(Context context) {
        BasicSignatureConstraints basicSignatureConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignatureConstraints != null) {
            return this.toLevelRule(basicSignatureConstraints.getByteRange());
        }
        return null;
    }

    public LevelRule getByteRangeCollisionConstraint(Context context) {
        BasicSignatureConstraints basicSignatureConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignatureConstraints != null) {
            return this.toLevelRule(basicSignatureConstraints.getByteRangeCollision());
        }
        return null;
    }

    public LevelRule getByteRangeAllDocumentConstraint(Context context) {
        BasicSignatureConstraints basicSignatureConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignatureConstraints != null) {
            return this.toLevelRule(basicSignatureConstraints.getByteRangeAllDocument());
        }
        return null;
    }

    public LevelRule getPdfSignatureDictionaryConstraint(Context context) {
        BasicSignatureConstraints basicSignatureConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignatureConstraints != null) {
            return this.toLevelRule(basicSignatureConstraints.getPdfSignatureDictionary());
        }
        return null;
    }

    public LevelRule getPdfPageDifferenceConstraint(Context context) {
        BasicSignatureConstraints basicSignatureConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignatureConstraints != null) {
            return this.toLevelRule(basicSignatureConstraints.getPdfPageDifference());
        }
        return null;
    }

    public LevelRule getPdfAnnotationOverlapConstraint(Context context) {
        BasicSignatureConstraints basicSignatureConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignatureConstraints != null) {
            return this.toLevelRule(basicSignatureConstraints.getPdfAnnotationOverlap());
        }
        return null;
    }

    public LevelRule getPdfVisualDifferenceConstraint(Context context) {
        BasicSignatureConstraints basicSignatureConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignatureConstraints != null) {
            return this.toLevelRule(basicSignatureConstraints.getPdfVisualDifference());
        }
        return null;
    }

    public LevelRule getDocMDPConstraint(Context context) {
        BasicSignatureConstraints basicSignatureConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignatureConstraints != null) {
            return this.toLevelRule(basicSignatureConstraints.getDocMDP());
        }
        return null;
    }

    public LevelRule getFieldMDPConstraint(Context context) {
        BasicSignatureConstraints basicSignatureConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignatureConstraints != null) {
            return this.toLevelRule(basicSignatureConstraints.getFieldMDP());
        }
        return null;
    }

    public LevelRule getSigFieldLockConstraint(Context context) {
        BasicSignatureConstraints basicSignatureConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignatureConstraints != null) {
            return this.toLevelRule(basicSignatureConstraints.getSigFieldLock());
        }
        return null;
    }

    public LevelRule getFormFillChangesConstraint(Context context) {
        BasicSignatureConstraints basicSignatureConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignatureConstraints != null) {
            return this.toLevelRule(basicSignatureConstraints.getFormFillChanges());
        }
        return null;
    }

    public LevelRule getAnnotationChangesConstraint(Context context) {
        BasicSignatureConstraints basicSignatureConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignatureConstraints != null) {
            return this.toLevelRule(basicSignatureConstraints.getAnnotationChanges());
        }
        return null;
    }

    public LevelRule getUndefinedChangesConstraint(Context context) {
        BasicSignatureConstraints basicSignatureConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignatureConstraints != null) {
            return this.toLevelRule(basicSignatureConstraints.getUndefinedChanges());
        }
        return null;
    }

    public LevelRule getStructuralValidationConstraint(Context context) {
        SignatureConstraints signatureConstraints = this.getSignatureConstraintsByContext(context);
        if (signatureConstraints != null) {
            return this.toLevelRule(signatureConstraints.getStructuralValidation());
        }
        return null;
    }

    public LevelRule getSigningCertificateRefersCertificateChainConstraint(Context context) {
        SignedAttributesConstraints signedAttributeConstraints = this.getSignedAttributeConstraints(context);
        if (signedAttributeConstraints != null) {
            return this.toLevelRule(signedAttributeConstraints.getSigningCertificateRefersCertificateChain());
        }
        return null;
    }

    public LevelRule getReferencesToAllCertificateChainPresentConstraint(Context context) {
        SignedAttributesConstraints signedAttributeConstraints = this.getSignedAttributeConstraints(context);
        if (signedAttributeConstraints != null) {
            return this.toLevelRule(signedAttributeConstraints.getReferencesToAllCertificateChainPresent());
        }
        return null;
    }

    public LevelRule getSigningCertificateDigestAlgorithmConstraint(Context context) {
        SignedAttributesConstraints signedAttributeConstraints = this.getSignedAttributeConstraints(context);
        if (signedAttributeConstraints != null) {
            return this.toLevelRule(signedAttributeConstraints.getSigningCertificateDigestAlgorithm());
        }
        return null;
    }

    public LevelRule getSigningDurationRule(Context context) {
        SignedAttributesConstraints signedAttributeConstraints = this.getSignedAttributeConstraints(context);
        if (signedAttributeConstraints != null) {
            return this.toLevelRule(signedAttributeConstraints.getSigningTime());
        }
        return null;
    }

    public ValueRule getContentTypeConstraint(Context context) {
        SignedAttributesConstraints signedAttributeConstraints = this.getSignedAttributeConstraints(context);
        if (signedAttributeConstraints != null) {
            return this.toRule(signedAttributeConstraints.getContentType());
        }
        return null;
    }

    public LevelRule getCounterSignatureConstraint(Context context) {
        UnsignedAttributesConstraints unsignedAttributeConstraints = this.getUnsignedAttributeConstraints(context);
        if (unsignedAttributeConstraints != null) {
            return this.toLevelRule(unsignedAttributeConstraints.getCounterSignature());
        }
        return null;
    }

    public LevelRule getSignatureTimeStampConstraint(Context context) {
        UnsignedAttributesConstraints unsignedAttributeConstraints = this.getUnsignedAttributeConstraints(context);
        if (unsignedAttributeConstraints != null) {
            return this.toLevelRule(unsignedAttributeConstraints.getSignatureTimeStamp());
        }
        return null;
    }

    public LevelRule getValidationDataTimeStampConstraint(Context context) {
        UnsignedAttributesConstraints unsignedAttributeConstraints = this.getUnsignedAttributeConstraints(context);
        if (unsignedAttributeConstraints != null) {
            return this.toLevelRule(unsignedAttributeConstraints.getValidationDataTimeStamp());
        }
        return null;
    }

    public LevelRule getValidationDataRefsOnlyTimeStampConstraint(Context context) {
        UnsignedAttributesConstraints unsignedAttributeConstraints = this.getUnsignedAttributeConstraints(context);
        if (unsignedAttributeConstraints != null) {
            return this.toLevelRule(unsignedAttributeConstraints.getValidationDataRefsOnlyTimeStamp());
        }
        return null;
    }

    public LevelRule getArchiveTimeStampConstraint(Context context) {
        UnsignedAttributesConstraints unsignedAttributeConstraints = this.getUnsignedAttributeConstraints(context);
        if (unsignedAttributeConstraints != null) {
            return this.toLevelRule(unsignedAttributeConstraints.getArchiveTimeStamp());
        }
        return null;
    }

    public LevelRule getDocumentTimeStampConstraint(Context context) {
        UnsignedAttributesConstraints unsignedAttributeConstraints = this.getUnsignedAttributeConstraints(context);
        if (unsignedAttributeConstraints != null) {
            return this.toLevelRule(unsignedAttributeConstraints.getDocumentTimeStamp());
        }
        return null;
    }

    public LevelRule getTLevelTimeStampConstraint(Context context) {
        UnsignedAttributesConstraints unsignedAttributeConstraints = this.getUnsignedAttributeConstraints(context);
        if (unsignedAttributeConstraints != null) {
            return this.toLevelRule(unsignedAttributeConstraints.getTLevelTimeStamp());
        }
        return null;
    }

    public LevelRule getLTALevelTimeStampConstraint(Context context) {
        UnsignedAttributesConstraints unsignedAttributeConstraints = this.getUnsignedAttributeConstraints(context);
        if (unsignedAttributeConstraints != null) {
            return this.toLevelRule(unsignedAttributeConstraints.getLTALevelTimeStamp());
        }
        return null;
    }

    public ValueRule getContentHintsConstraint(Context context) {
        SignedAttributesConstraints signedAttributeConstraints = this.getSignedAttributeConstraints(context);
        if (signedAttributeConstraints != null) {
            return this.toRule(signedAttributeConstraints.getContentHints());
        }
        return null;
    }

    public ValueRule getContentIdentifierConstraint(Context context) {
        SignedAttributesConstraints signedAttributeConstraints = this.getSignedAttributeConstraints(context);
        if (signedAttributeConstraints != null) {
            return this.toRule(signedAttributeConstraints.getContentIdentifier());
        }
        return null;
    }

    public LevelRule getMessageDigestOrSignedPropertiesConstraint(Context context) {
        SignedAttributesConstraints signedAttributeConstraints = this.getSignedAttributeConstraints(context);
        if (signedAttributeConstraints != null) {
            return this.toLevelRule(signedAttributeConstraints.getMessageDigestOrSignedPropertiesPresent());
        }
        return null;
    }

    public LevelRule getEllipticCurveKeySizeConstraint(Context context) {
        SignedAttributesConstraints signedAttributeConstraints = this.getSignedAttributeConstraints(context);
        if (signedAttributeConstraints != null) {
            return this.toLevelRule(signedAttributeConstraints.getEllipticCurveKeySize());
        }
        return null;
    }

    public MultiValuesRule getCommitmentTypeIndicationConstraint(Context context) {
        SignedAttributesConstraints signedAttributeConstraints = this.getSignedAttributeConstraints(context);
        if (signedAttributeConstraints != null) {
            return this.toRule(signedAttributeConstraints.getCommitmentTypeIndication());
        }
        return null;
    }

    public LevelRule getSignerLocationConstraint(Context context) {
        SignedAttributesConstraints signedAttributeConstraints = this.getSignedAttributeConstraints(context);
        if (signedAttributeConstraints != null) {
            return this.toLevelRule(signedAttributeConstraints.getSignerLocation());
        }
        return null;
    }

    public MultiValuesRule getClaimedRoleConstraint(Context context) {
        SignedAttributesConstraints signedAttributeConstraints = this.getSignedAttributeConstraints(context);
        if (signedAttributeConstraints != null) {
            return this.toRule(signedAttributeConstraints.getClaimedRoles());
        }
        return null;
    }

    public MultiValuesRule getCertifiedRolesConstraint(Context context) {
        SignedAttributesConstraints signedAttributeConstraints = this.getSignedAttributeConstraints(context);
        if (signedAttributeConstraints != null) {
            return this.toRule(signedAttributeConstraints.getCertifiedRoles());
        }
        return null;
    }

    public String getPolicyName() {
        return this.policy.getName();
    }

    public String getPolicyDescription() {
        return this.policy.getDescription();
    }

    public CryptographicSuite getSignatureCryptographicConstraint(Context context) {
        CryptographicConstraint sigCryptographic = new CryptographicConstraint();
        BasicSignatureConstraints basicSignature = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignature != null && basicSignature.getCryptographic() != null) {
            sigCryptographic = basicSignature.getCryptographic();
        }
        this.initializeCryptographicSuite(sigCryptographic, this.getCryptographic());
        return this.toCryptographicSuite(sigCryptographic);
    }

    private CryptographicConstraint getSignatureCryptographic(Context context) {
        CryptographicConstraint sigCryptographic = new CryptographicConstraint();
        BasicSignatureConstraints basicSignature = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignature != null && basicSignature.getCryptographic() != null) {
            sigCryptographic = basicSignature.getCryptographic();
        }
        this.initializeCryptographicSuite(sigCryptographic, this.getCryptographic());
        return sigCryptographic;
    }

    public CryptographicSuite getCertificateCryptographicConstraint(Context context, SubContext subContext) {
        CryptographicConstraint certCryptographic = new CryptographicConstraint();
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null && certificateConstraints.getCryptographic() != null) {
            certCryptographic = certificateConstraints.getCryptographic();
        }
        this.initializeCryptographicSuite(certCryptographic, this.getSignatureCryptographic(context));
        return this.toCryptographicSuite(certCryptographic);
    }

    private void initializeCryptographicSuite(CryptographicConstraint cryptographicConstraint, CryptographicConstraint defaultConstraint) {
        if (defaultConstraint != null) {
            if (cryptographicConstraint.getAcceptableDigestAlgo() == null) {
                cryptographicConstraint.setAcceptableDigestAlgo(defaultConstraint.getAcceptableDigestAlgo());
            }
            if (cryptographicConstraint.getAcceptableEncryptionAlgo() == null) {
                cryptographicConstraint.setAcceptableEncryptionAlgo(defaultConstraint.getAcceptableEncryptionAlgo());
            }
            if (cryptographicConstraint.getAlgoExpirationDate() == null) {
                cryptographicConstraint.setAlgoExpirationDate(defaultConstraint.getAlgoExpirationDate());
            }
            if (cryptographicConstraint.getLevel() == null) {
                cryptographicConstraint.setLevel(defaultConstraint.getLevel());
            }
            if (cryptographicConstraint.getMiniPublicKeySize() == null) {
                cryptographicConstraint.setMiniPublicKeySize(defaultConstraint.getMiniPublicKeySize());
            }
        }
    }

    public LevelRule getCertificateCAConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toLevelRule(certificateConstraints.getCA());
        }
        return null;
    }

    public LevelRule getCertificateIssuerNameConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toLevelRule(certificateConstraints.getIssuerName());
        }
        return null;
    }

    public LevelRule getCertificateMaxPathLengthConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toLevelRule(certificateConstraints.getMaxPathLength());
        }
        return null;
    }

    public MultiValuesRule getCertificateKeyUsageConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toRule(certificateConstraints.getKeyUsage());
        }
        return null;
    }

    public MultiValuesRule getCertificateExtendedKeyUsageConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toRule(certificateConstraints.getExtendedKeyUsage());
        }
        return null;
    }

    public LevelRule getCertificatePolicyTreeConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toLevelRule(certificateConstraints.getPolicyTree());
        }
        return null;
    }

    public LevelRule getCertificateNameConstraintsConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toLevelRule(certificateConstraints.getNameConstraints());
        }
        return null;
    }

    public LevelRule getCertificateNoRevAvailConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toLevelRule(certificateConstraints.getNoRevAvail());
        }
        return null;
    }

    public MultiValuesRule getCertificateSupportedCriticalExtensionsConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toRule(certificateConstraints.getSupportedCriticalExtensions());
        }
        return null;
    }

    public MultiValuesRule getCertificateForbiddenExtensionsConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toRule(certificateConstraints.getForbiddenExtensions());
        }
        return null;
    }

    public MultiValuesRule getCertificateSurnameConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toRule(certificateConstraints.getSurname());
        }
        return null;
    }

    public MultiValuesRule getCertificateGivenNameConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toRule(certificateConstraints.getGivenName());
        }
        return null;
    }

    public MultiValuesRule getCertificateCommonNameConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toRule(certificateConstraints.getCommonName());
        }
        return null;
    }

    public MultiValuesRule getCertificatePseudonymConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toRule(certificateConstraints.getPseudonym());
        }
        return null;
    }

    public MultiValuesRule getCertificateTitleConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toRule(certificateConstraints.getTitle());
        }
        return null;
    }

    public MultiValuesRule getCertificateEmailConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toRule(certificateConstraints.getEmail());
        }
        return null;
    }

    public MultiValuesRule getCertificateCountryConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toRule(certificateConstraints.getCountry());
        }
        return null;
    }

    public MultiValuesRule getCertificateLocalityConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toRule(certificateConstraints.getLocality());
        }
        return null;
    }

    public MultiValuesRule getCertificateStateConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toRule(certificateConstraints.getState());
        }
        return null;
    }

    public MultiValuesRule getCertificateOrganizationIdentifierConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toRule(certificateConstraints.getOrganizationIdentifier());
        }
        return null;
    }

    public MultiValuesRule getCertificateOrganizationNameConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toRule(certificateConstraints.getOrganizationName());
        }
        return null;
    }

    public MultiValuesRule getCertificateOrganizationUnitConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toRule(certificateConstraints.getOrganizationUnit());
        }
        return null;
    }

    public LevelRule getCertificatePseudoUsageConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toLevelRule(certificateConstraints.getUsePseudonym());
        }
        return null;
    }

    public LevelRule getCertificateSerialNumberConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toLevelRule(certificateConstraints.getSerialNumberPresent());
        }
        return null;
    }

    public LevelRule getCertificateNotExpiredConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toLevelRule(certificateConstraints.getNotExpired());
        }
        return null;
    }

    public LevelRule getCertificateSunsetDateConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toLevelRule(certificateConstraints.getSunsetDate());
        }
        return null;
    }

    public LevelRule getProspectiveCertificateChainConstraint(Context context) {
        BasicSignatureConstraints basicSignatureConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignatureConstraints != null) {
            return this.toLevelRule(basicSignatureConstraints.getProspectiveCertificateChain());
        }
        return null;
    }

    public LevelRule getCertificateAuthorityInfoAccessPresentConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toLevelRule(certificateConstraints.getAuthorityInfoAccessPresent());
        }
        return null;
    }

    public CertificateApplicabilityRule getRevocationDataSkipConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null && certificateConstraints.getRevocationDataSkip() != null) {
            return this.toRule(certificateConstraints.getRevocationDataSkip());
        }
        return null;
    }

    public LevelRule getCertificateRevocationInfoAccessPresentConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toLevelRule(certificateConstraints.getRevocationInfoAccessPresent());
        }
        return null;
    }

    public LevelRule getCertificateSignatureConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toLevelRule(certificateConstraints.getSignature());
        }
        return null;
    }

    public LevelRule getUnknownStatusConstraint() {
        RevocationConstraints revocationConstraints = this.getRevocationConstraints();
        if (revocationConstraints != null) {
            return this.toLevelRule(revocationConstraints.getUnknownStatus());
        }
        return null;
    }

    public LevelRule getThisUpdatePresentConstraint() {
        RevocationConstraints revocationConstraints = this.getRevocationConstraints();
        if (revocationConstraints != null) {
            LevelConstraint constraint = revocationConstraints.getThisUpdatePresent();
            if (constraint == null) {
                constraint = new LevelConstraint();
                constraint.setLevel(Level.FAIL);
                LOG.warn("No ThisUpdatePresent constraint is defined in the validation policy for Revocation element! Default behavior with FAIL level is added to processing. Please set the constraint explicitly. To be required since DSS 6.4.");
            }
            return this.toLevelRule(constraint);
        }
        return null;
    }

    public LevelRule getRevocationIssuerKnownConstraint() {
        RevocationConstraints revocationConstraints = this.getRevocationConstraints();
        if (revocationConstraints != null) {
            LevelConstraint constraint = revocationConstraints.getRevocationIssuerKnown();
            if (constraint == null) {
                constraint = new LevelConstraint();
                constraint.setLevel(Level.FAIL);
                LOG.warn("No RevocationIssuerKnown constraint is defined in the validation policy for Revocation element! Default behavior with FAIL level is added to processing. Please set the constraint explicitly. To be required since DSS 6.4.");
            }
            return this.toLevelRule(constraint);
        }
        return null;
    }

    public LevelRule getRevocationIssuerValidAtProductionTimeConstraint() {
        RevocationConstraints revocationConstraints = this.getRevocationConstraints();
        if (revocationConstraints != null) {
            LevelConstraint constraint = revocationConstraints.getRevocationIssuerValidAtProductionTime();
            if (constraint == null) {
                constraint = new LevelConstraint();
                constraint.setLevel(Level.FAIL);
                LOG.warn("No RevocationIssuerValidAtProductionTime constraint is defined in the validation policy for Revocation element! Default behavior with FAIL level is added to processing. Please set the constraint explicitly. To be required since DSS 6.4.");
            }
            return this.toLevelRule(constraint);
        }
        return null;
    }

    public LevelRule getRevocationAfterCertificateIssuanceConstraint() {
        RevocationConstraints revocationConstraints = this.getRevocationConstraints();
        if (revocationConstraints != null) {
            LevelConstraint constraint = revocationConstraints.getRevocationAfterCertificateIssuance();
            if (constraint == null) {
                constraint = new LevelConstraint();
                constraint.setLevel(Level.FAIL);
                LOG.warn("No RevocationIssuerKnowsCertificate constraint is defined in the validation policy for Revocation element! Default behavior with FAIL level is added to processing. Please set the constraint explicitly. To be required since DSS 6.4.");
            }
            return this.toLevelRule(constraint);
        }
        return null;
    }

    public LevelRule getRevocationHasInformationAboutCertificateConstraint() {
        RevocationConstraints revocationConstraints = this.getRevocationConstraints();
        if (revocationConstraints != null) {
            LevelConstraint constraint = revocationConstraints.getRevocationHasInformationAboutCertificate();
            if (constraint == null) {
                constraint = new LevelConstraint();
                constraint.setLevel(Level.FAIL);
                LOG.warn("No RevocationIssuerHasInformationAboutCertificate constraint is defined in the validation policy for Revocation element! Default behavior with FAIL level is added to processing. Please set the constraint explicitly. To be required since DSS 6.4.");
            }
            return this.toLevelRule(constraint);
        }
        return null;
    }

    public LevelRule getOCSPResponseResponderIdMatchConstraint() {
        RevocationConstraints revocationConstraints = this.getRevocationConstraints();
        if (revocationConstraints != null) {
            return this.toLevelRule(revocationConstraints.getOCSPResponderIdMatch());
        }
        return null;
    }

    public LevelRule getOCSPResponseCertHashPresentConstraint() {
        RevocationConstraints revocationConstraints = this.getRevocationConstraints();
        if (revocationConstraints != null) {
            return this.toLevelRule(revocationConstraints.getOCSPCertHashPresent());
        }
        return null;
    }

    public LevelRule getOCSPResponseCertHashMatchConstraint() {
        RevocationConstraints revocationConstraints = this.getRevocationConstraints();
        if (revocationConstraints != null) {
            return this.toLevelRule(revocationConstraints.getOCSPCertHashMatch());
        }
        return null;
    }

    public LevelRule getSelfIssuedOCSPConstraint() {
        RevocationConstraints revocationConstraints = this.getRevocationConstraints();
        if (revocationConstraints != null) {
            return this.toLevelRule(revocationConstraints.getSelfIssuedOCSP());
        }
        return null;
    }

    public LevelRule getRevocationDataAvailableConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toLevelRule(certificateConstraints.getRevocationDataAvailable());
        }
        return null;
    }

    public LevelRule getAcceptableRevocationDataFoundConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toLevelRule(certificateConstraints.getAcceptableRevocationDataFound());
        }
        return null;
    }

    public LevelRule getCRLNextUpdatePresentConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toLevelRule(certificateConstraints.getCRLNextUpdatePresent());
        }
        return null;
    }

    public LevelRule getOCSPNextUpdatePresentConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toLevelRule(certificateConstraints.getOCSPNextUpdatePresent());
        }
        return null;
    }

    public DurationRule getRevocationFreshnessConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toRule(certificateConstraints.getRevocationFreshness());
        }
        return null;
    }

    public LevelRule getRevocationFreshnessNextUpdateConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toLevelRule(certificateConstraints.getRevocationFreshnessNextUpdate());
        }
        return null;
    }

    public LevelRule getCertificateNotRevokedConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toLevelRule(certificateConstraints.getNotRevoked());
        }
        return null;
    }

    public LevelRule getCertificateNotOnHoldConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toLevelRule(certificateConstraints.getNotOnHold());
        }
        return null;
    }

    public LevelRule getRevocationIssuerNotExpiredConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toLevelRule(certificateConstraints.getRevocationIssuerNotExpired());
        }
        return null;
    }

    public LevelRule getCertificateNotSelfSignedConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toLevelRule(certificateConstraints.getNotSelfSigned());
        }
        return null;
    }

    public LevelRule getCertificateSelfSignedConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toLevelRule(certificateConstraints.getSelfSigned());
        }
        return null;
    }

    public MultiValuesRule getTrustServiceStatusConstraint(Context context) {
        BasicSignatureConstraints sigConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (sigConstraints != null) {
            return this.toRule(sigConstraints.getTrustServiceStatus());
        }
        return null;
    }

    public MultiValuesRule getTrustServiceTypeIdentifierConstraint(Context context) {
        BasicSignatureConstraints sigConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (sigConstraints != null) {
            return this.toRule(sigConstraints.getTrustServiceTypeIdentifier());
        }
        return null;
    }

    public MultiValuesRule getCertificatePolicyIdsConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toRule(certificateConstraints.getPolicyIds());
        }
        return null;
    }

    public LevelRule getCertificatePolicyQualificationIdsConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toLevelRule(certificateConstraints.getPolicyQualificationIds());
        }
        return null;
    }

    public LevelRule getCertificatePolicySupportedByQSCDIdsConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toLevelRule(certificateConstraints.getPolicySupportedByQSCDIds());
        }
        return null;
    }

    public LevelRule getCertificateQCComplianceConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toLevelRule(certificateConstraints.getQcCompliance());
        }
        return null;
    }

    public ValueRule getCertificateQcEuLimitValueCurrencyConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toRule(certificateConstraints.getQcEuLimitValueCurrency());
        }
        return null;
    }

    public NumericValueRule getCertificateMinQcEuLimitValueConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toRule(certificateConstraints.getMinQcEuLimitValue());
        }
        return null;
    }

    public NumericValueRule getCertificateMinQcEuRetentionPeriodConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toRule(certificateConstraints.getMinQcEuRetentionPeriod());
        }
        return null;
    }

    public LevelRule getCertificateQcSSCDConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toLevelRule(certificateConstraints.getQcSSCD());
        }
        return null;
    }

    public MultiValuesRule getCertificateQcEuPDSLocationConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toRule(certificateConstraints.getQcEuPDSLocation());
        }
        return null;
    }

    public MultiValuesRule getCertificateQcTypeConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toRule(certificateConstraints.getQcType());
        }
        return null;
    }

    public MultiValuesRule getCertificateQcCCLegislationConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toRule(certificateConstraints.getQcLegislationCountryCodes());
        }
        return null;
    }

    public LevelRule getCertificateIssuedToNaturalPersonConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toLevelRule(certificateConstraints.getIssuedToNaturalPerson());
        }
        return null;
    }

    public LevelRule getCertificateIssuedToLegalPersonConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toLevelRule(certificateConstraints.getIssuedToLegalPerson());
        }
        return null;
    }

    public MultiValuesRule getCertificateSemanticsIdentifierConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toRule(certificateConstraints.getSemanticsIdentifier());
        }
        return null;
    }

    public MultiValuesRule getCertificatePS2DQcTypeRolesOfPSPConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toRule(certificateConstraints.getPSD2QcTypeRolesOfPSP());
        }
        return null;
    }

    public MultiValuesRule getCertificatePS2DQcCompetentAuthorityNameConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toRule(certificateConstraints.getPSD2QcCompetentAuthorityName());
        }
        return null;
    }

    public MultiValuesRule getCertificatePS2DQcCompetentAuthorityIdConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return this.toRule(certificateConstraints.getPSD2QcCompetentAuthorityId());
        }
        return null;
    }

    public LevelRule getSigningCertificateRecognitionConstraint(Context context) {
        CertificateConstraints certificateConstraints = this.getSigningCertificateByContext(context);
        if (certificateConstraints != null) {
            return this.toLevelRule(certificateConstraints.getRecognition());
        }
        return null;
    }

    public LevelRule getSigningCertificateAttributePresentConstraint(Context context) {
        SignedAttributesConstraints signedAttributeConstraints = this.getSignedAttributeConstraints(context);
        if (signedAttributeConstraints != null) {
            return this.toLevelRule(signedAttributeConstraints.getSigningCertificatePresent());
        }
        return null;
    }

    public LevelRule getUnicitySigningCertificateAttributeConstraint(Context context) {
        SignedAttributesConstraints signedAttributeConstraints = this.getSignedAttributeConstraints(context);
        if (signedAttributeConstraints != null) {
            return this.toLevelRule(signedAttributeConstraints.getUnicitySigningCertificate());
        }
        return null;
    }

    public LevelRule getSigningCertificateDigestValuePresentConstraint(Context context) {
        SignedAttributesConstraints signedAttributeConstraints = this.getSignedAttributeConstraints(context);
        if (signedAttributeConstraints != null) {
            return this.toLevelRule(signedAttributeConstraints.getCertDigestPresent());
        }
        return null;
    }

    public LevelRule getSigningCertificateDigestValueMatchConstraint(Context context) {
        SignedAttributesConstraints signedAttributeConstraints = this.getSignedAttributeConstraints(context);
        if (signedAttributeConstraints != null) {
            return this.toLevelRule(signedAttributeConstraints.getCertDigestMatch());
        }
        return null;
    }

    public LevelRule getSigningCertificateIssuerSerialMatchConstraint(Context context) {
        SignedAttributesConstraints signedAttributeConstraints = this.getSignedAttributeConstraints(context);
        if (signedAttributeConstraints != null) {
            return this.toLevelRule(signedAttributeConstraints.getIssuerSerialMatch());
        }
        return null;
    }

    public LevelRule getKeyIdentifierPresent(Context context) {
        SignedAttributesConstraints signedAttributeConstraints = this.getSignedAttributeConstraints(context);
        if (signedAttributeConstraints != null) {
            return this.toLevelRule(signedAttributeConstraints.getKeyIdentifierPresent());
        }
        return null;
    }

    public LevelRule getKeyIdentifierMatch(Context context) {
        SignedAttributesConstraints signedAttributeConstraints = this.getSignedAttributeConstraints(context);
        if (signedAttributeConstraints != null) {
            return this.toLevelRule(signedAttributeConstraints.getKeyIdentifierMatch());
        }
        return null;
    }

    public LevelRule getReferenceDataExistenceConstraint(Context context) {
        BasicSignatureConstraints basicSignatureConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignatureConstraints != null) {
            return this.toLevelRule(basicSignatureConstraints.getReferenceDataExistence());
        }
        return null;
    }

    public LevelRule getReferenceDataIntactConstraint(Context context) {
        BasicSignatureConstraints basicSignatureConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignatureConstraints != null) {
            return this.toLevelRule(basicSignatureConstraints.getReferenceDataIntact());
        }
        return null;
    }

    public LevelRule getReferenceDataNameMatchConstraint(Context context) {
        BasicSignatureConstraints basicSignatureConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignatureConstraints != null) {
            return this.toLevelRule(basicSignatureConstraints.getReferenceDataNameMatch());
        }
        return null;
    }

    public LevelRule getManifestEntryObjectExistenceConstraint(Context context) {
        BasicSignatureConstraints basicSignatureConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignatureConstraints != null) {
            return this.toLevelRule(basicSignatureConstraints.getManifestEntryObjectExistence());
        }
        return null;
    }

    public LevelRule getManifestEntryObjectIntactConstraint(Context context) {
        BasicSignatureConstraints basicSignatureConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignatureConstraints != null) {
            return this.toLevelRule(basicSignatureConstraints.getManifestEntryObjectIntact());
        }
        return null;
    }

    public LevelRule getManifestEntryObjectGroupConstraint(Context context) {
        BasicSignatureConstraints basicSignatureConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignatureConstraints != null) {
            return this.toLevelRule(basicSignatureConstraints.getManifestEntryObjectGroup());
        }
        return null;
    }

    public LevelRule getManifestEntryNameMatchConstraint(Context context) {
        BasicSignatureConstraints basicSignatureConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignatureConstraints != null) {
            return this.toLevelRule(basicSignatureConstraints.getManifestEntryNameMatch());
        }
        return null;
    }

    public LevelRule getSignatureIntactConstraint(Context context) {
        BasicSignatureConstraints basicSignatureConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignatureConstraints != null) {
            return this.toLevelRule(basicSignatureConstraints.getSignatureIntact());
        }
        return null;
    }

    public LevelRule getSignatureDuplicatedConstraint(Context context) {
        BasicSignatureConstraints basicSignatureConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignatureConstraints != null) {
            return this.toLevelRule(basicSignatureConstraints.getSignatureDuplicated());
        }
        return null;
    }

    public LevelRule getBestSignatureTimeBeforeExpirationDateOfSigningCertificateConstraint() {
        TimestampConstraints timestamp = this.getTimestampConstraints();
        if (timestamp != null) {
            return this.toLevelRule(timestamp.getBestSignatureTimeBeforeExpirationDateOfSigningCertificate());
        }
        return null;
    }

    public LevelRule getRevocationTimeAgainstBestSignatureDurationRule() {
        TimestampConstraints timestampConstraints = this.getTimestampConstraints();
        if (timestampConstraints != null) {
            return this.toLevelRule(timestampConstraints.getRevocationTimeAgainstBestSignatureTime());
        }
        return null;
    }

    public LevelRule getTimestampCoherenceConstraint() {
        TimestampConstraints timestampConstraints = this.getTimestampConstraints();
        if (timestampConstraints != null) {
            return this.toLevelRule(timestampConstraints.getCoherence());
        }
        return null;
    }

    public DurationRule getTimestampDelayConstraint() {
        TimestampConstraints timestampConstraints = this.getTimestampConstraints();
        if (timestampConstraints != null) {
            return this.toRule(timestampConstraints.getTimestampDelay());
        }
        return null;
    }

    public LevelRule getTimestampValidConstraint() {
        TimestampConstraints timestampConstraints = this.getTimestampConstraints();
        if (timestampConstraints != null) {
            return this.toLevelRule(timestampConstraints.getTimestampValid());
        }
        return null;
    }

    public LevelRule getTimestampTSAGeneralNamePresent() {
        TimestampConstraints timestampConstraints = this.getTimestampConstraints();
        if (timestampConstraints != null) {
            return this.toLevelRule(timestampConstraints.getTSAGeneralNamePresent());
        }
        return null;
    }

    public LevelRule getTimestampTSAGeneralNameContentMatch() {
        TimestampConstraints timestampConstraints = this.getTimestampConstraints();
        if (timestampConstraints != null) {
            return this.toLevelRule(timestampConstraints.getTSAGeneralNameContentMatch());
        }
        return null;
    }

    public LevelRule getTimestampTSAGeneralNameOrderMatch() {
        TimestampConstraints timestampConstraints = this.getTimestampConstraints();
        if (timestampConstraints != null) {
            return this.toLevelRule(timestampConstraints.getTSAGeneralNameOrderMatch());
        }
        return null;
    }

    public LevelRule getAtsHashIndexConstraint() {
        TimestampConstraints timestampConstraints = this.getTimestampConstraints();
        if (timestampConstraints != null) {
            return this.toLevelRule(timestampConstraints.getAtsHashIndex());
        }
        return null;
    }

    public LevelRule getTimestampContainerSignedAndTimestampedFilesCoveredConstraint() {
        TimestampConstraints timestampConstraints = this.getTimestampConstraints();
        if (timestampConstraints != null) {
            return this.toLevelRule(timestampConstraints.getContainerSignedAndTimestampedFilesCovered());
        }
        return null;
    }

    public LevelRule getFullScopeConstraint() {
        SignatureConstraints mainSignature = this.getSignatureConstraints();
        if (mainSignature != null) {
            return this.toLevelRule(mainSignature.getFullScope());
        }
        return null;
    }

    public LevelRule getContentTimeStampConstraint(Context context) {
        SignedAttributesConstraints signedAttributeConstraints = this.getSignedAttributeConstraints(context);
        if (signedAttributeConstraints != null) {
            return this.toLevelRule(signedAttributeConstraints.getContentTimeStamp());
        }
        return null;
    }

    public LevelRule getContentTimeStampMessageImprintConstraint(Context context) {
        SignedAttributesConstraints signedAttributeConstraints = this.getSignedAttributeConstraints(context);
        if (signedAttributeConstraints != null) {
            return this.toLevelRule(signedAttributeConstraints.getContentTimeStampMessageImprint());
        }
        return null;
    }

    public LevelRule getEvidenceRecordValidConstraint() {
        EvidenceRecordConstraints evidenceRecordConstraints = this.getEvidenceRecordConstraints();
        if (evidenceRecordConstraints != null) {
            return this.toLevelRule(evidenceRecordConstraints.getEvidenceRecordValid());
        }
        return null;
    }

    public LevelRule getEvidenceRecordDataObjectExistenceConstraint() {
        EvidenceRecordConstraints evidenceRecordConstraints = this.getEvidenceRecordConstraints();
        if (evidenceRecordConstraints != null) {
            return this.toLevelRule(evidenceRecordConstraints.getDataObjectExistence());
        }
        return null;
    }

    public LevelRule getEvidenceRecordDataObjectIntactConstraint() {
        EvidenceRecordConstraints evidenceRecordConstraints = this.getEvidenceRecordConstraints();
        if (evidenceRecordConstraints != null) {
            return this.toLevelRule(evidenceRecordConstraints.getDataObjectIntact());
        }
        return null;
    }

    public LevelRule getEvidenceRecordDataObjectFoundConstraint() {
        EvidenceRecordConstraints evidenceRecordConstraints = this.getEvidenceRecordConstraints();
        if (evidenceRecordConstraints != null) {
            return this.toLevelRule(evidenceRecordConstraints.getDataObjectFound());
        }
        return null;
    }

    public LevelRule getEvidenceRecordDataObjectGroupConstraint() {
        EvidenceRecordConstraints evidenceRecordConstraints = this.getEvidenceRecordConstraints();
        if (evidenceRecordConstraints != null) {
            return this.toLevelRule(evidenceRecordConstraints.getDataObjectGroup());
        }
        return null;
    }

    public LevelRule getEvidenceRecordSignedFilesCoveredConstraint() {
        EvidenceRecordConstraints evidenceRecordConstraints = this.getEvidenceRecordConstraints();
        if (evidenceRecordConstraints != null) {
            return this.toLevelRule(evidenceRecordConstraints.getSignedFilesCovered());
        }
        return null;
    }

    public LevelRule getEvidenceRecordContainerSignedAndTimestampedFilesCoveredConstraint() {
        EvidenceRecordConstraints evidenceRecordConstraints = this.getEvidenceRecordConstraints();
        if (evidenceRecordConstraints != null) {
            return this.toLevelRule(evidenceRecordConstraints.getContainerSignedAndTimestampedFilesCovered());
        }
        return null;
    }

    public LevelRule getEvidenceRecordHashTreeRenewalConstraint() {
        EvidenceRecordConstraints evidenceRecordConstraints = this.getEvidenceRecordConstraints();
        if (evidenceRecordConstraints != null) {
            return this.toLevelRule(evidenceRecordConstraints.getHashTreeRenewal());
        }
        return null;
    }

    public CryptographicSuite getEvidenceRecordCryptographicConstraint() {
        CryptographicConstraint evidenceRecordCryptographic = new CryptographicConstraint();
        EvidenceRecordConstraints evidenceRecordConstraints = this.getEvidenceRecordConstraints();
        if (evidenceRecordConstraints != null && evidenceRecordConstraints.getCryptographic() != null) {
            evidenceRecordCryptographic = evidenceRecordConstraints.getCryptographic();
        }
        this.initializeCryptographicSuite(evidenceRecordCryptographic, this.getCryptographic());
        return this.toCryptographicSuite(evidenceRecordCryptographic);
    }

    private CertificateConstraints getSigningCertificateByContext(Context context) {
        return this.getCertificateConstraints(context, SubContext.SIGNING_CERT);
    }

    private CertificateConstraints getCertificateConstraints(Context context, SubContext subContext) {
        BasicSignatureConstraints basicSignatureConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignatureConstraints != null) {
            if (SubContext.SIGNING_CERT.equals((Object)subContext)) {
                return basicSignatureConstraints.getSigningCertificate();
            }
            if (SubContext.CA_CERTIFICATE.equals((Object)subContext)) {
                return basicSignatureConstraints.getCACertificate();
            }
        }
        return null;
    }

    private BasicSignatureConstraints getBasicSignatureConstraintsByContext(Context context) {
        switch (context) {
            case SIGNATURE: 
            case CERTIFICATE: {
                SignatureConstraints mainSignature = this.getSignatureConstraints();
                if (mainSignature == null) break;
                return mainSignature.getBasicSignatureConstraints();
            }
            case COUNTER_SIGNATURE: {
                SignatureConstraints counterSignature = this.getCounterSignatureConstraints();
                if (counterSignature == null) break;
                return counterSignature.getBasicSignatureConstraints();
            }
            case TIMESTAMP: {
                TimestampConstraints timestampConstraints = this.getTimestampConstraints();
                if (timestampConstraints == null) break;
                return timestampConstraints.getBasicSignatureConstraints();
            }
            case REVOCATION: {
                RevocationConstraints revocationConstraints = this.getRevocationConstraints();
                if (revocationConstraints == null) break;
                return revocationConstraints.getBasicSignatureConstraints();
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported context '%s'", context));
            }
        }
        return null;
    }

    private SignedAttributesConstraints getSignedAttributeConstraints(Context context) {
        switch (context) {
            case SIGNATURE: 
            case CERTIFICATE: {
                SignatureConstraints mainSignature = this.getSignatureConstraints();
                if (mainSignature == null) break;
                return mainSignature.getSignedAttributes();
            }
            case COUNTER_SIGNATURE: {
                SignatureConstraints counterSignature = this.getCounterSignatureConstraints();
                if (counterSignature == null) break;
                return counterSignature.getSignedAttributes();
            }
            case TIMESTAMP: {
                TimestampConstraints timestampConstraints = this.getTimestampConstraints();
                if (timestampConstraints == null) break;
                return timestampConstraints.getSignedAttributes();
            }
            default: {
                LOG.warn("Unsupported context {}", (Object)context);
            }
        }
        return null;
    }

    private UnsignedAttributesConstraints getUnsignedAttributeConstraints(Context context) {
        switch (context) {
            case SIGNATURE: {
                SignatureConstraints mainSignature = this.getSignatureConstraints();
                if (mainSignature == null) break;
                return mainSignature.getUnsignedAttributes();
            }
            case COUNTER_SIGNATURE: {
                SignatureConstraints counterSignature = this.getCounterSignatureConstraints();
                if (counterSignature == null) break;
                return counterSignature.getUnsignedAttributes();
            }
            default: {
                LOG.warn("Unsupported context {}", (Object)context);
            }
        }
        return null;
    }

    private SignatureConstraints getSignatureConstraintsByContext(Context context) {
        switch (context) {
            case SIGNATURE: 
            case CERTIFICATE: {
                return this.getSignatureConstraints();
            }
            case COUNTER_SIGNATURE: {
                return this.getCounterSignatureConstraints();
            }
        }
        LOG.warn("Unsupported context {}", (Object)context);
        return null;
    }

    public MultiValuesRule getAcceptedContainerTypesConstraint() {
        ContainerConstraints containerConstraints = this.getContainerConstraints();
        if (containerConstraints != null) {
            return this.toRule(containerConstraints.getAcceptableContainerTypes());
        }
        return null;
    }

    public LevelRule getZipCommentPresentConstraint() {
        ContainerConstraints containerConstraints = this.getContainerConstraints();
        if (containerConstraints != null) {
            return this.toLevelRule(containerConstraints.getZipCommentPresent());
        }
        return null;
    }

    public MultiValuesRule getAcceptedZipCommentsConstraint() {
        ContainerConstraints containerConstraints = this.getContainerConstraints();
        if (containerConstraints != null) {
            return this.toRule(containerConstraints.getAcceptableZipComment());
        }
        return null;
    }

    public LevelRule getMimeTypeFilePresentConstraint() {
        ContainerConstraints containerConstraints = this.getContainerConstraints();
        if (containerConstraints != null) {
            return this.toLevelRule(containerConstraints.getMimeTypeFilePresent());
        }
        return null;
    }

    public MultiValuesRule getAcceptedMimeTypeContentsConstraint() {
        ContainerConstraints containerConstraints = this.getContainerConstraints();
        if (containerConstraints != null) {
            return this.toRule(containerConstraints.getAcceptableMimeTypeFileContent());
        }
        return null;
    }

    public LevelRule getManifestFilePresentConstraint() {
        ContainerConstraints containerConstraints = this.getContainerConstraints();
        if (containerConstraints != null) {
            return this.toLevelRule(containerConstraints.getManifestFilePresent());
        }
        return null;
    }

    public LevelRule getSignedFilesPresentConstraint() {
        ContainerConstraints containerConstraints = this.getContainerConstraints();
        if (containerConstraints != null) {
            return this.toLevelRule(containerConstraints.getSignedFilesPresent());
        }
        return null;
    }

    public LevelRule getFilenameAdherenceConstraint() {
        ContainerConstraints containerConstraints = this.getContainerConstraints();
        if (containerConstraints != null) {
            return this.toLevelRule(containerConstraints.getFilenameAdherence());
        }
        return null;
    }

    public LevelRule getAllFilesSignedConstraint() {
        ContainerConstraints containerConstraints = this.getContainerConstraints();
        if (containerConstraints != null) {
            return this.toLevelRule(containerConstraints.getAllFilesSigned());
        }
        return null;
    }

    public MultiValuesRule getAcceptablePDFAProfilesConstraint() {
        PDFAConstraints pdfaConstraints = this.getPDFAConstraints();
        if (pdfaConstraints != null) {
            return this.toRule(pdfaConstraints.getAcceptablePDFAProfiles());
        }
        return null;
    }

    public LevelRule getPDFACompliantConstraint() {
        PDFAConstraints pdfaConstraints = this.getPDFAConstraints();
        if (pdfaConstraints != null) {
            return this.toLevelRule(pdfaConstraints.getPDFACompliant());
        }
        return null;
    }

    public boolean isEIDASConstraintPresent() {
        return this.getEIDASConstraints() != null;
    }

    public DurationRule getTLFreshnessConstraint() {
        EIDAS eIDASConstraints = this.getEIDASConstraints();
        if (eIDASConstraints != null) {
            return this.toRule(eIDASConstraints.getTLFreshness());
        }
        return null;
    }

    public LevelRule getTLWellSignedConstraint() {
        EIDAS eIDASConstraints = this.getEIDASConstraints();
        if (eIDASConstraints != null) {
            return this.toLevelRule(eIDASConstraints.getTLWellSigned());
        }
        return null;
    }

    public LevelRule getTLNotExpiredConstraint() {
        EIDAS eIDASConstraints = this.getEIDASConstraints();
        if (eIDASConstraints != null) {
            return this.toLevelRule(eIDASConstraints.getTLNotExpired());
        }
        return null;
    }

    public MultiValuesRule getTLVersionConstraint() {
        EIDAS eIDASConstraints = this.getEIDASConstraints();
        if (eIDASConstraints != null) {
            return this.toRule(eIDASConstraints.getTLVersion());
        }
        return null;
    }

    public LevelRule getTLStructureConstraint() {
        EIDAS eIDASConstraints = this.getEIDASConstraints();
        if (eIDASConstraints != null) {
            return this.toLevelRule(eIDASConstraints.getTLStructure());
        }
        return null;
    }

    public ValidationModel getValidationModel() {
        ValidationModel currentModel = DEFAULT_VALIDATION_MODEL;
        ModelConstraint modelConstraint = this.policy.getModel();
        if (modelConstraint != null && modelConstraint.getValue() != null) {
            currentModel = modelConstraint.getValue();
        }
        return currentModel;
    }

    public SignatureConstraints getSignatureConstraints() {
        return this.policy.getSignatureConstraints();
    }

    public SignatureConstraints getCounterSignatureConstraints() {
        return this.policy.getCounterSignatureConstraints();
    }

    public TimestampConstraints getTimestampConstraints() {
        return this.policy.getTimestamp();
    }

    public RevocationConstraints getRevocationConstraints() {
        return this.policy.getRevocation();
    }

    public EvidenceRecordConstraints getEvidenceRecordConstraints() {
        return this.policy.getEvidenceRecord();
    }

    public ContainerConstraints getContainerConstraints() {
        return this.policy.getContainerConstraints();
    }

    public PDFAConstraints getPDFAConstraints() {
        return this.policy.getPDFAConstraints();
    }

    public EIDAS getEIDASConstraints() {
        return this.policy.getEIDAS();
    }

    public CryptographicConstraint getCryptographic() {
        return this.policy.getCryptographic();
    }

    private LevelConstraintWrapper toLevelRule(LevelConstraint constraint) {
        if (constraint == null) {
            return null;
        }
        return new LevelConstraintWrapper(constraint);
    }

    private MultiValuesConstraintWrapper toRule(MultiValuesConstraint constraint) {
        if (constraint == null) {
            return null;
        }
        return new MultiValuesConstraintWrapper(constraint);
    }

    private ValueConstraintWrapper toRule(ValueConstraint constraint) {
        if (constraint == null) {
            return null;
        }
        return new ValueConstraintWrapper(constraint);
    }

    private IntValueConstraintWrapper toRule(IntValueConstraint constraint) {
        if (constraint == null) {
            return null;
        }
        return new IntValueConstraintWrapper(constraint);
    }

    private TimeConstraintWrapper toRule(TimeConstraint constraint) {
        if (constraint == null) {
            return null;
        }
        return new TimeConstraintWrapper(constraint);
    }

    private CertificateValuesConstraintWrapper toRule(CertificateValuesConstraint constraint) {
        if (constraint == null) {
            return null;
        }
        return new CertificateValuesConstraintWrapper(constraint);
    }

    private CryptographicConstraintWrapper toCryptographicSuite(CryptographicConstraint constraint) {
        return new CryptographicConstraintWrapper(constraint);
    }

    public String toString() {
        return "EtsiValidationPolicy [policyName=" + this.getPolicyName() + ']';
    }
}

