/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pki.x509.revocation.ocsp;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.pki.exception.PKIException;
import eu.europa.esig.dss.pki.model.CertEntity;
import eu.europa.esig.dss.pki.model.CertEntityRepository;
import eu.europa.esig.dss.pki.model.CertEntityRevocation;
import eu.europa.esig.dss.spi.CertificateExtensionsUtils;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.utils.Utils;
import java.security.PrivateKey;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.BasicOCSPRespBuilder;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.OCSPRespBuilder;
import org.bouncycastle.cert.ocsp.Req;
import org.bouncycastle.cert.ocsp.RespID;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKIOCSPSource
implements OCSPSource {
    private static final long serialVersionUID = 346675613204623498L;
    private static final Logger LOG = LoggerFactory.getLogger(PKIOCSPSource.class);
    protected final CertEntityRepository certEntityRepository;
    private CertEntity ocspResponder;
    private Date producedAt;
    private Date thisUpdate;
    private Date nextUpdate;
    private DigestAlgorithm digestAlgorithm = DigestAlgorithm.SHA512;
    private EncryptionAlgorithm encryptionAlgorithm;
    private boolean responderIdByKey = true;

    public PKIOCSPSource(CertEntityRepository<? extends CertEntity> certEntityRepository) {
        Objects.requireNonNull(certEntityRepository, "Certificate repository shall be provided!");
        this.certEntityRepository = certEntityRepository;
    }

    public PKIOCSPSource(CertEntityRepository<? extends CertEntity> certEntityRepository, CertEntity ocspResponder) {
        this(certEntityRepository);
        this.ocspResponder = ocspResponder;
    }

    protected Date getProducedAtTime() {
        if (this.producedAt == null) {
            return new Date();
        }
        return this.producedAt;
    }

    public void setProducedAtTime(Date producedAt) {
        this.producedAt = producedAt;
        if (this.thisUpdate == null) {
            this.thisUpdate = producedAt;
        }
    }

    protected Date getThisUpdate() {
        if (this.thisUpdate == null) {
            return new Date();
        }
        return this.thisUpdate;
    }

    public void setThisUpdate(Date thisUpdate) {
        this.thisUpdate = thisUpdate;
    }

    protected Date getNextUpdate() {
        return this.nextUpdate;
    }

    public void setNextUpdate(Date nextUpdate) {
        this.nextUpdate = nextUpdate;
    }

    public void setDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public void setEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public void setResponderIdByKey(boolean responderIdByKey) {
        this.responderIdByKey = responderIdByKey;
    }

    protected CertEntity getOcspResponder(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        CertEntity currentOCSPResponder;
        if (this.ocspResponder != null) {
            currentOCSPResponder = this.ocspResponder;
        } else {
            currentOCSPResponder = this.certEntityRepository.getByCertificateToken(issuerCertificateToken);
            if (currentOCSPResponder == null) {
                throw new PKIException(String.format("CertEntity for certificate token with Id '%s' not found in the repository! Provide a valid issuer or use #setOcspResponder method to set a custom OCSP responder.", issuerCertificateToken.getDSSIdAsString()));
            }
        }
        return currentOCSPResponder;
    }

    public void setOcspResponder(CertEntity ocspResponder) {
        this.ocspResponder = ocspResponder;
    }

    public OCSPToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        Objects.requireNonNull(certificateToken, "Certificate cannot be null!");
        Objects.requireNonNull(issuerCertificateToken, "The issuer of the certificate to be verified cannot be null!");
        String dssIdAsString = certificateToken.getDSSIdAsString();
        LOG.trace("--> PKIOCSPSource queried for {}", (Object)dssIdAsString);
        if (!this.canGenerate(certificateToken, issuerCertificateToken)) {
            return null;
        }
        try {
            OCSPReq ocspReq = this.buildOCSPRequest(certificateToken, issuerCertificateToken);
            OCSPResp ocspRespBytes = this.buildOCSPResponse(certificateToken, issuerCertificateToken, ocspReq);
            BasicOCSPResp basicResponse = (BasicOCSPResp)ocspRespBytes.getResponseObject();
            SingleResp latestSingleResponse = DSSRevocationUtils.getLatestSingleResponse((BasicOCSPResp)basicResponse, (CertificateToken)certificateToken, (CertificateToken)issuerCertificateToken);
            OCSPToken ocspToken = new OCSPToken(basicResponse, latestSingleResponse, certificateToken, issuerCertificateToken);
            ocspToken.setExternalOrigin(RevocationOrigin.EXTERNAL);
            return ocspToken;
        }
        catch (OCSPException e) {
            throw new PKIException(String.format("Unable to build an OCSP response for certificate with Id '%s'. Reason : %s", certificateToken.getDSSIdAsString(), e.getMessage()), e);
        }
    }

    protected boolean canGenerate(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        List ocspAccessUrls = CertificateExtensionsUtils.getOCSPAccessUrls((CertificateToken)certificateToken);
        if (Utils.isCollectionEmpty((Collection)ocspAccessUrls)) {
            LOG.debug("No OCSP location found for {}", (Object)certificateToken.getDSSIdAsString());
            return false;
        }
        return true;
    }

    protected OCSPResp buildOCSPResponse(CertificateToken certificateToken, CertificateToken issuerCertificateToken, OCSPReq ocspReq) {
        try {
            CertEntity ocspResponderEntity = this.getOcspResponder(certificateToken, issuerCertificateToken);
            BasicOCSPRespBuilder builder = this.initBuilder(ocspResponderEntity.getCertificateToken());
            CertEntityRevocation certRevocation = this.getCertificateTokenRevocation(certificateToken, ocspReq);
            this.addRevocationStatusToOCSPResponse(builder, ocspReq, certRevocation);
            SignatureAlgorithm signatureAlgorithm = this.getSignatureAlgorithm(ocspResponderEntity);
            PrivateKey ocspPrivateKey = ocspResponderEntity.getPrivateKey();
            ContentSigner signer = new JcaContentSignerBuilder(signatureAlgorithm.getJCEId()).build(ocspPrivateKey);
            X509CertificateHolder[] x509CertificateHolders = (X509CertificateHolder[])ocspResponderEntity.getCertificateChain().stream().map(DSSASN1Utils::getX509CertificateHolder).toArray(X509CertificateHolder[]::new);
            Date producedAtTime = this.getProducedAtTime();
            BasicOCSPResp basicOCSPResp = builder.build(signer, x509CertificateHolders, producedAtTime);
            OCSPRespBuilder respBuilder = new OCSPRespBuilder();
            return respBuilder.build(0, (Object)basicOCSPResp);
        }
        catch (OCSPException | OperatorCreationException e) {
            throw new PKIException(String.format("Unable to generate the OCSP Response. Reason: %s", e.getMessage()), e);
        }
    }

    protected CertEntityRevocation getCertificateTokenRevocation(CertificateToken certificateToken, OCSPReq ocspReq) {
        Object certEntity = this.certEntityRepository.getByCertificateToken(certificateToken);
        if (certEntity == null) {
            throw new PKIException(String.format("CertEntity for certificate token with Id '%s' not found in the repository!", certificateToken.getDSSIdAsString()));
        }
        return this.certEntityRepository.getRevocation(certEntity);
    }

    protected void addRevocationStatusToOCSPResponse(BasicOCSPRespBuilder builder, OCSPReq ocspReq, CertEntityRevocation certEntityRevocation) {
        Objects.requireNonNull(ocspReq, "OCSPReq cannot be null!");
        if (Utils.isArrayEmpty((Object[])ocspReq.getRequestList())) {
            throw new IllegalStateException("OCSPReq list cannot be empty!");
        }
        Req r = ocspReq.getRequestList()[0];
        if (certEntityRevocation == null || certEntityRevocation.getRevocationDate() == null) {
            builder.addResponse(r.getCertID(), CertificateStatus.GOOD, this.getThisUpdate(), this.getNextUpdate());
        } else {
            RevokedStatus status = new RevokedStatus(certEntityRevocation.getRevocationDate(), certEntityRevocation.getRevocationReason().getValue());
            builder.addResponse(r.getCertID(), (CertificateStatus)status, this.getThisUpdate(), this.getNextUpdate());
        }
    }

    protected SignatureAlgorithm getSignatureAlgorithm(CertEntity ocspResponder) {
        EncryptionAlgorithm currentEncryptionAlgorithm = this.encryptionAlgorithm;
        if (currentEncryptionAlgorithm != null) {
            if (!currentEncryptionAlgorithm.isEquivalent(ocspResponder.getEncryptionAlgorithm())) {
                throw new IllegalArgumentException(String.format("Defined EncryptionAlgorithm '%s' is not equivalent to the one returned by OCSP Issuer '%s'", currentEncryptionAlgorithm, ocspResponder.getEncryptionAlgorithm()));
            }
        } else {
            currentEncryptionAlgorithm = ocspResponder.getEncryptionAlgorithm();
        }
        return SignatureAlgorithm.getAlgorithm((EncryptionAlgorithm)currentEncryptionAlgorithm, (DigestAlgorithm)this.digestAlgorithm);
    }

    protected BasicOCSPRespBuilder initBuilder(CertificateToken ocspResponderCertificate) throws OperatorCreationException, OCSPException {
        RespID respID = this.getRespID(ocspResponderCertificate);
        return new BasicOCSPRespBuilder(respID);
    }

    protected RespID getRespID(CertificateToken ocspResponderCertificate) throws OperatorCreationException, OCSPException {
        X509CertificateHolder x509CertificateHolder = DSSASN1Utils.getX509CertificateHolder((CertificateToken)ocspResponderCertificate);
        if (this.responderIdByKey) {
            SubjectPublicKeyInfo info = x509CertificateHolder.getSubjectPublicKeyInfo();
            DigestCalculator digestCalculator = new BcDigestCalculatorProvider().get(DSSASN1Utils.getAlgorithmIdentifier((DigestAlgorithm)DigestAlgorithm.SHA1));
            return new RespID(info, digestCalculator);
        }
        X500Name x500CertificateName = x509CertificateHolder.getSubject();
        return new RespID(x500CertificateName);
    }

    protected OCSPReq buildOCSPRequest(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        try {
            OCSPReqBuilder ocspReqBuilder = new OCSPReqBuilder();
            CertificateID certId = DSSRevocationUtils.getOCSPCertificateID((CertificateToken)certificateToken, (CertificateToken)issuerCertificateToken, (DigestAlgorithm)this.digestAlgorithm);
            ocspReqBuilder.addRequest(certId);
            return ocspReqBuilder.build();
        }
        catch (OCSPException e) {
            throw new PKIException("Cannot build OCSP Request", e);
        }
    }
}

