/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pki.x509.revocation.ocsp;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.pki.exception.PKIException;
import eu.europa.esig.dss.pki.model.CertEntity;
import eu.europa.esig.dss.pki.model.CertEntityRepository;
import eu.europa.esig.dss.pki.x509.revocation.ocsp.PKIOCSPSource;
import eu.europa.esig.dss.utils.Utils;
import java.util.Map;

public class PKIDelegatedOCSPSource
extends PKIOCSPSource {
    private static final long serialVersionUID = 1812419786179539363L;
    private Map<CertEntity, CertEntity> ocspResponders;

    public PKIDelegatedOCSPSource(CertEntityRepository certEntityRepository) {
        super(certEntityRepository);
    }

    public void setOcspResponders(Map<CertEntity, CertEntity> ocspResponders) {
        this.ocspResponders = ocspResponders;
    }

    @Override
    public void setOcspResponder(CertEntity ocspResponder) {
        throw new UnsupportedOperationException("Method #setOcspResponder is not supported within PKIDelegatedOCSPSource class. Use #setOcspResponders method instead.");
    }

    @Override
    protected CertEntity getOcspResponder(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        CertEntity ocspResponder;
        Object issuerCertEntity = this.certEntityRepository.getByCertificateToken(issuerCertificateToken);
        if (issuerCertEntity == null) {
            throw new PKIException(String.format("CertEntity for certificate token with Id '%s' not found in the repository! Provide a valid issuer.", issuerCertificateToken.getDSSIdAsString()));
        }
        if (Utils.isMapNotEmpty(this.ocspResponders) && (ocspResponder = this.ocspResponders.get(issuerCertEntity)) != null) {
            return ocspResponder;
        }
        return issuerCertEntity;
    }
}

