/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pki.x509.revocation.crl;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.crl.CRLValidity;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.pki.exception.PKIException;
import eu.europa.esig.dss.pki.model.CertEntity;
import eu.europa.esig.dss.pki.model.CertEntityRepository;
import eu.europa.esig.dss.pki.model.CertEntityRevocation;
import eu.europa.esig.dss.spi.CertificateExtensionsUtils;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLSource;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v2CRLBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKICRLSource
implements CRLSource {
    private static final long serialVersionUID = 6912729291417315212L;
    private static final Logger LOG = LoggerFactory.getLogger(PKICRLSource.class);
    private final CertEntityRepository certEntityRepository;
    private CertEntity crlIssuer;
    private Date thisUpdate;
    private Date nextUpdate;
    private DigestAlgorithm digestAlgorithm = DigestAlgorithm.SHA512;
    private EncryptionAlgorithm encryptionAlgorithm;

    public PKICRLSource(CertEntityRepository<? extends CertEntity> certEntityRepository) {
        Objects.requireNonNull(certEntityRepository, "Certificate repository shall be provided!");
        this.certEntityRepository = certEntityRepository;
    }

    public PKICRLSource(CertEntityRepository<? extends CertEntity> certEntityRepository, CertEntity crlIssuer) {
        this(certEntityRepository);
        this.crlIssuer = crlIssuer;
    }

    public Date getNextUpdate() {
        return this.nextUpdate;
    }

    public void setNextUpdate(Date nextUpdate) {
        this.nextUpdate = nextUpdate;
    }

    protected Date getThisUpdate() {
        if (this.thisUpdate == null) {
            return new Date();
        }
        return this.thisUpdate;
    }

    public void setThisUpdate(Date thisUpdate) {
        this.thisUpdate = thisUpdate;
    }

    public void setDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public void setEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    protected CertEntity getCrlIssuer(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        CertEntity currentCRLIssuer;
        if (this.crlIssuer != null) {
            currentCRLIssuer = this.crlIssuer;
        } else {
            currentCRLIssuer = this.certEntityRepository.getByCertificateToken(issuerCertificateToken);
            if (currentCRLIssuer == null) {
                throw new PKIException(String.format("CertEntity for certificate token with Id '%s' not found in the repository! Provide a valid issuer or use #setCrlIssuer method to set a custom issuer.", issuerCertificateToken.getDSSIdAsString()));
            }
        }
        return currentCRLIssuer;
    }

    public void setCrlIssuer(CertEntity crlIssuer) {
        this.crlIssuer = crlIssuer;
    }

    public CRLToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        Objects.requireNonNull(certificateToken, "Certificate cannot be null!");
        Objects.requireNonNull(issuerCertificateToken, "The issuer of the certificate to be verified cannot be null!");
        String dssIdAsString = certificateToken.getDSSIdAsString();
        LOG.trace("--> PKICRLSource queried for {}", (Object)dssIdAsString);
        if (!this.canGenerate(certificateToken, issuerCertificateToken)) {
            return null;
        }
        CertEntity currentCRLIssuer = this.getCrlIssuer(certificateToken, issuerCertificateToken);
        try {
            CRLBinary crlBinary = this.generateCRL(currentCRLIssuer);
            CRLValidity crlValidity = CRLUtils.buildCRLValidity((CRLBinary)crlBinary, (CertificateToken)issuerCertificateToken);
            CRLToken crlToken = new CRLToken(certificateToken, crlValidity);
            crlToken.setExternalOrigin(RevocationOrigin.EXTERNAL);
            return crlToken;
        }
        catch (Exception e) {
            throw new PKIException(String.format("Unable to build a CRL for certificate with Id '%s'. Reason : %s", certificateToken.getDSSIdAsString(), e.getMessage()), e);
        }
    }

    protected boolean canGenerate(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        List crlAccessUrls = CertificateExtensionsUtils.getCRLAccessUrls((CertificateToken)certificateToken);
        if (Utils.isCollectionEmpty((Collection)crlAccessUrls)) {
            LOG.debug("No CRL location found for {}", (Object)certificateToken.getDSSIdAsString());
            return false;
        }
        return true;
    }

    protected CRLBinary generateCRL(CertEntity crlIssuer) throws IOException, OperatorCreationException {
        X509CertificateHolder caCert = DSSASN1Utils.getX509CertificateHolder((CertificateToken)crlIssuer.getCertificateToken());
        Map<CertEntity, CertEntityRevocation> revocationList = this.certEntityRepository.getRevocationList(crlIssuer);
        SignatureAlgorithm signatureAlgorithm = this.getSignatureAlgorithm(crlIssuer);
        Date thisUpdateTime = this.getThisUpdate();
        X509v2CRLBuilder builder = new X509v2CRLBuilder(caCert.getSubject(), thisUpdateTime);
        Date nextUpdateTime = this.getNextUpdate();
        if (nextUpdateTime != null) {
            builder.setNextUpdate(nextUpdateTime);
        }
        this.addRevocationsToCRL(builder, revocationList);
        ContentSigner signer = new JcaContentSignerBuilder(signatureAlgorithm.getJCEId()).build(crlIssuer.getPrivateKey());
        X509CRLHolder crl = builder.build(signer);
        return new CRLBinary(crl.getEncoded());
    }

    protected SignatureAlgorithm getSignatureAlgorithm(CertEntity crlIssuer) {
        EncryptionAlgorithm signatureEncryptionAlgorithm = this.encryptionAlgorithm;
        if (signatureEncryptionAlgorithm != null) {
            if (!signatureEncryptionAlgorithm.isEquivalent(crlIssuer.getEncryptionAlgorithm())) {
                throw new IllegalArgumentException(String.format("Defined EncryptionAlgorithm '%s' is not equivalent to the one returned by CRL Issuer '%s'", signatureEncryptionAlgorithm, crlIssuer.getEncryptionAlgorithm()));
            }
        } else {
            signatureEncryptionAlgorithm = crlIssuer.getEncryptionAlgorithm();
        }
        return SignatureAlgorithm.getAlgorithm((EncryptionAlgorithm)signatureEncryptionAlgorithm, (DigestAlgorithm)this.digestAlgorithm);
    }

    protected void addRevocationsToCRL(X509v2CRLBuilder builder, Map<CertEntity, CertEntityRevocation> revocationList) {
        if (Utils.isMapNotEmpty(revocationList)) {
            revocationList.forEach((key, value) -> {
                X509CertificateHolder entry = DSSASN1Utils.getX509CertificateHolder((CertificateToken)key.getCertificateToken());
                builder.addCRLEntry(entry.getSerialNumber(), value.getRevocationDate(), value.getRevocationReason().getValue());
            });
        }
    }
}

