/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pki.x509.aia;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.pki.exception.PKIException;
import eu.europa.esig.dss.pki.model.CertEntity;
import eu.europa.esig.dss.pki.model.CertEntityRepository;
import eu.europa.esig.dss.spi.CertificateExtensionsUtils;
import eu.europa.esig.dss.spi.x509.aia.AIASource;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKIAIASource
implements AIASource {
    private static final long serialVersionUID = 6081957919058132853L;
    private static final Logger LOG = LoggerFactory.getLogger(PKIAIASource.class);
    private final CertEntityRepository certEntityRepository;
    private boolean completeCertificateChain = true;

    public PKIAIASource(CertEntityRepository<? extends CertEntity> certEntityRepository) {
        Objects.requireNonNull(certEntityRepository, "Certificate repository shall be provided!");
        this.certEntityRepository = certEntityRepository;
    }

    public void setCompleteCertificateChain(boolean completeCertificateChain) {
        this.completeCertificateChain = completeCertificateChain;
    }

    public Set<CertificateToken> getCertificatesByAIA(CertificateToken certificateToken) {
        Objects.requireNonNull(certificateToken, "Certificate Token parameter is not provided!");
        if (!this.canGenerate(certificateToken)) {
            return new HashSet<CertificateToken>();
        }
        if (this.completeCertificateChain) {
            List<CertificateToken> certificateChain = this.getCertificateChain(certificateToken);
            if (Utils.isCollectionNotEmpty(certificateChain)) {
                return new HashSet<CertificateToken>(certificateChain);
            }
        } else {
            CertificateToken certificateIssuer = this.getCertificateIssuer(certificateToken);
            if (certificateIssuer != null) {
                return new HashSet<CertificateToken>(Collections.singleton(certificateIssuer));
            }
        }
        return new HashSet<CertificateToken>();
    }

    protected boolean canGenerate(CertificateToken certificateToken) {
        List caIssuersAccessUrls = CertificateExtensionsUtils.getCAIssuersAccessUrls((CertificateToken)certificateToken);
        if (Utils.isCollectionEmpty((Collection)caIssuersAccessUrls)) {
            LOG.debug("No AIA.caIssuers location found for {}", (Object)certificateToken.getDSSIdAsString());
            return false;
        }
        return true;
    }

    protected List<CertificateToken> getCertificateChain(CertificateToken certificateToken) {
        CertEntity certEntity = this.getCertEntity(certificateToken);
        ArrayList<CertificateToken> certificateChain = new ArrayList<CertificateToken>(certEntity.getCertificateChain());
        certificateChain.remove(certificateToken);
        return certificateChain;
    }

    protected CertificateToken getCertificateIssuer(CertificateToken certificateToken) {
        CertEntity certEntity = this.getCertEntity(certificateToken);
        CertEntity issuerCertEntity = this.certEntityRepository.getIssuer(certEntity);
        if (issuerCertEntity != null) {
            return issuerCertEntity.getCertificateToken();
        }
        return null;
    }

    protected CertEntity getCertEntity(CertificateToken certificateToken) {
        Object certEntity = this.certEntityRepository.getByCertificateToken(certificateToken);
        if (certEntity == null) {
            throw new PKIException(String.format("CertEntity for certificate token with Id '%s' not found in the repository!", certificateToken.getDSSIdAsString()));
        }
        return certEntity;
    }
}

