/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model.signature;

import java.io.Serializable;
import java.util.List;

public class SignatureCryptographicVerification
implements Serializable {
    private static final long serialVersionUID = -7343772251223888821L;
    private final StringBuilder errorMessageBuilder = new StringBuilder();
    private boolean referenceDataFound;
    private boolean referenceDataIntact;
    private boolean signatureIntact;

    public boolean isReferenceDataFound() {
        return this.referenceDataFound;
    }

    public void setReferenceDataFound(boolean referenceDataFound) {
        this.referenceDataFound = referenceDataFound;
    }

    public boolean isReferenceDataIntact() {
        return this.referenceDataIntact;
    }

    public void setReferenceDataIntact(boolean referenceDataIntact) {
        this.referenceDataIntact = referenceDataIntact;
    }

    public boolean isSignatureIntact() {
        return this.signatureIntact;
    }

    public void setSignatureIntact(boolean signatureIntact) {
        this.signatureIntact = signatureIntact;
    }

    public boolean isSignatureValid() {
        return this.referenceDataFound && this.signatureIntact && this.referenceDataIntact;
    }

    public String getErrorMessage() {
        return this.errorMessageBuilder.toString();
    }

    public void setErrorMessage(String errorMessage) {
        if (this.errorMessageBuilder.length() != 0) {
            this.errorMessageBuilder.append("<br/>\n");
        }
        this.errorMessageBuilder.append(errorMessage);
    }

    public void setErrorMessages(List<String> errorMessages) {
        if (errorMessages != null && !errorMessages.isEmpty()) {
            for (String errorMessage : errorMessages) {
                this.setErrorMessage(errorMessage);
            }
        }
    }

    public String toString() {
        return "referenceDataFound:" + this.referenceDataFound + ", referenceDataIntact:" + this.referenceDataIntact + ", signatureValid;" + this.signatureIntact + " / " + this.errorMessageBuilder.toString();
    }
}

