/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;

public abstract class CommonDocument
implements DSSDocument {
    protected EnumMap<DigestAlgorithm, byte[]> digestMap = new DigestAlgorithmMap();
    protected MimeType mimeType;
    protected String name;

    protected CommonDocument() {
    }

    @Override
    public void save(String path) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(path);){
            this.writeTo(fos);
        }
    }

    @Override
    public void writeTo(OutputStream stream) throws IOException {
        byte[] buffer = new byte[8192];
        int count = -1;
        try (InputStream inStream = this.openStream();){
            while ((count = inStream.read(buffer)) > 0) {
                stream.write(buffer, 0, count);
            }
        }
    }

    @Override
    public MimeType getMimeType() {
        return this.mimeType;
    }

    @Override
    public void setMimeType(MimeType mimeType) {
        this.mimeType = mimeType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Digest getDigest(DigestAlgorithm digestAlgorithm) {
        byte[] digestBytes = this.getDigestValue(digestAlgorithm);
        return new Digest(digestAlgorithm, digestBytes);
    }

    @Override
    public byte[] getDigestValue(DigestAlgorithm digestAlgorithm) {
        byte[] digest = this.digestMap.get(digestAlgorithm);
        if (digest == null) {
            try (InputStream is = this.openStream();){
                int count;
                MessageDigest messageDigest = digestAlgorithm.getMessageDigest();
                byte[] buffer = new byte[8192];
                while ((count = is.read(buffer)) > 0) {
                    messageDigest.update(buffer, 0, count);
                }
                digest = messageDigest.digest();
                this.digestMap.put(digestAlgorithm, digest);
            }
            catch (IOException | NoSuchAlgorithmException e) {
                throw new DSSException("Unable to compute the digest", e);
            }
        }
        return digest;
    }

    public String toString() {
        String mimeTypeString = this.mimeType == null ? "" : this.mimeType.getMimeTypeString();
        return "Name: " + this.name + " / MimeType: " + mimeTypeString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommonDocument that = (CommonDocument)o;
        return Objects.equals(this.mimeType, that.mimeType) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.mimeType);
        result = 31 * result + Objects.hashCode(this.name);
        return result;
    }

    private static final class DigestAlgorithmMap
    extends EnumMap<DigestAlgorithm, byte[]> {
        public DigestAlgorithmMap() {
            super(DigestAlgorithm.class);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof DigestAlgorithmMap) {
                return this.equals((DigestAlgorithmMap)o);
            }
            return false;
        }

        private boolean equals(DigestAlgorithmMap o) {
            if (this.size() != o.size()) {
                return false;
            }
            for (Map.Entry entry : this.entrySet()) {
                DigestAlgorithm digestAlgorithm = (DigestAlgorithm)entry.getKey();
                byte[] thisValue = (byte[])entry.getValue();
                byte[] oValue = (byte[])o.get(digestAlgorithm);
                if (Arrays.equals(oValue, thisValue)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Map.Entry<DigestAlgorithm, byte[]> entry : this.entrySet()) {
                if (null == entry) continue;
                h += this.entryHashCode(entry);
            }
            return h;
        }

        private int entryHashCode(Map.Entry<DigestAlgorithm, byte[]> entry) {
            return entry.getKey().hashCode() ^ Arrays.hashCode(entry.getValue());
        }
    }
}

