/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.MaskGenerationFunction;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.model.BLevelParameters;
import eu.europa.esig.dss.model.SerializableSignatureParameters;
import eu.europa.esig.dss.model.SerializableTimestampParameters;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSerializableSignatureParameters<TP extends SerializableTimestampParameters>
implements SerializableSignatureParameters {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSerializableSignatureParameters.class);
    @Deprecated
    private boolean signWithExpiredCertificate = false;
    @Deprecated
    private boolean signWithNotYetValidCertificate = false;
    private boolean checkCertificateRevocation = false;
    private boolean generateTBSWithoutCertificate = false;
    private SignatureLevel signatureLevel;
    private SignaturePackaging signaturePackaging;
    private SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.RSA_SSA_PSS_SHA512_MGF1;
    private EncryptionAlgorithm encryptionAlgorithm = this.signatureAlgorithm.getEncryptionAlgorithm();
    private DigestAlgorithm digestAlgorithm = this.signatureAlgorithm.getDigestAlgorithm();
    private DigestAlgorithm referenceDigestAlgorithm;
    private BLevelParameters bLevelParams = new BLevelParameters();
    protected TP contentTimestampParameters;
    protected TP signatureTimestampParameters;
    protected TP archiveTimestampParameters;

    protected AbstractSerializableSignatureParameters() {
    }

    @Override
    @Deprecated
    public boolean isSignWithExpiredCertificate() {
        return this.signWithExpiredCertificate;
    }

    @Deprecated
    public void setSignWithExpiredCertificate(boolean signWithExpiredCertificate) {
        this.signWithExpiredCertificate = signWithExpiredCertificate;
    }

    @Override
    @Deprecated
    public boolean isSignWithNotYetValidCertificate() {
        return this.signWithNotYetValidCertificate;
    }

    @Deprecated
    public void setSignWithNotYetValidCertificate(boolean signWithNotYetValidCertificate) {
        this.signWithNotYetValidCertificate = signWithNotYetValidCertificate;
    }

    @Override
    public boolean isCheckCertificateRevocation() {
        return this.checkCertificateRevocation;
    }

    public void setCheckCertificateRevocation(boolean checkCertificateRevocation) {
        this.checkCertificateRevocation = checkCertificateRevocation;
    }

    @Override
    public boolean isGenerateTBSWithoutCertificate() {
        return this.generateTBSWithoutCertificate;
    }

    public void setGenerateTBSWithoutCertificate(boolean generateTBSWithoutCertificate) {
        this.generateTBSWithoutCertificate = generateTBSWithoutCertificate;
    }

    public SignatureLevel getSignatureLevel() {
        return this.signatureLevel;
    }

    public void setSignatureLevel(SignatureLevel signatureLevel) {
        Objects.requireNonNull(signatureLevel, "Signature Level cannot be null");
        this.signatureLevel = signatureLevel;
    }

    public SignaturePackaging getSignaturePackaging() {
        return this.signaturePackaging;
    }

    public void setSignaturePackaging(SignaturePackaging signaturePackaging) {
        this.signaturePackaging = signaturePackaging;
    }

    @Override
    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        Objects.requireNonNull(digestAlgorithm, "DigestAlgorithm cannot be null!");
        this.digestAlgorithm = digestAlgorithm;
        if (this.encryptionAlgorithm != null) {
            this.signatureAlgorithm = SignatureAlgorithm.getAlgorithm((EncryptionAlgorithm)this.encryptionAlgorithm, (DigestAlgorithm)this.digestAlgorithm);
        }
    }

    @Deprecated
    public void setMaskGenerationFunction(MaskGenerationFunction maskGenerationFunction) {
        LOG.warn("Use of deprecated method #setMaskGenerationFunction! Please use #setEncryptionAlgorithm with EncryptionAlgorithm.RSASSA_PSS value to enable MGF1, or EncryptionAlgorithm.RSA to disable.");
        if (MaskGenerationFunction.MGF1 == maskGenerationFunction && EncryptionAlgorithm.RSA == this.encryptionAlgorithm) {
            LOG.info("MaskGenerationFunction '{}' has been provided. The EncryptionAlgorithm changed to '{}'.", (Object)maskGenerationFunction, (Object)EncryptionAlgorithm.RSASSA_PSS);
            this.setEncryptionAlgorithm(EncryptionAlgorithm.RSASSA_PSS);
        } else if (maskGenerationFunction == null && EncryptionAlgorithm.RSASSA_PSS == this.encryptionAlgorithm) {
            LOG.info("MaskGenerationFunction '{}' has been provided. The EncryptionAlgorithm changed to '{}'.", (Object)maskGenerationFunction, (Object)EncryptionAlgorithm.RSA);
            this.setEncryptionAlgorithm(EncryptionAlgorithm.RSA);
        } else if (!EncryptionAlgorithm.RSA.isEquivalent(this.encryptionAlgorithm)) {
            LOG.info("Not allowed combination of MaskGenerationFunction '{}' and EncryptionAlgorithm '{}'. The value is skipped.", (Object)maskGenerationFunction, (Object)this.encryptionAlgorithm);
        }
    }

    @Override
    @Deprecated
    public MaskGenerationFunction getMaskGenerationFunction() {
        if (EncryptionAlgorithm.RSASSA_PSS == this.encryptionAlgorithm) {
            return MaskGenerationFunction.MGF1;
        }
        return null;
    }

    @Override
    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        if (this.digestAlgorithm != null) {
            this.signatureAlgorithm = SignatureAlgorithm.getAlgorithm((EncryptionAlgorithm)this.encryptionAlgorithm, (DigestAlgorithm)this.digestAlgorithm);
        }
    }

    @Override
    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public DigestAlgorithm getReferenceDigestAlgorithm() {
        return this.referenceDigestAlgorithm;
    }

    public void setReferenceDigestAlgorithm(DigestAlgorithm referenceDigestAlgorithm) {
        this.referenceDigestAlgorithm = referenceDigestAlgorithm;
    }

    @Override
    public BLevelParameters bLevel() {
        return this.bLevelParams;
    }

    public void setBLevelParams(BLevelParameters bLevelParams) {
        Objects.requireNonNull(bLevelParams, "bLevelParams cannot be null!");
        this.bLevelParams = bLevelParams;
    }

    public TP getContentTimestampParameters() {
        throw new UnsupportedOperationException("Cannot extract ContentTimestampParameters! Not implemented by default.");
    }

    public void setContentTimestampParameters(TP contentTimestampParameters) {
        this.contentTimestampParameters = contentTimestampParameters;
    }

    public TP getSignatureTimestampParameters() {
        throw new UnsupportedOperationException("Cannot extract SignatureTimestampParameters! Not implemented by default.");
    }

    public void setSignatureTimestampParameters(TP signatureTimestampParameters) {
        this.signatureTimestampParameters = signatureTimestampParameters;
    }

    public TP getArchiveTimestampParameters() {
        throw new UnsupportedOperationException("Cannot extract ArchiveTimestampParameters! Not implemented by default.");
    }

    public void setArchiveTimestampParameters(TP archiveTimestampParameters) {
        this.archiveTimestampParameters = archiveTimestampParameters;
    }

    public String toString() {
        return "AbstractSerializableSignatureParameters [signWithExpiredCertificate=" + this.signWithExpiredCertificate + ", signWithNotYetValidCertificate=" + this.signWithNotYetValidCertificate + ", checkCertificateRevocation=" + this.checkCertificateRevocation + ", generateTBSWithoutCertificate=" + this.generateTBSWithoutCertificate + ", signatureLevel=" + this.signatureLevel + ", signaturePackaging=" + this.signaturePackaging + ", signatureAlgorithm=" + this.signatureAlgorithm + ", encryptionAlgorithm=" + this.encryptionAlgorithm + ", digestAlgorithm=" + this.digestAlgorithm + ", referenceDigestAlgorithm=" + this.referenceDigestAlgorithm + ", bLevelParams=" + this.bLevelParams + ", contentTimestampParameters=" + this.contentTimestampParameters + ", signatureTimestampParameters=" + this.signatureTimestampParameters + ", archiveTimestampParameters=" + this.archiveTimestampParameters + ']';
    }

    public int hashCode() {
        int result = Boolean.hashCode(this.signWithExpiredCertificate);
        result = 31 * result + Boolean.hashCode(this.signWithNotYetValidCertificate);
        result = 31 * result + Boolean.hashCode(this.checkCertificateRevocation);
        result = 31 * result + Boolean.hashCode(this.generateTBSWithoutCertificate);
        result = 31 * result + Objects.hashCode(this.signatureLevel);
        result = 31 * result + Objects.hashCode(this.signaturePackaging);
        result = 31 * result + Objects.hashCode(this.signatureAlgorithm);
        result = 31 * result + Objects.hashCode(this.encryptionAlgorithm);
        result = 31 * result + Objects.hashCode(this.digestAlgorithm);
        result = 31 * result + Objects.hashCode(this.referenceDigestAlgorithm);
        result = 31 * result + Objects.hashCode(this.bLevelParams);
        result = 31 * result + Objects.hashCode(this.contentTimestampParameters);
        result = 31 * result + Objects.hashCode(this.signatureTimestampParameters);
        result = 31 * result + Objects.hashCode(this.archiveTimestampParameters);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractSerializableSignatureParameters that = (AbstractSerializableSignatureParameters)o;
        return this.signWithExpiredCertificate == that.signWithExpiredCertificate && this.signWithNotYetValidCertificate == that.signWithNotYetValidCertificate && this.checkCertificateRevocation == that.checkCertificateRevocation && this.generateTBSWithoutCertificate == that.generateTBSWithoutCertificate && this.signatureLevel == that.signatureLevel && this.signaturePackaging == that.signaturePackaging && this.signatureAlgorithm == that.signatureAlgorithm && this.encryptionAlgorithm == that.encryptionAlgorithm && this.digestAlgorithm == that.digestAlgorithm && this.referenceDigestAlgorithm == that.referenceDigestAlgorithm && Objects.equals(this.bLevelParams, that.bLevelParams) && Objects.equals(this.contentTimestampParameters, that.contentTimestampParameters) && Objects.equals(this.signatureTimestampParameters, that.signatureTimestampParameters) && Objects.equals(this.archiveTimestampParameters, that.archiveTimestampParameters);
    }
}

