/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Locale;

public final class Digest
implements Serializable {
    private DigestAlgorithm algorithm;
    private byte[] value;

    public Digest() {
    }

    public Digest(DigestAlgorithm algorithm, byte[] value) {
        this.algorithm = algorithm;
        this.value = value;
    }

    public String getHexValue() {
        String hex = new BigInteger(1, this.value).toString(16);
        if (hex.length() % 2 == 1) {
            hex = "0" + hex;
        }
        return hex.toUpperCase(Locale.ENGLISH);
    }

    public DigestAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(DigestAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.algorithm == null ? 0 : this.algorithm.hashCode());
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Digest other = (Digest)obj;
        if (this.algorithm != other.algorithm) {
            return false;
        }
        return Arrays.equals(this.value, other.value);
    }

    public String toString() {
        return (this.algorithm == null ? "?" : this.algorithm.getName()) + ":" + (this.value == null ? "?" : this.getHexValue());
    }
}

