/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.MimeType;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.EnumMap;

public abstract class CommonDocument
implements DSSDocument {
    protected EnumMap<DigestAlgorithm, String> base64EncodeDigestMap = new EnumMap(DigestAlgorithm.class);
    protected MimeType mimeType;
    protected String name;

    protected CommonDocument() {
    }

    @Override
    public void save(String path) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(path);){
            this.writeTo(fos);
        }
    }

    @Override
    public void writeTo(OutputStream stream) throws IOException {
        byte[] buffer = new byte[1024];
        int count = -1;
        try (InputStream inStream = this.openStream();){
            while ((count = inStream.read(buffer)) > 0) {
                stream.write(buffer, 0, count);
            }
        }
    }

    @Override
    public MimeType getMimeType() {
        return this.mimeType;
    }

    @Override
    public void setMimeType(MimeType mimeType) {
        this.mimeType = mimeType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDigest(DigestAlgorithm digestAlgorithm) {
        String base64EncodeDigest = this.base64EncodeDigestMap.get(digestAlgorithm);
        if (base64EncodeDigest == null) {
            try (InputStream is = this.openStream();){
                MessageDigest messageDigest = digestAlgorithm.getMessageDigest();
                byte[] buffer = new byte[4096];
                int count = 0;
                while ((count = is.read(buffer)) > 0) {
                    messageDigest.update(buffer, 0, count);
                }
                byte[] digestBytes = messageDigest.digest();
                base64EncodeDigest = Base64.getEncoder().encodeToString(digestBytes);
                this.base64EncodeDigestMap.put(digestAlgorithm, base64EncodeDigest);
            }
            catch (IOException | NoSuchAlgorithmException e) {
                throw new DSSException("Unable to compute the digest", e);
            }
        }
        return base64EncodeDigest;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.append("Name: ").append(this.getName()).append(" / MimeType: ").append(this.mimeType == null ? "" : this.mimeType.getMimeTypeString());
        return stringWriter.toString();
    }
}

