/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.json;

import com.github.erosb.jsonsKema.JsonArray;
import com.github.erosb.jsonsKema.JsonNumber;
import com.github.erosb.jsonsKema.JsonObject;
import com.github.erosb.jsonsKema.JsonString;
import com.github.erosb.jsonsKema.JsonValue;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonObjectWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(JsonObjectWrapper.class);
    private final JsonObject jsonObject;

    public JsonObjectWrapper(JsonObject jsonObject) {
        Objects.requireNonNull(jsonObject, "JSON object cannot be null!");
        this.jsonObject = jsonObject;
    }

    public JsonObjectWrapper getAsObject(String name) {
        JsonValue jsonValue = this.jsonObject.get(name);
        return this.toObject(jsonValue);
    }

    private JsonObjectWrapper toObject(JsonValue jsonValue) {
        if (jsonValue != null) {
            if (jsonValue instanceof JsonObject) {
                return new JsonObjectWrapper((JsonObject)jsonValue);
            }
            if (LOG.isDebugEnabled()) {
                LOG.warn("Unable to process an obtained item with value : '{}'. The JSON Object type is expected!", (Object)jsonValue);
            } else {
                LOG.warn("Unable to process an obtained item. The JSON Object type is expected!");
            }
        }
        return null;
    }

    public String getAsString(String name) {
        JsonValue jsonValue = this.jsonObject.get(name);
        return this.toString(jsonValue);
    }

    private String toString(JsonValue jsonValue) {
        if (jsonValue != null) {
            if (jsonValue instanceof JsonString) {
                return ((JsonString)jsonValue).getValue();
            }
            if (LOG.isDebugEnabled()) {
                LOG.warn("Unable to process an obtained item with value : '{}'. The JSON String type is expected!", (Object)jsonValue);
            } else {
                LOG.warn("Unable to process an obtained item. The JSON String type is expected!");
            }
        }
        return null;
    }

    public Number getAsNumber(String name) {
        JsonValue jsonValue = this.jsonObject.get(name);
        if (jsonValue != null) {
            if (jsonValue instanceof JsonNumber) {
                return ((JsonNumber)jsonValue).getValue();
            }
            if (LOG.isDebugEnabled()) {
                LOG.warn("Unable to process an obtained item with value : '{}'. The JSON Number type is expected!", (Object)jsonValue);
            } else {
                LOG.warn("Unable to process an obtained item. The JSON Number type is expected!");
            }
        }
        return null;
    }

    public List<JsonObjectWrapper> getAsObjectList(String name) {
        JsonValue jsonValue = this.jsonObject.get(name);
        if (jsonValue != null) {
            if (jsonValue instanceof JsonArray) {
                List elements = ((JsonArray)jsonValue).getElements();
                if (elements != null && !elements.isEmpty()) {
                    return elements.stream().map(this::toObject).filter(Objects::nonNull).collect(Collectors.toList());
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.warn("Unable to process an obtained item with value : '{}'. The JSON Array type is expected!", (Object)jsonValue);
            } else {
                LOG.warn("Unable to process an obtained item. The JSON Array type is expected!");
            }
        }
        return Collections.emptyList();
    }

    public List<String> getAsStringList(String name) {
        JsonValue jsonValue = this.jsonObject.get(name);
        if (jsonValue != null) {
            if (jsonValue instanceof JsonArray) {
                List elements = ((JsonArray)jsonValue).getElements();
                if (elements != null && !elements.isEmpty()) {
                    return elements.stream().map(this::toString).filter(Objects::nonNull).collect(Collectors.toList());
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.warn("Unable to process an obtained item with value : '{}'. The JSON Array type is expected!", (Object)jsonValue);
            } else {
                LOG.warn("Unable to process an obtained item. The JSON Array type is expected!");
            }
        }
        return Collections.emptyList();
    }

    public boolean isEmpty() {
        Map properties = this.jsonObject.getProperties();
        return properties == null || properties.isEmpty();
    }

    protected JsonObject getJsonObject() {
        return this.jsonObject;
    }
}

