/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jaxb.common;

import eu.europa.esig.dss.jaxb.common.DocumentBuilderFactoryBuilder;
import eu.europa.esig.dss.jaxb.common.SchemaFactoryBuilder;
import eu.europa.esig.dss.jaxb.common.TransformerFactoryBuilder;
import eu.europa.esig.dss.jaxb.common.ValidatorConfigurator;
import java.util.List;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;

public final class XmlDefinerUtils {
    private static XmlDefinerUtils singleton;
    private DocumentBuilderFactoryBuilder secureDocumentBuilderFactoryBuilder = DocumentBuilderFactoryBuilder.getSecureDocumentBuilderFactoryBuilder();
    private TransformerFactoryBuilder secureTransformerFactoryBuilder = TransformerFactoryBuilder.getSecureTransformerBuilder();
    private SchemaFactoryBuilder secureSchemaFactoryBuilder = SchemaFactoryBuilder.getSecureSchemaBuilder();
    private ValidatorConfigurator secureValidatorConfigurator = ValidatorConfigurator.getSecureValidatorConfigurator();

    private XmlDefinerUtils() {
    }

    public static XmlDefinerUtils getInstance() {
        if (singleton == null) {
            singleton = new XmlDefinerUtils();
        }
        return singleton;
    }

    public void setDocumentBuilderFactoryBuilder(DocumentBuilderFactoryBuilder documentBuilderFactoryBuilder) {
        this.secureDocumentBuilderFactoryBuilder = documentBuilderFactoryBuilder;
    }

    public DocumentBuilderFactory getSecureDocumentBuilderFactory() {
        return this.secureDocumentBuilderFactoryBuilder.build();
    }

    public Schema getSchema(List<Source> xsdSources) throws SAXException {
        Objects.requireNonNull(xsdSources, "XSD Source(s) must be provided");
        SchemaFactory sf = this.getSecureSchemaFactory();
        return sf.newSchema(xsdSources.toArray(new Source[xsdSources.size()]));
    }

    public void setSchemaFactoryBuilder(SchemaFactoryBuilder schemaFactoryBuilder) {
        this.secureSchemaFactoryBuilder = schemaFactoryBuilder;
    }

    public SchemaFactory getSecureSchemaFactory() {
        return this.secureSchemaFactoryBuilder.build();
    }

    public void setTransformerFactoryBuilder(TransformerFactoryBuilder transformerFactoryBuilder) {
        this.secureTransformerFactoryBuilder = transformerFactoryBuilder;
    }

    public TransformerFactory getSecureTransformerFactory() {
        return this.secureTransformerFactoryBuilder.build();
    }

    public void setValidatorConfigurator(ValidatorConfigurator validatorConfigurator) {
        this.secureValidatorConfigurator = validatorConfigurator;
    }

    public void configure(Validator validator) {
        this.secureValidatorConfigurator.configure(validator);
    }

    public void postProcess(Validator validator) {
        this.secureValidatorConfigurator.postProcess(validator);
    }
}

