/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.signature.resources;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.signature.resources.TempFileResourcesHandler;
import eu.europa.esig.dss.spi.signature.resources.DSSResourcesHandlerBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempFileResourcesHandlerBuilder
implements DSSResourcesHandlerBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(TempFileResourcesHandlerBuilder.class);
    private static final String DEFAULT_PREFIX = "dss-";
    private static final String DEFAULT_SUFFIX = ".tmp";
    private final List<TempFileResourcesHandler> handlers = new ArrayList<TempFileResourcesHandler>();
    private String fileNamePrefix = "dss-";
    private String fileNameSuffix = ".tmp";
    private File tempFileDirectory = new File(System.getProperty("java.io.tmpdir"));

    public TempFileResourcesHandlerBuilder setFileNamePrefix(String fileNamePrefix) {
        this.fileNamePrefix = fileNamePrefix;
        return this;
    }

    public TempFileResourcesHandlerBuilder setFileNameSuffix(String fileNameSuffix) {
        this.fileNameSuffix = fileNameSuffix;
        return this;
    }

    public TempFileResourcesHandlerBuilder setTempFileDirectory(File tempFileDirectory) {
        this.tempFileDirectory = tempFileDirectory;
        return this;
    }

    public TempFileResourcesHandler createResourcesHandler() {
        boolean dirCreated;
        if (!this.tempFileDirectory.exists() && !(dirCreated = this.tempFileDirectory.mkdirs())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("An occurred when trying to create a directory '{}'", (Object)this.tempFileDirectory.getAbsolutePath());
            }
            throw new DSSException(String.format("Unable to create TempFileResourcesHandler for a file with name '%s'!", this.tempFileDirectory.getName()));
        }
        TempFileResourcesHandler handler = new TempFileResourcesHandler(this.fileNamePrefix, this.fileNameSuffix, this.tempFileDirectory);
        this.handlers.add(handler);
        return handler;
    }

    public void clear() {
        for (TempFileResourcesHandler handler : this.handlers) {
            handler.forceDelete();
        }
        this.handlers.clear();
    }
}

