/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.timestamp;

import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.OfflineRevocationSource;
import eu.europa.esig.dss.validation.ListRevocationSource;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.timestamp.AbstractTimestampSource;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.ArrayList;
import java.util.List;

public class DetachedTimestampSource
extends AbstractTimestampSource {
    private final List<TimestampToken> detachedTimestamps = new ArrayList<TimestampToken>();
    private final ListCertificateSource certificateSource = new ListCertificateSource();
    private final ListRevocationSource<CRL> crlSource = new ListRevocationSource();
    private final ListRevocationSource<OCSP> ocspSource = new ListRevocationSource();

    public List<TimestampToken> getDetachedTimestamps() {
        return this.detachedTimestamps;
    }

    public void addExternalTimestamp(TimestampToken timestamp) {
        this.processExternalTimestamp(timestamp);
        this.detachedTimestamps.add(timestamp);
    }

    private void processExternalTimestamp(TimestampToken externalTimestamp) {
        this.certificateSource.add((CertificateSource)externalTimestamp.getCertificateSource());
        this.crlSource.add((OfflineRevocationSource<CRL>)externalTimestamp.getCRLSource());
        this.ocspSource.add((OfflineRevocationSource<OCSP>)externalTimestamp.getOCSPSource());
        ManifestFile manifestFile = externalTimestamp.getManifestFile();
        if (manifestFile != null) {
            for (TimestampToken timestampToken : this.detachedTimestamps) {
                if (!manifestFile.isDocumentCovered(timestampToken.getFileName())) continue;
                this.addReferences(externalTimestamp.getTimestampedReferences(), this.getReferencesFromTimestamp(timestampToken, this.certificateSource, this.crlSource, this.ocspSource));
            }
        }
    }
}

